/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.controllers.propertysources;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestCasePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.contentassist.TestDataCubeRefContentProposalProvider;
import org.eclipse.jubula.client.ui.controllers.propertydescriptors.ContentAssistedTextPropertyDescriptor;
import org.eclipse.jubula.client.ui.controllers.propertydescriptors.JBPropertyDescriptor;
import org.eclipse.jubula.client.ui.controllers.propertydescriptors.ParamTextPropertyDescriptor;
import org.eclipse.jubula.client.ui.controllers.propertysources.AbstractGuiNodePropertySource;
import org.eclipse.jubula.client.ui.controllers.propertysources.AbstractPropertySource;
import org.eclipse.jubula.client.ui.controllers.propertysources.SpecTestCaseGUIPropertySource;
import org.eclipse.jubula.client.ui.factory.TestDataControlFactory;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.provider.labelprovider.DisabledLabelProvider;
import org.eclipse.jubula.client.ui.provider.labelprovider.ParameterValueLabelProvider;
import org.eclipse.jubula.client.ui.validator.TestDataCubeReferenceValidator;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.jubula.tools.xml.businessmodell.ParamValueSet;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecTestCaseGUIPropertySource
extends SpecTestCaseGUIPropertySource {
    public static final Image ORIGINAL_DATA_IMAGE = IconConstants.ORIGINAL_DATA_IMAGE;
    public static final Image OVERWRITTEN_DATA_IMAGE = IconConstants.OVERWRITTEN_DATA_IMAGE;
    public static final String P_SPECNAME_DISPLAY_NAME = Messages.ExecTestCaseGUIPropertySourceSpecificationName;
    public static final String P_REFERNCE_DISPLAY_NAME = Messages.ExecTestCaseGUIPropertySourceTestCaseReferenceName;
    private IPropertyDescriptor m_namePropDesc = null;
    private IPropertyDescriptor m_specNamePropDesc = null;
    private IPropertyDescriptor m_commentPropDesc = null;
    private PropertyDescriptor m_extDataPropDesc = null;
    private PropertyDescriptor m_referencedCubePropDesc = null;
    private List<IPropertyDescriptor> m_paramPropDescList = new ArrayList<IPropertyDescriptor>();

    public ExecTestCaseGUIPropertySource(IExecTestCasePO testCase) {
        super((ITestCasePO)testCase);
    }

    @Override
    protected void initPropDescriptor() {
        if (!this.getPropertyDescriptorList().isEmpty()) {
            this.clearPropertyDescriptors();
        }
        if (this.m_namePropDesc == null) {
            this.m_namePropDesc = new TextPropertyDescriptor((Object)new ExecNameController(), P_REFERNCE_DISPLAY_NAME);
        }
        this.addPropertyDescriptor(this.m_namePropDesc);
        if (this.m_specNamePropDesc == null) {
            JBPropertyDescriptor propDes = new JBPropertyDescriptor(new SpecNameController(), P_SPECNAME_DISPLAY_NAME);
            propDes.setLabelProvider((ILabelProvider)new DisabledLabelProvider());
            this.m_specNamePropDesc = propDes;
        }
        this.addPropertyDescriptor(this.m_specNamePropDesc);
        if (this.m_commentPropDesc == null) {
            this.m_commentPropDesc = new TextPropertyDescriptor((Object)new AbstractGuiNodePropertySource.CommentController(), P_ELEMENT_DISPLAY_COMMENT);
        }
        this.addPropertyDescriptor(this.m_commentPropDesc);
        this.addPropertyDescriptor(this.getDataSourcePropertyDescr(new ExecTestCaseTestDataSourceController((AbstractGuiNodePropertySource)this)));
        if (this.m_extDataPropDesc == null) {
            this.m_extDataPropDesc = new TextPropertyDescriptor((Object)new SpecTestCaseGUIPropertySource.ExternalDataController(this, this), P_ELEMENT_DISPLAY_DATEFILE);
            this.m_extDataPropDesc.setCategory(P_TESTDATA_CAT);
        }
        this.addPropertyDescriptor((IPropertyDescriptor)this.m_extDataPropDesc);
        if (this.m_referencedCubePropDesc == null) {
            IProjectPO activeProject = GeneralStorage.getInstance().getProject();
            TestDataCubeRefContentProposalProvider dataCubeRefProposalProvider = null;
            TestDataCubeReferenceValidator dataCubeRefValidator = null;
            if (activeProject != null) {
                dataCubeRefProposalProvider = new TestDataCubeRefContentProposalProvider(activeProject, (IParameterInterfacePO)this.getPoNode());
                dataCubeRefValidator = new TestDataCubeReferenceValidator(activeProject);
            }
            this.m_referencedCubePropDesc = new ContentAssistedTextPropertyDescriptor(new SpecTestCaseGUIPropertySource.ReferenceTestDataController(this, this), P_ELEMENT_DISPLAY_REFDATA, dataCubeRefProposalProvider, dataCubeRefValidator, 2);
            this.m_referencedCubePropDesc.setCategory(P_TESTDATA_CAT);
        }
        this.addPropertyDescriptor((IPropertyDescriptor)this.m_referencedCubePropDesc);
        this.addPropertyDescriptor(this.createParamDescriptors());
    }

    protected List<IPropertyDescriptor> createParamDescriptors() {
        if (this.m_paramPropDescList.isEmpty()) {
            IParamNodePO paramNodePO = (IParamNodePO)this.getPoNode();
            List paramList = paramNodePO.getParameterList();
            IParamNameMapper activeParamNameMapper = this.getActiveParamNameMapper();
            for (IParamDescriptionPO paramDescr : paramList) {
                JBPropertyDescriptor propDes = new JBPropertyDescriptor(new SpecTestCaseGUIPropertySource.ParameterNameController(this, paramDescr), P_ELEMENT_DISPLAY_PARAMETERNAME);
                propDes.setLabelProvider((ILabelProvider)new DisabledLabelProvider());
                propDes.setCategory(P_PARAMETER_CAT);
                this.m_paramPropDescList.add((IPropertyDescriptor)propDes);
                propDes = new JBPropertyDescriptor(new SpecTestCaseGUIPropertySource.ParameterTypeController(this, paramDescr), P_ELEMENT_DISPLAY_PARAMETERTYPE);
                propDes.setLabelProvider((ILabelProvider)new DisabledLabelProvider());
                propDes.setCategory(P_PARAMETER_CAT);
                this.m_paramPropDescList.add((IPropertyDescriptor)propDes);
                ParamValueSet valueSet = ParamTextPropertyDescriptor.getValuesSet(paramNodePO, paramDescr.getUniqueId());
                propDes = TestDataControlFactory.createValuePropertyDescriptor(new ParameterValueController((AbstractGuiNodePropertySource)this, paramDescr, activeParamNameMapper), P_ELEMENT_DISPLAY_PARAMETERVALUE, ParamTextPropertyDescriptor.getValues(valueSet), valueSet != null ? valueSet.isCombinable() : false);
                propDes.setCategory(P_PARAMETER_CAT);
                propDes.setLabelProvider((ILabelProvider)new ParameterValueLabelProvider(INCOMPL_DATA_IMAGE));
                this.m_paramPropDescList.add((IPropertyDescriptor)propDes);
                propDes = new JBPropertyDescriptor((AbstractPropertySource)this.new AbstractPropertySource.DummyController(), "");
                propDes.setCategory(P_PARAMETER_CAT);
                this.m_paramPropDescList.add((IPropertyDescriptor)propDes);
            }
        }
        return this.m_paramPropDescList;
    }

    protected class ExecNameController
    extends AbstractGuiNodePropertySource.ElementNameController {
        protected ExecNameController() {
        }

        public Object getProperty() {
            IExecTestCasePO exTc;
            String name;
            if (ExecTestCaseGUIPropertySource.this.getPoNode() != null && (name = (exTc = (IExecTestCasePO)ExecTestCaseGUIPropertySource.this.getPoNode()).getRealName()) != null) {
                return name;
            }
            return "";
        }
    }

    public class ExecTestCaseTestDataSourceController
    extends SpecTestCaseGUIPropertySource.SpecTestCaseTestDataSourceController {
        protected static final String DATA_SOURCE_REFERENCED = "TestDataSource.spec";

        public ExecTestCaseTestDataSourceController(AbstractGuiNodePropertySource s) {
            super(ExecTestCaseGUIPropertySource.this, s);
            this.getDataSource().add(DATA_SOURCE_REFERENCED);
        }

        public Object getProperty() {
            this.getPropertySource().setReadOnly(true);
            if (ExecTestCaseGUIPropertySource.this.getPoNode() instanceof IParamNodePO) {
                IParamNodePO node = (IParamNodePO)ExecTestCaseGUIPropertySource.this.getPoNode();
                String dataSource = this.getDataSource(node);
                if (dataSource == "TestDataSource.unkown" && node instanceof IExecTestCasePO) {
                    IExecTestCasePO exec = (IExecTestCasePO)node;
                    this.getPropertySource().setReadOnly(false);
                    if (exec.getHasReferencedTD()) {
                        return this.getDataSource().indexOf(DATA_SOURCE_REFERENCED);
                    }
                    return this.getDataSource().indexOf("TestDataSource.local");
                }
                return this.getDataSource().indexOf(dataSource);
            }
            return this.getDataSource().indexOf("TestDataSource.unkown");
        }

        public String[] getUserChoosableDataSource() {
            if (this.getUserChoosableValues().isEmpty()) {
                this.getUserChoosableValues().add(I18n.getString((String)"TestDataSource.local"));
                this.getUserChoosableValues().add(I18n.getString((String)DATA_SOURCE_REFERENCED));
            }
            return this.getUserChoosableValues().toArray(new String[this.getUserChoosableValues().size()]);
        }

        public boolean setProperty(Object value) {
            IParamNodePO node;
            if (ExecTestCaseGUIPropertySource.this.getPoNode() instanceof IParamNodePO && (node = (IParamNodePO)ExecTestCaseGUIPropertySource.this.getPoNode()) instanceof IExecTestCasePO) {
                IExecTestCasePO exec = (IExecTestCasePO)node;
                int index = Integer.valueOf(String.valueOf(value));
                if (index >= 0) {
                    boolean isLocal;
                    String newDataSource = this.getUserChoosableValues().get(index);
                    boolean shouldBeLocal = newDataSource == I18n.getString((String)"TestDataSource.local");
                    boolean bl = isLocal = !exec.getHasReferencedTD();
                    if (shouldBeLocal == isLocal) {
                        return false;
                    }
                    if (shouldBeLocal) {
                        exec.resolveTDReference();
                    } else {
                        exec.setHasReferencedTD(true);
                    }
                    DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)node, DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
                    return true;
                }
            }
            return false;
        }
    }

    public class ParameterValueController
    extends AbstractGuiNodePropertySource.AbstractParamValueController {
        public ParameterValueController(AbstractGuiNodePropertySource s, IParamDescriptionPO paramDescr, IParamNameMapper paramNameMapper) {
            super(s, paramDescr, paramNameMapper);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecNameController
    extends AbstractPropertySource.AbstractPropertyController {
        protected SpecNameController() {
        }

        @Override
        public boolean setProperty(Object value) {
            return true;
        }

        @Override
        public Object getProperty() {
            IExecTestCasePO exTc = (IExecTestCasePO)ExecTestCaseGUIPropertySource.this.getPoNode();
            if (exTc.getSpecTestCase() != null) {
                return exTc.getSpecTestCase().getName();
            }
            return "";
        }

        @Override
        public Image getImage() {
            return READONLY_IMAGE;
        }
    }
}

