/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.controllers.propertysources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.ui.controllers.propertysources.AbstractGuiNodePropertySource;
import org.eclipse.jubula.client.ui.controllers.propertysources.AbstractPropertySource;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.tools.exception.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class RefTestSuiteGUIPropertySource
extends AbstractGuiNodePropertySource {
    private static final String P_REF_TS_DISPLAY_NAME = Messages.RefTestSuiteGUIPropertySourceRefTSName;
    private static final String P_AUT_ID_DISPLAY_NAME = Messages.RefTestSuiteGUIPropertySourceAutIdName;
    private String[] m_autIdList = new String[0];
    private IPropertyDescriptor m_autIdPropDesc = null;
    private IPropertyDescriptor m_namePropDesc = null;

    public RefTestSuiteGUIPropertySource(IRefTestSuitePO reftestsuiteGui) {
        super((INodePO)reftestsuiteGui);
        this.fillAutIdList(reftestsuiteGui);
    }

    private void fillAutIdList(IRefTestSuitePO refTestSuite) {
        HashSet<String> idSet = new HashSet<String>();
        ITestSuitePO ts = NodePM.getTestSuite((String)refTestSuite.getTestSuiteGuid());
        IAUTMainPO aut = ts.getAut();
        if (aut != null) {
            idSet.addAll(aut.getAutIds());
            for (IAUTConfigPO conf : aut.getAutConfigSet()) {
                idSet.add(conf.getValue("AUT_ID", ""));
            }
        }
        ArrayList idList = new ArrayList(idSet);
        Collections.sort(idList);
        this.m_autIdList = idList.toArray(new String[idList.size()]);
    }

    protected void initPropDescriptor() {
        if (!this.getPropertyDescriptorList().isEmpty()) {
            this.clearPropertyDescriptors();
        }
        if (this.m_namePropDesc == null) {
            this.m_namePropDesc = new TextPropertyDescriptor((Object)new AbstractGuiNodePropertySource.ElementNameController(), P_REF_TS_DISPLAY_NAME);
        }
        this.addPropertyDescriptor(this.m_namePropDesc);
        super.initPropDescriptor();
        this.addPropertyDescriptor(this.getAutIdPropDesc());
    }

    private IPropertyDescriptor getAutIdPropDesc() {
        if (this.m_autIdPropDesc == null) {
            ComboBoxPropertyDescriptor cbpd = new ComboBoxPropertyDescriptor((Object)new AutIdController(), P_AUT_ID_DISPLAY_NAME, this.m_autIdList);
            cbpd.setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof Integer) {
                        if (RefTestSuiteGUIPropertySource.this.m_autIdList.length == 0 || (Integer)element == -1) {
                            return "";
                        }
                        return RefTestSuiteGUIPropertySource.this.m_autIdList[(Integer)element];
                    }
                    Assert.notReached((String)(String.valueOf(Messages.WrongElementType) + "."));
                    return String.valueOf(element);
                }
            });
            this.m_autIdPropDesc = cbpd;
        }
        return this.m_autIdPropDesc;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AutIdController
    extends AbstractPropertySource.AbstractPropertyController {
        private AutIdController() {
        }

        @Override
        public boolean setProperty(Object value) {
            IRefTestSuitePO refTestSuite = (IRefTestSuitePO)RefTestSuiteGUIPropertySource.this.getPoNode();
            if (!(value instanceof String)) {
                if (value instanceof Integer) {
                    int pos = (Integer)value;
                    if (RefTestSuiteGUIPropertySource.this.m_autIdList.length > pos && pos >= 0) {
                        refTestSuite.setTestSuiteAutID(RefTestSuiteGUIPropertySource.this.m_autIdList[pos]);
                        return true;
                    }
                } else {
                    return false;
                }
            }
            refTestSuite.setTestSuiteAutID((String)value);
            return true;
        }

        @Override
        public Object getProperty() {
            IRefTestSuitePO refTestSuite = (IRefTestSuitePO)RefTestSuiteGUIPropertySource.this.getPoNode();
            String autID = refTestSuite.getTestSuiteAutID();
            int i = 0;
            while (i < RefTestSuiteGUIPropertySource.this.m_autIdList.length) {
                if (RefTestSuiteGUIPropertySource.this.m_autIdList[i].equals(autID)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        @Override
        public Image getImage() {
            return DEFAULT_IMAGE;
        }
    }
}

