/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.controllers.propertysources;

import java.util.Date;
import java.util.Set;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ITestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.controllers.propertydescriptors.JBPropertyDescriptor;
import org.eclipse.jubula.client.ui.controllers.propertysources.AbstractPropertySource;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.tools.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.jubula.tools.objects.event.TestErrorEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestResultNodeGUIPropertySource
extends AbstractPropertySource<TestResultNode> {
    public static final String P_TESTSTEP_CAT = Messages.TestResultNodeGUIPropertySourceResultStep;
    public static final String P_ELEMENT_DISPLAY_STEPNAME = Messages.TestResultNodeGUIPropertySourceStepName;
    public static final String P_ELEMENT_DISPLAY_STEPTYPE = Messages.TestResultNodeGUIPropertySourceStepType;
    public static final String P_TESTRESULT_CAT = Messages.TestResultNodeGUIPropertySourceTestResult;
    public static final String P_ELEMENT_DISPLAY_TIMESTAMP = Messages.TestResultNodeGUIPropertySourceTimeStamp;
    public static final String P_ELEMENT_DISPLAY_STEPSTATUS = Messages.TestResultNodeGUIPropertySourceStepStatus;
    public static final String P_TESTERROR_CAT = Messages.TestResultNodeGUIPropertySourceErrorDetail;
    public static final String P_ELEMENT_DISPLAY_ERRORTYPE = Messages.TestResultNodeGUIPropertySourceErrorType;
    public static final String P_CAP_CAT = Messages.TestResultNodeGUIPropertySourceCapDetail;
    public static final String P_ELEMENT_DISPLAY_CAPCOMMENT = Messages.TestResultNodeGUIPropertySourceComment;
    public static final String P_ELEMENT_DISPLAY_COMPNAME = Messages.CapGUIPropertySourceComponentName;
    public static final String P_ELEMENT_DISPLAY_ACTIONTYPE = Messages.CapGUIPropertySourceActionType;
    public static final String P_ELEMENT_DISPLAY_COMPTYPE = Messages.CapGUIPropertySourceCompType;
    public static final String P_ELEMENT_DISPLAY_PARAMETERNAME = Messages.CapGUIPropertySourceParamName;
    public static final String P_ELEMENT_DISPLAY_PARAMETERVALUE = Messages.CapGUIPropertySourceParamValue;
    public static final String P_ELEMENT_DISPLAY_PARAMETERTYPE = Messages.CapGUIPropertySourceParamType;

    public TestResultNodeGUIPropertySource(TestResultNode node) {
        super(node);
        this.initPropDescriptor();
    }

    @Override
    protected void initPropDescriptor() {
        this.clearPropertyDescriptors();
        final INodePO node = ((TestResultNode)this.getGuiNode()).getNode();
        JBPropertyDescriptor propDes = new JBPropertyDescriptor(new ComponentController(){

            public Object getProperty() {
                TestResultNode cap = (TestResultNode)TestResultNodeGUIPropertySource.this.getGuiNode();
                Date time = cap.getTimeStamp();
                if (time != null) {
                    String timeStamp = time.toString();
                    return timeStamp;
                }
                return "";
            }
        }, P_ELEMENT_DISPLAY_TIMESTAMP);
        propDes.setCategory(P_TESTSTEP_CAT);
        this.addPropertyDescriptor((IPropertyDescriptor)propDes);
        propDes = new JBPropertyDescriptor(new ComponentController(){

            public Object getProperty() {
                return ((TestResultNode)TestResultNodeGUIPropertySource.this.getGuiNode()).getName();
            }
        }, P_ELEMENT_DISPLAY_STEPNAME);
        propDes.setCategory(P_TESTSTEP_CAT);
        this.addPropertyDescriptor((IPropertyDescriptor)propDes);
        propDes = new JBPropertyDescriptor(new ComponentController(){

            public Object getProperty() {
                if (Persistor.isPoSubclass((IPersistentObject)node, IEventExecTestCasePO.class)) {
                    return Messages.TestResultNodeGUIPropertySourceEventTestCase;
                }
                if (Persistor.isPoSubclass((IPersistentObject)node, ITestCasePO.class)) {
                    return Messages.TestResultNodeGUIPropertySourceTestCase;
                }
                if (Persistor.isPoSubclass((IPersistentObject)node, ICapPO.class)) {
                    return Messages.TestResultNodeGUIPropertySourceTestStep;
                }
                if (Persistor.isPoSubclass((IPersistentObject)node, ITestSuitePO.class)) {
                    return Messages.TestResultNodeGUIPropertySourceTestSuite;
                }
                return Messages.TestResultNodeGUIPropertySourceUnknownElement;
            }

            public Image getImage() {
                return TestResultNodeGUIPropertySource.this.getImageForNode(node);
            }
        }, P_ELEMENT_DISPLAY_STEPTYPE);
        propDes.setCategory(P_TESTSTEP_CAT);
        this.addPropertyDescriptor((IPropertyDescriptor)propDes);
        propDes = new JBPropertyDescriptor(new ComponentController(){

            public Object getProperty() {
                return node == null || node.getComment() == null ? "" : node.getComment();
            }
        }, P_ELEMENT_DISPLAY_CAPCOMMENT);
        propDes.setCategory(P_TESTSTEP_CAT);
        this.addPropertyDescriptor((IPropertyDescriptor)propDes);
        this.insertEmptyRow(P_TESTSTEP_CAT);
        this.initResultDetailsPropDesc();
        if (Persistor.isPoSubclass((IPersistentObject)node, IEventExecTestCasePO.class)) {
            this.initEventTestCasePropDescriptor(node);
        }
        if (((TestResultNode)this.getGuiNode()).getEvent() != null) {
            this.initErrorEventPropDescriptor();
        }
        if (Persistor.isPoSubclass((IPersistentObject)node, ICapPO.class)) {
            this.initCapDetailsPropDescriptor();
        }
    }

    private Image getImageForNode(INodePO node) {
        Image image = null;
        if (Persistor.isPoSubclass((IPersistentObject)node, ITestSuitePO.class)) {
            image = IconConstants.TS_IMAGE;
        }
        if (Persistor.isPoSubclass((IPersistentObject)node, IExecTestCasePO.class)) {
            image = Persistor.isPoSubclass((IPersistentObject)node, IEventExecTestCasePO.class) ? IconConstants.RESULT_EH_IMAGE : IconConstants.TC_IMAGE;
        }
        if (Persistor.isPoSubclass((IPersistentObject)node, ICapPO.class)) {
            TestResultNode parent = ((TestResultNode)this.getGuiNode()).getParent();
            image = Persistor.isPoSubclass((IPersistentObject)parent.getNode(), IEventExecTestCasePO.class) ? IconConstants.EH_CAP_IMAGE : IconConstants.CAP_IMAGE;
        }
        return image;
    }

    private void initResultDetailsPropDesc() {
        JBPropertyDescriptor propDes = new JBPropertyDescriptor(new ComponentController(){

            public Object getProperty() {
                return ((TestResultNode)TestResultNodeGUIPropertySource.this.getGuiNode()).getStatusString();
            }

            public Image getImage() {
                int status = ((TestResultNode)TestResultNodeGUIPropertySource.this.getGuiNode()).getStatus();
                switch (status) {
                    case 1: {
                        return IconConstants.STEP_OK_IMAGE;
                    }
                    case 2: 
                    case 5: {
                        return IconConstants.STEP_NOT_OK_IMAGE;
                    }
                    case 7: {
                        return IconConstants.STEP_RETRY_IMAGE;
                    }
                    case 8: {
                        return IconConstants.STEP_RETRY_OK_IMAGE;
                    }
                    case 9: {
                        return IconConstants.STEP_NOT_OK_IMAGE;
                    }
                }
                return null;
            }
        }, P_ELEMENT_DISPLAY_STEPSTATUS);
        propDes.setCategory(P_TESTRESULT_CAT);
        this.addPropertyDescriptor((IPropertyDescriptor)propDes);
        this.insertEmptyRow(P_TESTRESULT_CAT);
    }

    private void initCapDetailsPropDescriptor() {
        final ICapPO node = (ICapPO)((TestResultNode)this.getGuiNode()).getNode();
        JBPropertyDescriptor propDes = new JBPropertyDescriptor(new ComponentController(){

            public Object getProperty() {
                return ((TestResultNode)TestResultNodeGUIPropertySource.this.getGuiNode()).getComponentName();
            }
        }, P_ELEMENT_DISPLAY_COMPNAME);
        propDes.setCategory(P_CAP_CAT);
        this.addPropertyDescriptor((IPropertyDescriptor)propDes);
        propDes = new JBPropertyDescriptor(new ComponentController(){

            public Object getProperty() {
                return CompSystemI18n.getString((String)node.getComponentType(), (boolean)true);
            }
        }, P_ELEMENT_DISPLAY_COMPTYPE);
        propDes.setCategory(P_CAP_CAT);
        this.addPropertyDescriptor((IPropertyDescriptor)propDes);
        this.insertEmptyRow(P_CAP_CAT);
        propDes = new JBPropertyDescriptor(new ComponentController(){

            public Object getProperty() {
                return CompSystemI18n.getString((String)node.getActionName());
            }
        }, P_ELEMENT_DISPLAY_ACTIONTYPE);
        propDes.setCategory(P_CAP_CAT);
        this.addPropertyDescriptor((IPropertyDescriptor)propDes);
        int index = 0;
        this.insertEmptyRow(P_CAP_CAT);
        for (final IParamDescriptionPO desc : node.getParameterList()) {
            propDes = new JBPropertyDescriptor(new ComponentController(){

                public Object getProperty() {
                    return CompSystemI18n.getString((String)desc.getUniqueId(), (boolean)true);
                }
            }, P_ELEMENT_DISPLAY_PARAMETERNAME);
            propDes.setCategory(P_CAP_CAT);
            this.addPropertyDescriptor((IPropertyDescriptor)propDes);
            propDes = new JBPropertyDescriptor(new ComponentController(){

                public Object getProperty() {
                    return CompSystemI18n.getString((String)desc.getType());
                }
            }, P_ELEMENT_DISPLAY_PARAMETERTYPE);
            propDes.setCategory(P_CAP_CAT);
            this.addPropertyDescriptor((IPropertyDescriptor)propDes);
            propDes = this.createPropDescriptorForParamValue(index);
            this.addPropertyDescriptor((IPropertyDescriptor)propDes);
            ++index;
            this.insertEmptyRow(P_CAP_CAT);
        }
    }

    private JBPropertyDescriptor createPropDescriptorForParamValue(final int index) {
        JBPropertyDescriptor propDes = new JBPropertyDescriptor(new ComponentController(){

            public Object getProperty() {
                if (((TestResultNode)TestResultNodeGUIPropertySource.this.getGuiNode()).getParamValues().size() >= index + 1) {
                    String returnVal = (String)((TestResultNode)TestResultNodeGUIPropertySource.this.getGuiNode()).getParamValues().get(index);
                    if (returnVal != null && returnVal.length() == 0) {
                        return "''";
                    }
                    return returnVal == null ? "" : returnVal;
                }
                return "";
            }
        }, P_ELEMENT_DISPLAY_PARAMETERVALUE);
        propDes.setCategory(P_CAP_CAT);
        return propDes;
    }

    private void insertEmptyRow(String cat) {
        JBPropertyDescriptor propDes = new JBPropertyDescriptor(new ComponentController(){

            public Object getProperty() {
                return "";
            }
        }, "");
        propDes.setCategory(cat);
        this.addPropertyDescriptor((IPropertyDescriptor)propDes);
    }

    private void initErrorEventPropDescriptor() {
        JBPropertyDescriptor propDes = new JBPropertyDescriptor(new ComponentController(){

            public Object getProperty() {
                return I18n.getString((String)((TestResultNode)TestResultNodeGUIPropertySource.this.getGuiNode()).getEvent().getId());
            }
        }, P_ELEMENT_DISPLAY_ERRORTYPE);
        propDes.setCategory(P_TESTERROR_CAT);
        this.addPropertyDescriptor((IPropertyDescriptor)propDes);
        final TestErrorEvent event = ((TestResultNode)this.getGuiNode()).getEvent();
        if (event.getId().equals("TestErrorEvent.VerifyFailed")) {
            Set keys = event.getProps().keySet();
            for (final Object key : keys) {
                propDes = new JBPropertyDescriptor(new ComponentController(){

                    public Object getProperty() {
                        return event.getProps().get(key);
                    }
                }, I18n.getString((String)((String)key)));
                propDes.setCategory(P_TESTERROR_CAT);
                this.addPropertyDescriptor((IPropertyDescriptor)propDes);
            }
        } else if (event.getId().equals("TestErrorEvent.Action") && event.getProps().keySet().contains("guidancerErrorDescription")) {
            propDes = new JBPropertyDescriptor(new ComponentController(){

                public Object getProperty() {
                    String key = (String)event.getProps().get("guidancerErrorDescription");
                    Object[] args = (Object[])event.getProps().get("guidancerErrorParameter");
                    if (args != null) {
                        return I18n.getString((String)key, (Object[])args);
                    }
                    return I18n.getString((String)key, (boolean)true);
                }
            }, I18n.getString((String)"guidancerErrorDescription"));
            propDes.setCategory(P_TESTERROR_CAT);
            this.addPropertyDescriptor((IPropertyDescriptor)propDes);
        }
        this.insertEmptyRow(P_TESTERROR_CAT);
    }

    private void initEventTestCasePropDescriptor(INodePO node) {
        final IEventExecTestCasePO tc = (IEventExecTestCasePO)node;
        JBPropertyDescriptor propDes = new JBPropertyDescriptor(new ComponentController(){

            public Object getProperty() {
                return I18n.getString((String)tc.getEventType());
            }
        }, Messages.TestResultNodeGUIPropertySourceErrorType);
        propDes.setCategory(Messages.TestResultNodeGUIPropertySourceEventhandler);
        this.addPropertyDescriptor((IPropertyDescriptor)propDes);
        propDes = new JBPropertyDescriptor(new ComponentController(){

            public Object getProperty() {
                return tc.getReentryProp();
            }
        }, Messages.TestResultNodeGUIPropertySourceReentry);
        propDes.setCategory(Messages.TestResultNodeGUIPropertySourceEventhandler);
        this.addPropertyDescriptor((IPropertyDescriptor)propDes);
        this.insertEmptyRow(Messages.TestResultNodeGUIPropertySourceEventhandler);
    }

    public boolean isPropertySet(Object id) {
        boolean isPropSet = false;
        return isPropSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ComponentController
    extends AbstractPropertySource.AbstractPropertyController {
        private ComponentController() {
        }

        @Override
        public boolean setProperty(Object value) {
            return true;
        }

        @Override
        public abstract Object getProperty();

        @Override
        public Image getImage() {
            return null;
        }
    }
}

