/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.LanguageHelper;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.utils.Languages;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.constants.Layout;
import org.eclipse.jubula.client.ui.databinding.validators.AutIdValidator;
import org.eclipse.jubula.client.ui.dialogs.AUTConfigPropertiesDialog;
import org.eclipse.jubula.client.ui.dialogs.NagDialog;
import org.eclipse.jubula.client.ui.factory.ControlFactory;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.provider.ControlDecorator;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.utils.Utils;
import org.eclipse.jubula.client.ui.widgets.AutIdListComposite;
import org.eclipse.jubula.client.ui.widgets.CheckedRequiredText;
import org.eclipse.jubula.client.ui.widgets.DirectCombo;
import org.eclipse.jubula.client.ui.widgets.JBText;
import org.eclipse.jubula.client.ui.widgets.ListElementChooserComposite;
import org.eclipse.jubula.client.ui.wizards.pages.AUTSettingWizardPage;
import org.eclipse.jubula.toolkit.common.exception.ToolkitPluginException;
import org.eclipse.jubula.tools.exception.Assert;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AUTPropertiesDialog
extends TitleAreaDialog {
    private static final int NUM_COLUMNS_1 = 1;
    private static final int NUM_COLUMNS_2 = 2;
    private static final int NUM_COLUMNS_3 = 3;
    private static final int LINES_5 = 5;
    private List m_availableLangList;
    private List m_autLangList;
    private Button m_addButton = null;
    private Button m_removeButton = null;
    private Button m_editButton = null;
    private Button m_duplicateButton = null;
    private Text m_autNameText;
    private DirectCombo<String> m_autToolKitComboBox;
    private Button m_generateNames;
    private List m_autConfigList;
    private IAUTMainPO m_autMain;
    private final String m_origAUTName;
    private boolean m_edit = false;
    private final WidgetSelectionListener m_selectionListener = new WidgetSelectionListener();
    private final WidgetVerifyListener m_verifyListener = new WidgetVerifyListener();
    private ListElementChooserComposite m_chooseLists;
    private final WidgetModifyListener m_modifyListener = new WidgetModifyListener();
    private IProjectPO m_project;

    public AUTPropertiesDialog(Shell parentShell, boolean edit, IAUTMainPO autMain, IProjectPO project) {
        super(parentShell);
        this.m_project = project;
        this.m_edit = edit;
        this.m_autMain = autMain == null ? PoMaker.createAUTMainPO((String)"") : autMain;
        this.m_origAUTName = this.m_autMain.getName();
    }

    protected Control createDialogArea(Composite parent) {
        ScrolledComposite scroll = new ScrolledComposite(parent, 768);
        scroll.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite = this.newComposite((Composite)scroll, 3, 4);
        Composite leftComposite = this.newComposite(composite, 3, 1);
        Composite rightComposite = this.newComposite(composite, 1, 1);
        this.createAUTNameEditor(leftComposite);
        this.createAutToolkitCombo(leftComposite);
        this.m_autConfigList = this.newListField(leftComposite, Messages.AUTPropertiesDialogAutConfigListText, 5);
        this.createAutConfigButtons(rightComposite);
        this.createGenerateNamesCheckBox(leftComposite);
        this.separator(leftComposite);
        this.createAutIdList(leftComposite);
        this.separator(leftComposite);
        this.newLabel(leftComposite, "");
        this.newLabel(leftComposite, "");
        this.newLabel(leftComposite, "");
        Composite innerComposite = new Composite(leftComposite, 0);
        GridLayout innerCompositeLayout = new GridLayout();
        innerCompositeLayout.numColumns = 1;
        innerCompositeLayout.marginHeight = 0;
        innerCompositeLayout.marginWidth = 0;
        innerComposite.setLayout((org.eclipse.swt.widgets.Layout)innerCompositeLayout);
        GridData innerCompositeData = new GridData();
        innerCompositeData.horizontalSpan = 2;
        innerCompositeData.horizontalAlignment = 4;
        innerCompositeData.grabExcessHorizontalSpace = true;
        innerComposite.setLayoutData((Object)innerCompositeData);
        this.createLanguageLists(innerComposite);
        this.getObjects();
        this.addListener();
        this.resizeLists();
        if (this.m_edit) {
            this.initFields();
        } else {
            if (this.m_autToolKitComboBox.getItemCount() == 1) {
                this.m_autToolKitComboBox.select(0);
            } else {
                this.m_autToolKitComboBox.deselectAll();
                this.m_autToolKitComboBox.clearSelection();
            }
            if ("com.bredexsw.guidancer.RcpToolkitPlugin".equals(this.m_autToolKitComboBox.getSelectedObject())) {
                this.m_generateNames.setEnabled(true);
                this.m_generateNames.setSelection(true);
                this.m_autMain.setGenerateNames(true);
            } else {
                this.m_generateNames.setEnabled(false);
                this.m_generateNames.setSelection(false);
            }
            this.enableOKButton(false);
        }
        this.m_chooseLists.checkButtons();
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.guidancerAutConfigurationContextId");
        this.setTitle(Messages.ProjectWizardAutSettings);
        scroll.setContent((Control)composite);
        scroll.setMinSize(composite.computeSize(-1, -1));
        scroll.setExpandHorizontal(true);
        scroll.setExpandVertical(true);
        return scroll;
    }

    /*
     * Unable to fully structure code
     */
    private void createLanguageLists(Composite innerComposite) {
        block3: {
            langUtil = Languages.getInstance();
            leftList = new ArrayList<String>();
            rightList = new ArrayList<String>();
            iter = this.m_project.getLangHelper().getLangListIterator();
            if (!this.m_edit) ** GOTO lbl18
            while (iter.hasNext()) {
                leftList.add(langUtil.getDisplayString((Locale)iter.next()));
            }
            iter = this.m_autMain.getLangHelper().getLangListIterator();
            while (iter.hasNext()) {
                rightList.add(langUtil.getDisplayString((Locale)iter.next()));
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                rightList.add(langUtil.getDisplayString((Locale)iter.next()));
lbl18:
                // 2 sources

                ** while (iter.hasNext())
            }
        }
        this.m_chooseLists = new ListElementChooserComposite(innerComposite, Messages.AUTPropertiesDialogUpperLabel, leftList, Messages.AUTPropertiesDialogBottomLabel, rightList, 15, new Image[]{IconConstants.RIGHT_ARROW_IMAGE, IconConstants.DOUBLE_RIGHT_ARROW_IMAGE, IconConstants.LEFT_ARROW_IMAGE, IconConstants.DOUBLE_LEFT_ARROW_IMAGE}, new Image[]{IconConstants.RIGHT_ARROW_DIS_IMAGE, IconConstants.DOUBLE_RIGHT_ARROW_DIS_IMAGE, IconConstants.LEFT_ARROW_DIS_IMAGE, IconConstants.DOUBLE_LEFT_ARROW_DIS_IMAGE}, new String[]{Messages.AUTSettingWizardPageDownToolTip, Messages.AUTSettingWizardPageAllDownToolTip, Messages.AUTSettingWizardPageUpToolTip, Messages.AUTSettingWizardPageAllUpToolTip}, 1);
    }

    private void checkForErrors() {
        boolean error = false;
        if (!(error |= this.modifyAUTNameFieldAction())) {
            error |= this.modifyAUTToolkitComboAction();
        }
        if (error) {
            this.enableOKButton(false);
        } else {
            this.setMessage(null);
            this.enableOKButton(true);
        }
    }

    private boolean modifyAUTNameFieldAction() {
        boolean isError = false;
        String autName = this.m_autNameText.getText();
        if (!isError) {
            for (IAUTMainPO aut : this.m_project.getAutMainList()) {
                if (!this.m_edit) {
                    if (!aut.getName().equals(this.m_autNameText.getText())) continue;
                    this.setMessage(Messages.AUTPropertiesDialogDoubleAUTName, 3);
                    isError |= true;
                    continue;
                }
                if (!aut.getName().equals(this.m_autNameText.getText()) || this.m_autNameText.getText().equals(this.m_origAUTName)) continue;
                this.setMessage(Messages.AUTPropertiesDialogDoubleAUTName, 3);
                isError |= true;
            }
        }
        if (!isError && autName.length() == 0) {
            this.setMessage(Messages.AUTPropertiesDialogEmptyAUTName, 3);
            isError |= true;
        }
        if (!isError && (autName.startsWith(" ") || autName.charAt(autName.length() - 1) == ' ')) {
            this.setMessage(Messages.AUTPropertiesDialogInvalidAUTName, 3);
            isError |= true;
        }
        return isError;
    }

    private boolean modifyAUTToolkitComboAction() {
        String selection = this.m_autToolKitComboBox.getSelectedObject();
        if (selection == null || selection.trim().length() == 0) {
            this.setMessage(Messages.AUTPropertiesDialogNoToolkitSelected, 3);
            return true;
        }
        return false;
    }

    private void enableOKButton(boolean enabled) {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(enabled);
        }
    }

    private void resizeLists() {
        ((GridData)this.m_autLangList.getLayoutData()).widthHint = Dialog.convertHeightInCharsToPixels((FontMetrics)Layout.getFontMetrics((Control)this.m_autLangList), (int)15);
        ((GridData)this.m_availableLangList.getLayoutData()).widthHint = Dialog.convertHeightInCharsToPixels((FontMetrics)Layout.getFontMetrics((Control)this.m_autLangList), (int)15);
    }

    private void getObjects() {
        this.m_availableLangList = this.m_chooseLists.getListOne();
        this.m_autLangList = this.m_chooseLists.getListTwo();
    }

    private List newListField(Composite parent, String labelText, int lines) {
        Label label = new Label(parent, 0);
        label.setText(labelText);
        List listField = new List(parent, 2820);
        GridData listGridData = new GridData();
        listGridData.horizontalAlignment = 4;
        listGridData.grabExcessHorizontalSpace = true;
        listGridData.horizontalSpan = 2;
        listGridData.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)Layout.getFontMetrics((Control)listField), (int)lines);
        Layout.addToolTipAndMaxWidth(listGridData, (Control)listField);
        listField.setLayoutData((Object)listGridData);
        return listField;
    }

    private void initFields() {
        this.m_autNameText.setText(this.m_autMain.getName());
        this.m_autToolKitComboBox.setSelectedObject(this.m_autMain.getToolkit());
        Set autConfigSet = this.m_autMain.getAutConfigSet();
        if (!autConfigSet.isEmpty()) {
            int i = 0;
            String[] autConfigs = new String[autConfigSet.size()];
            for (IAUTConfigPO configPO : autConfigSet) {
                autConfigs[i] = configPO.getName();
                ++i;
            }
            this.setAutConfigList(autConfigs);
        }
    }

    private void createAUTNameEditor(Composite parent) {
        this.newLabel(parent, Messages.AUTPropertiesDialogAUTName);
        this.m_autNameText = this.newRequiredTextField(parent);
        Layout.setMaxChar(this.m_autNameText);
    }

    private void createAutToolkitCombo(Composite parent) {
        this.newLabel(parent, Messages.AUTPropertiesDialogToolkit);
        try {
            this.m_autToolKitComboBox = ControlFactory.createAutToolkitCombo(parent, this.m_project, this.m_autMain.getToolkit());
            this.m_autToolKitComboBox.deselectAll();
            this.m_autToolKitComboBox.clearSelection();
            String autToolkit = this.m_autMain.getToolkit();
            if (autToolkit != null && autToolkit.trim().length() != 0) {
                this.m_autToolKitComboBox.setSelectedObject(autToolkit);
            } else if (this.m_autToolKitComboBox.getItemCount() == 1) {
                this.m_autToolKitComboBox.select(0);
            }
        }
        catch (ToolkitPluginException toolkitPluginException) {
            this.m_autToolKitComboBox = ControlFactory.createAutToolkitCombo(parent, this.m_autMain);
        }
        this.newLabel(parent, "");
    }

    private void createGenerateNamesCheckBox(Composite parent) {
        Label infoLabel = this.newLabel(parent, Messages.AUTPropertiesDialogGenerateNames);
        ControlDecorator.decorateInfo((Control)infoLabel, "AUTPropertiesDialog.generateNamesDescription", false);
        this.m_generateNames = new Button(parent, 32);
        this.m_generateNames.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (AUTPropertiesDialog.this.m_autMain.isGenerateNames() != AUTPropertiesDialog.this.m_generateNames.getSelection()) {
                    AUTPropertiesDialog.this.m_autMain.setGenerateNames(AUTPropertiesDialog.this.m_generateNames.getSelection());
                    NagDialog.runNagDialog(AUTPropertiesDialog.this.getShell(), "InfoNagger.changeAUTNameGeneration", "org.eclipse.jubula.client.ua.help.autWizardPageGenerateNamesPageContextId");
                }
            }
        });
        if (this.m_autMain.getToolkit() != null && this.m_autMain.getToolkit().equals("com.bredexsw.guidancer.RcpToolkitPlugin")) {
            this.m_generateNames.setEnabled(true);
        } else {
            this.m_generateNames.setEnabled(false);
            this.m_generateNames.setSelection(false);
        }
        this.m_generateNames.setSelection(this.m_autMain.isGenerateNames());
        this.newLabel(parent, "");
    }

    private void createAutConfigButtons(Composite parent) {
        JBText invisibleText = new JBText(parent, 2048);
        invisibleText.setVisible(false);
        GridData invisibleGrid = new GridData();
        invisibleGrid.widthHint = 10;
        invisibleText.setLayoutData(invisibleGrid);
        JBText invisibleText2 = new JBText(parent, 2048);
        invisibleText2.setVisible(false);
        invisibleText2.setLayoutData(invisibleGrid);
        this.m_addButton = new Button(parent, 8);
        this.m_addButton.setText(Messages.AUTPropertyPageAdd);
        this.m_addButton.setLayoutData((Object)this.buttonGrid());
        String selectedObject = this.m_autToolKitComboBox.getSelectedObject();
        this.m_addButton.setEnabled(selectedObject != null && selectedObject.trim().length() > 0);
        this.m_duplicateButton = new Button(parent, 8);
        this.m_duplicateButton.setText(Messages.AUTPropertyPageDuplicate);
        this.m_duplicateButton.setData("TEST_COMP_NAME", (Object)"AUTPropertyPage.Duplicate");
        this.m_duplicateButton.setLayoutData((Object)this.buttonGrid());
        this.m_duplicateButton.setEnabled(false);
        this.m_editButton = new Button(parent, 8);
        this.m_editButton.setText(Messages.AUTPropertyPageEdit);
        this.m_editButton.setLayoutData((Object)this.buttonGrid());
        this.m_editButton.setEnabled(false);
        this.m_removeButton = new Button(parent, 8);
        this.m_removeButton.setText(Messages.AUTPropertyPageRemove);
        this.m_removeButton.setLayoutData((Object)this.buttonGrid());
        this.m_removeButton.setEnabled(false);
    }

    private void handleAddButtonEvent() {
        this.editNewAUTConfig(PoMaker.createAUTConfigPO());
    }

    private void editNewAUTConfig(IAUTConfigPO autConfig) {
        String autName = this.m_autMain.getName();
        if (autName == null || autName.length() == 0) {
            autName = this.m_autNameText.getText();
        }
        String[] selection = this.m_autConfigList.getSelection();
        AUTConfigPropertiesDialog dialog = new AUTConfigPropertiesDialog(this.m_addButton.getShell(), autConfig, this.getAutToolkit(), autName, new AutIdValidator(this.m_project, this.m_autMain, autConfig));
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        dialog.getShell().setText(Messages.AUTPropertiesDialogAUTConfigTitle);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            this.m_autConfigList.add(autConfig.getName());
            String[] autConfigList = this.m_autConfigList.getItems();
            this.setAutConfigList(autConfigList);
            this.m_autMain.addAutConfigToSet(autConfig);
            this.setFocus(new String[]{autConfig.getName()});
            return;
        }
        this.setFocus(selection);
    }

    private String getAutToolkit() {
        if (this.m_autMain.getToolkit() == null) {
            this.m_autMain.setToolkit(this.m_autToolKitComboBox.getSelectedObject());
        }
        return this.m_autMain.getToolkit();
    }

    private void handleEditButtonEvent() {
        IAUTConfigPO autConfig = this.getSelectedAUTConf();
        if (autConfig != null) {
            Map preEditConfig = PoMaker.createAUTConfigPO().getConfigMap();
            Utils.makeAutConfigCopy(autConfig.getConfigMap(), preEditConfig);
            AUTConfigPropertiesDialog dialog = new AUTConfigPropertiesDialog(this.m_editButton.getShell(), autConfig, this.getAutToolkit(), this.m_autMain.getName(), new AutIdValidator(this.m_project, this.m_autMain, autConfig));
            dialog.create();
            DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
            dialog.getShell().setText(Messages.AUTPropertiesDialogAUTConfigTitle);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                Set autConfigSet = this.m_autMain.getAutConfigSet();
                String[] listHelper = new String[autConfigSet.size()];
                int i = 0;
                for (IAUTConfigPO configPO : autConfigSet) {
                    listHelper[i] = configPO.getName();
                    ++i;
                }
                this.setAutConfigList(listHelper);
            } else {
                Utils.makeAutConfigCopy(preEditConfig, autConfig.getConfigMap());
            }
            HashMap newAutConfigMap = new HashMap(autConfig.getConfigMap());
            autConfig.setConfigMap(newAutConfigMap);
            this.setFocus(new String[]{autConfig.getName()});
        }
    }

    private IAUTConfigPO getSelectedAUTConf() {
        String[] selection = this.m_autConfigList.getSelection();
        if (selection.length == 0) {
            return null;
        }
        String selectedAutConfigName = selection[0];
        Set autConfigSet = this.m_autMain.getAutConfigSet();
        for (IAUTConfigPO configPO : autConfigSet) {
            String autConfigName = configPO.getName();
            if (!selectedAutConfigName.equals(autConfigName)) continue;
            return configPO;
        }
        return null;
    }

    private void handleRemoveButtonEvent() {
        IAUTConfigPO autConfig = null;
        String[] selection = this.m_autConfigList.getSelection();
        if (!"".equals(selection[0])) {
            for (IAUTConfigPO configPO : this.m_autMain.getAutConfigSet()) {
                String autConfigName = configPO.getName();
                if (!selection[0].equals(autConfigName)) continue;
                autConfig = configPO;
                break;
            }
            this.m_autMain.removeAutConfig(autConfig);
            this.m_autConfigList.remove(selection[0]);
            if (this.m_autConfigList.getItemCount() > 0) {
                this.m_autConfigList.setSelection(0);
            }
            this.handleAutConfigListEvent();
        }
    }

    private void setFocus(String[] autConfigName) {
        this.m_autConfigList.setSelection(autConfigName);
        this.handleAutConfigListEvent();
    }

    private void handleAutConfigListEvent() {
        if (this.m_autConfigList.getItemCount() == 0) {
            this.m_editButton.setEnabled(false);
            this.m_duplicateButton.setEnabled(false);
            this.m_removeButton.setEnabled(false);
            return;
        }
        String[] selection = this.m_autConfigList.getSelection();
        if (selection.length > 0) {
            this.m_editButton.setEnabled(true);
            this.m_duplicateButton.setEnabled(true);
            this.m_removeButton.setEnabled(true);
        }
    }

    private CheckedRequiredText newRequiredTextField(Composite parent) {
        CheckedRequiredText textField = new CheckedRequiredText(parent, 2048);
        GridData textGrid = new GridData(4, 2, true, false, 2, 1);
        Layout.addToolTipAndMaxWidth(textGrid, (Control)textField);
        textField.setLayoutData(textGrid);
        return textField;
    }

    private Composite newComposite(Composite parent, int numColumns, int verticalAlignment) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = numColumns;
        composite.setLayout((org.eclipse.swt.widgets.Layout)compositeLayout);
        GridData compositeData = new GridData(1808);
        compositeData.grabExcessHorizontalSpace = false;
        compositeData.verticalAlignment = verticalAlignment;
        composite.setLayoutData((Object)compositeData);
        return composite;
    }

    private Label newLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        GridData labelGrid = new GridData(1, 2, false, false, 1, 1);
        label.setLayoutData((Object)labelGrid);
        return label;
    }

    private GridData buttonGrid() {
        GridData buttonData = new GridData();
        buttonData.horizontalAlignment = 4;
        return buttonData;
    }

    private void addListener() {
        this.m_addButton.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_editButton.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_duplicateButton.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_removeButton.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_autConfigList.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_autConfigList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                AUTPropertiesDialog.this.handleEditButtonEvent();
            }
        });
        this.m_autNameText.addVerifyListener((VerifyListener)this.m_verifyListener);
        this.m_autNameText.addModifyListener((ModifyListener)this.m_modifyListener);
        this.m_autToolKitComboBox.addSelectionListener(this.m_selectionListener);
    }

    public String[] getAutLangText() {
        return this.m_autLangList.getItems();
    }

    private void handleDuplicateButtonEvent() {
        IAUTConfigPO cfg = this.getSelectedAUTConf();
        if (cfg != null) {
            IAUTConfigPO newConfig = PoMaker.createAUTConfigPO((IAUTConfigPO)cfg);
            String name = newConfig.getName();
            newConfig.setValue("CONFIG_NAME", String.valueOf(Messages.AUTPropertyPageDupPrefix) + name);
            String autId = newConfig.getValue("AUT_ID", null);
            if (autId != null && autId.length() > 0) {
                AutIdValidator val = new AutIdValidator(this.m_project);
                String newAutId = autId;
                boolean valid = false;
                int i = 1;
                while (!valid) {
                    newAutId = String.valueOf(autId) + "_" + i++;
                    if (!val.validate(newAutId).isOK()) continue;
                    valid = true;
                }
                newConfig.setValue("AUT_ID", newAutId);
            }
            this.editNewAUTConfig(newConfig);
        }
    }

    public void setAutLangText(String[] autLangTextItems) {
        this.m_autLangList.setItems(autLangTextItems);
    }

    public String getAutName() {
        return this.m_autNameText.getText();
    }

    public void setAutName(String autName) {
        this.m_autNameText.setText(autName);
    }

    public String[] getAutConfigList() {
        return this.m_autConfigList.getItems();
    }

    private void setAutConfigList(String[] autConfigList) {
        if (autConfigList[0] != null) {
            Arrays.sort(autConfigList);
            this.m_autConfigList.removeAll();
            this.m_autConfigList.setItems(autConfigList);
        }
    }

    protected void okPressed() {
        this.m_autMain.setName(this.m_autNameText.getText());
        this.m_autMain.setToolkit(this.m_autToolKitComboBox.getSelectedObject());
        this.m_autMain.setGenerateNames(this.m_generateNames.getSelection());
        LanguageHelper langHelper = this.m_autMain.getLangHelper();
        langHelper.clearLangList();
        int langCount = this.m_autLangList.getItems().length;
        int i = 0;
        while (i < langCount) {
            langHelper.addLanguageToList(Languages.getInstance().getLocale(this.m_autLangList.getItem(i)));
            ++i;
        }
        this.setAutMain(this.m_autMain);
        super.okPressed();
    }

    public int open() {
        this.checkForErrors();
        return super.open();
    }

    public IAUTMainPO getAutMain() {
        return this.m_autMain;
    }

    public void setAutMain(IAUTMainPO autMain) {
        this.m_autMain = autMain;
    }

    private void separator(Composite composite) {
        this.newLabel(composite, "");
        Label sep = new Label(composite, 258);
        GridData sepData = new GridData();
        sepData.horizontalAlignment = 4;
        sepData.horizontalSpan = 3;
        sep.setLayoutData((Object)sepData);
        this.newLabel(composite, "");
    }

    private void createAutIdList(Composite parent) {
        AutIdListComposite autIdComposite = new AutIdListComposite(parent, this.m_autMain, new AutIdValidator(this.m_project, this.m_autMain));
        GridData compositeData = new GridData();
        compositeData.horizontalAlignment = 4;
        compositeData.grabExcessHorizontalSpace = true;
        autIdComposite.setLayoutData(compositeData);
    }

    private class WidgetModifyListener
    implements ModifyListener {
        private WidgetModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            Object o = e.getSource();
            if (o.equals(AUTPropertiesDialog.this.m_autNameText)) {
                AUTPropertiesDialog.this.checkForErrors();
                return;
            }
        }
    }

    private class WidgetSelectionListener
    implements SelectionListener {
        private WidgetSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            this.handleSelectionEvent(e);
        }

        private void handleSelectionEvent(SelectionEvent e) {
            Object o = e.getSource();
            if (o.equals(AUTPropertiesDialog.this.m_addButton)) {
                AUTPropertiesDialog.this.handleAddButtonEvent();
                return;
            }
            if (o.equals(AUTPropertiesDialog.this.m_editButton)) {
                AUTPropertiesDialog.this.handleEditButtonEvent();
                return;
            }
            if (o.equals(AUTPropertiesDialog.this.m_duplicateButton)) {
                AUTPropertiesDialog.this.handleDuplicateButtonEvent();
                return;
            }
            if (o.equals(AUTPropertiesDialog.this.m_removeButton)) {
                AUTPropertiesDialog.this.handleRemoveButtonEvent();
                return;
            }
            if (o.equals(AUTPropertiesDialog.this.m_autConfigList)) {
                AUTPropertiesDialog.this.handleAutConfigListEvent();
                return;
            }
            if (o.equals((Object)AUTPropertiesDialog.this.m_autToolKitComboBox)) {
                this.handleAutToolKitComboBoxEvent();
                return;
            }
            Assert.notReached((String)(String.valueOf(Messages.EventActivatedUnknownWidget) + ":" + " " + "'" + String.valueOf(e.getSource()) + "'"));
        }

        private void handleAutToolKitComboBoxEvent() {
            String selectedObject = (String)AUTPropertiesDialog.this.m_autToolKitComboBox.getSelectedObject();
            String oldToolkit = AUTPropertiesDialog.this.m_autMain.getToolkit();
            AUTPropertiesDialog.this.m_autMain.setToolkit(selectedObject);
            AUTSettingWizardPage.checkToolkit(AUTPropertiesDialog.this.getShell(), AUTPropertiesDialog.this.m_autMain, oldToolkit);
            AUTPropertiesDialog.this.m_addButton.setEnabled(selectedObject != null && selectedObject.trim().length() > 0);
            if ("com.bredexsw.guidancer.RcpToolkitPlugin".equals(selectedObject)) {
                AUTPropertiesDialog.this.m_generateNames.setEnabled(true);
                AUTPropertiesDialog.this.m_generateNames.setSelection(true);
            } else {
                AUTPropertiesDialog.this.m_generateNames.setEnabled(false);
                AUTPropertiesDialog.this.m_generateNames.setSelection(false);
            }
            AUTPropertiesDialog.this.checkForErrors();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.handleSelectionEvent(e);
        }
    }

    private class WidgetVerifyListener
    implements VerifyListener {
        private WidgetVerifyListener() {
        }

        public void verifyText(VerifyEvent e) {
            Object o = e.getSource();
            if (o.equals(AUTPropertiesDialog.this.m_autNameText)) {
                AUTPropertiesDialog.this.m_autNameText.setBackground(Layout.WHITE_COLOR);
                return;
            }
            Assert.notReached((String)(String.valueOf(Messages.EventActivatedUnknownWidget) + "."));
        }
    }
}

