/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.constants.Layout;
import org.eclipse.jubula.client.ui.dialogs.ComboBoxDialog;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.CommandHelper;
import org.eclipse.jubula.client.ui.utils.ServerManager;
import org.eclipse.jubula.tools.exception.Assert;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewServerPortDialog
extends TitleAreaDialog {
    private static final int NUM_COLUMNS_1 = 1;
    private static final int NUM_COLUMNS_4 = 4;
    private static final int VERTICAL_SPACING = 2;
    private static final int MARGIN_WIDTH = 10;
    private static final int MARGIN_HEIGHT = 10;
    private static final int WIDTH_HINT = 300;
    private static final int HORIZONTAL_SPAN = 3;
    private String m_message = Messages.NewServerPortDialogMessage;
    private Combo m_serverCombo;
    private IntegerFieldEditor m_portText;
    private Button m_jreButton = null;
    private ServerManager.Server m_server;
    private WidgetSelectionListener m_selectionListener = new WidgetSelectionListener();
    private ServerManager m_serverMgr;

    public NewServerPortDialog(Shell parentShell, ServerManager.Server server) {
        super(parentShell);
        this.m_server = this.m_server == null ? new ServerManager.Server("", -1) : server;
        this.m_serverMgr = ServerManager.getInstance();
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage(this.m_message);
        this.setTitle(Messages.NewServerPortDialogTitle);
        this.setTitleImage(IconConstants.SERVER_PORT_DIALOG_IMAGE);
        this.getShell().setText(Messages.NewServerPortDialogShellTitle);
        GridLayout gridLayoutParent = new GridLayout();
        gridLayoutParent.numColumns = 1;
        gridLayoutParent.verticalSpacing = 2;
        gridLayoutParent.marginWidth = 10;
        gridLayoutParent.marginHeight = 10;
        parent.setLayout((org.eclipse.swt.widgets.Layout)gridLayoutParent);
        Plugin.createSeparator(parent);
        Composite area = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        area.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.widthHint = 300;
        area.setLayoutData((Object)gridData);
        this.createServerCombo(area);
        this.fillServerCombo();
        this.createPortField(area);
        this.addListener();
        this.modifyServerNameFieldAction();
        Plugin.createSeparator(parent);
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.serverPortContextId");
        this.setHelpAvailable(true);
        return area;
    }

    public int open() {
        this.setMessage(this.m_message);
        return super.open();
    }

    private void createServerCombo(Composite area) {
        new Label(area, 0).setLayoutData((Object)new GridData(4, 2, false, false, 4, 1));
        new Label(area, 0).setText(Messages.NewServerPortDialogServerLabel);
        this.m_serverCombo = new Combo(area, 2052);
        GridData gridData = this.newGridData();
        Layout.addToolTipAndMaxWidth(gridData, (Control)this.m_serverCombo);
        this.m_serverCombo.setLayoutData((Object)gridData);
        this.m_jreButton = new Button(area, 8);
        this.m_jreButton.setText(Messages.NewServerPortDialogManageJRE);
        this.m_jreButton.setLayoutData((Object)this.buttonLayoutData());
    }

    private void createPortField(Composite area) {
        this.newLabel(area, NLS.bind((String)Messages.NewServerPortDialogPortLabel, (Object[])new Object[]{1024, 65535}));
        this.m_portText = new IntegerFieldEditor("", NLS.bind((String)Messages.NewServerPortDialogPortLabel, (Object[])new Object[]{1024, 65535}), area, "65535".length()){

            protected void createControl(Composite parent) {
                GridLayout layout = new GridLayout();
                layout.numColumns = 4;
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                parent.setLayout((org.eclipse.swt.widgets.Layout)layout);
                this.doFillIntoGrid(parent, layout.numColumns);
            }

            protected void doFillIntoGrid(Composite parent, int numColumns) {
                this.getLabelControl(parent).dispose();
                Text textField = this.getTextControl(parent);
                GridData gd = new GridData();
                GC gc = new GC((Drawable)textField);
                try {
                    Point extent = gc.textExtent("X");
                    gd.widthHint = "65535".length() * extent.x;
                }
                finally {
                    gc.dispose();
                }
                textField.setLayoutData((Object)gd);
            }
        };
        this.m_portText.setValidRange(1024, 65535);
        if (Integer.valueOf(-1).equals(this.m_server.getPort())) {
            this.m_portText.setStringValue("");
        } else {
            this.m_portText.setStringValue(this.m_server.getPort().toString());
        }
    }

    private void newLabel(Composite parent, String text) {
        new Label(parent, 0).setLayoutData((Object)new GridData(4, 2, false, false, 4, 1));
        new Label(parent, 0).setText(text);
    }

    private GridData buttonLayoutData() {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = false;
        return gridData;
    }

    void verifyIntegerFieldAction(VerifyEvent e) {
        e.doit = "0123456789".indexOf(e.text) >= 0;
        this.checkCompleteness(e.doit);
    }

    boolean modifyServerNameFieldAction() {
        boolean isCorrect = true;
        int serverNameLength = this.m_serverCombo.getText().length();
        if (serverNameLength == 0 || this.m_serverCombo.getText().startsWith(" ") || this.m_serverCombo.getText().charAt(serverNameLength - 1) == ' ') {
            isCorrect = false;
        }
        this.enableOKButton(isCorrect);
        if (isCorrect) {
            this.setMessage(Messages.ServerPreferencePageTitle);
            this.setErrorMessage(null);
            this.checkCompleteness(false);
        } else if (serverNameLength == 0) {
            this.setErrorMessage(Messages.ServerPreferencePageEmptyServerName);
        } else {
            this.setErrorMessage(Messages.ServerPreferencePageWrongServerName);
        }
        return isCorrect;
    }

    void checkCompleteness(boolean isPortFieldVerified) {
        if (!this.m_portText.isValid()) {
            this.setErrorMessage(NLS.bind((String)Messages.NewServerPortDialogPortError, (Object[])new Object[]{1024, 65535}));
            this.enableOKButton(false);
            return;
        }
        this.setErrorMessage(null);
        this.enableOKButton(true);
        if (isPortFieldVerified) {
            this.modifyServerNameFieldAction();
        }
    }

    private void handleJreButtonEvent() {
        String serverName = this.m_serverCombo.getText();
        if (serverName != null && !serverName.equals("")) {
            ArrayList<String> jreList = new ArrayList<String>(this.m_serverMgr.getJREs(serverName));
            ComboBoxDialog dialog = new ComboBoxDialog(Plugin.getShell(), jreList, Messages.GDProblemViewMessage, Messages.GDProblemViewTitle, IconConstants.PROJECT_DIALOG_IMAGE, Messages.GDProblemViewShellTitle, Messages.GDProblemViewLabel);
            Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.jreChooseContextId");
            dialog.setHelpAvailable(true);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                if (dialog.getSelectionIndex() == 0) {
                    CommandHelper.executeCommand("org.eclipse.jubula.client.ui.commands.NewProject");
                } else if (dialog.getSelectionIndex() == 1) {
                    CommandHelper.executeCommand("org.eclipse.jubula.client.ui.commands.ImportProject");
                } else if (dialog.getSelectionIndex() == 2) {
                    CommandHelper.executeCommand("org.eclipse.jubula.client.ui.commands.OpenProject");
                }
            }
        }
    }

    private void enableOKButton(boolean enabled) {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(enabled);
        }
    }

    protected void okPressed() {
        this.m_server.setName(this.m_serverCombo.getText());
        this.m_server.setPort(Integer.valueOf(this.m_portText.getStringValue()));
        this.setReturnCode(0);
        this.close();
    }

    GridData newGridData() {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 1;
        return gridData;
    }

    private void fillServerCombo() {
        this.m_serverCombo.removeAll();
        for (ServerManager.Server server : this.m_serverMgr.getServers()) {
            this.m_serverCombo.add(server.getName());
        }
    }

    public String getServer() {
        if ("127.0.0.1".equals(this.m_server.getName())) {
            this.m_server.setName("localhost");
        }
        return this.m_server.getName().toLowerCase();
    }

    private void addListener() {
        this.m_jreButton.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_serverCombo.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_serverCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewServerPortDialog.this.modifyServerNameFieldAction();
            }
        });
        this.m_portText.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                NewServerPortDialog.this.checkCompleteness(true);
            }
        });
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (button.getData().equals(0)) {
            button.setEnabled(false);
        }
        this.modifyServerNameFieldAction();
        return button;
    }

    public Integer getPort() {
        return this.m_server.getPort();
    }

    private class WidgetSelectionListener
    implements SelectionListener {
        private WidgetSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object o = e.getSource();
            if (o.equals(NewServerPortDialog.this.m_serverCombo)) {
                NewServerPortDialog.this.checkCompleteness(false);
                return;
            }
            if (o.equals(NewServerPortDialog.this.m_jreButton)) {
                NewServerPortDialog.this.handleJreButtonEvent();
                return;
            }
            Assert.notReached((String)(String.valueOf(Messages.EventActivatedUnknownWidget) + "(" + o + ")" + "."));
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            Object o = e.getSource();
            Assert.notReached((String)(String.valueOf(Messages.EventActivatedUnknownWidget) + "(" + o + ")" + "."));
        }
    }
}

