/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.widgets.TestCaseTreeComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;

public class TestCaseTreeDialog
extends TitleAreaDialog {
    public static final int ADD = 9999;
    private static final int NUM_COLUMNS_1 = 1;
    private static final int VERTICAL_SPACING = 2;
    private static final int MARGIN_WIDTH = 2;
    private static final int MARGIN_HEIGHT = 2;
    private List<ISelectionListener> m_selectionListenerList = new ArrayList<ISelectionListener>();
    private String m_title = Messages.TestCaseTableDialogTitle;
    private String m_message = Messages.TestCaseTableDialogMessage;
    private String m_shellTitle = Messages.TestCaseTableDialogShellTitle;
    private String m_addButtonText = Messages.TestCaseTableDialogAdd;
    private ISpecTestCasePO m_parentTestCase;
    private int m_treeStyle = 4;
    private Button m_addButton;
    private Image m_image = IconConstants.ADD_TC_DIALOG_IMAGE;
    private TestCaseTreeComposite m_testcaseTreeComposite;

    public TestCaseTreeDialog(Shell shell, ISpecTestCasePO parentTestCase, int treeStyle) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.m_parentTestCase = parentTestCase;
        this.m_treeStyle = treeStyle;
    }

    public TestCaseTreeDialog(Shell shell, String title, String message, ISpecTestCasePO parentTestCase, String shellTitle, int treeStyle, Image image) {
        this(shell, parentTestCase, treeStyle);
        this.m_title = title;
        this.m_message = message;
        this.m_shellTitle = shellTitle;
        this.m_image = image;
    }

    public TestCaseTreeDialog(Shell shell, String title, String message, ISpecTestCasePO parentTestCase, String shellTitle, int treeStyle, Image image, String addButtonText) {
        this(shell, title, message, parentTestCase, shellTitle, treeStyle, image);
        this.m_addButtonText = addButtonText;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.m_title);
        this.setMessage(this.m_message);
        this.getShell().setText(this.m_shellTitle);
        this.setTitleImage(this.m_image);
        GridLayout gridLayoutParent = new GridLayout();
        gridLayoutParent.numColumns = 1;
        gridLayoutParent.verticalSpacing = 2;
        gridLayoutParent.marginWidth = 2;
        gridLayoutParent.marginHeight = 2;
        parent.setLayout((Layout)gridLayoutParent);
        Plugin.createSeparator(parent);
        this.m_testcaseTreeComposite = new TestCaseTreeComposite(parent, this.m_treeStyle, (INodePO)this.m_parentTestCase);
        Plugin.createSeparator(parent);
        return this.m_testcaseTreeComposite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.m_addButton = this.createButton(parent, 9999, this.m_addButtonText, true);
        this.m_addButton.setEnabled(false);
        this.m_addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCaseTreeDialog.this.notifyListener();
                TestCaseTreeDialog.this.setReturnCode(9999);
                TestCaseTreeDialog.this.close();
            }
        });
        this.m_testcaseTreeComposite.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                if (e.getSelection() != null) {
                    TestCaseTreeDialog.this.m_addButton.setEnabled(true);
                }
            }
        });
        this.m_testcaseTreeComposite.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TestCaseTreeDialog.this.m_addButton.setEnabled(TestCaseTreeDialog.this.m_testcaseTreeComposite.hasValidSelection());
            }
        });
        this.m_testcaseTreeComposite.getTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!TestCaseTreeDialog.this.m_addButton.getEnabled()) {
                    return;
                }
                TestCaseTreeDialog.this.notifyListener();
                TestCaseTreeDialog.this.setReturnCode(9999);
                TestCaseTreeDialog.this.close();
            }
        });
        Button cancelButton = this.createButton(parent, 1, Messages.TestCaseTableDialogCancel, false);
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCaseTreeDialog.this.setReturnCode(1);
                TestCaseTreeDialog.this.close();
            }
        });
    }

    public void addSelectionListener(ISelectionListener listener) {
        if (!this.m_selectionListenerList.contains(listener)) {
            this.m_selectionListenerList.add(listener);
        }
    }

    public void removeSelectionListener(ISelectionListener listener) {
        this.m_selectionListenerList.remove(listener);
    }

    void notifyListener() {
        for (ISelectionListener listener : this.m_selectionListenerList) {
            listener.selectionChanged(null, this.m_testcaseTreeComposite.getTreeViewer().getSelection());
        }
    }
}

