/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameMapper;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.dialogs.NewLogicalCompNameDialog;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractNewComponentNameHandler
extends AbstractHandler {
    protected String openDialog(IComponentNameMapper compNameMapper, Shell parentShell) {
        NewLogicalCompNameDialog newNameDialog = new NewLogicalCompNameDialog(compNameMapper, parentShell);
        newNameDialog.setHelpAvailable(true);
        newNameDialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)newNameDialog);
        Plugin.getHelpSystem().setHelp((Control)newNameDialog.getShell(), "org.eclipse.jubula.client.ua.help.newComponentNameContextId");
        if (newNameDialog.open() == 0) {
            return newNameDialog.getName();
        }
        return null;
    }

    protected IComponentNamePO performOperation(String newName, IWritableComponentNameMapper mapper) {
        String compType = ComponentBuilder.getInstance().getCompSystem().getMostAbstractComponent().getType();
        IComponentNamePO compNamePo = mapper.getCompNameCache().createComponentNamePO(newName, compType, ComponentNamesBP.CompNameCreationContext.OBJECT_MAPPING);
        return compNamePo;
    }
}

