/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.handlers;

import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMSaveException;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.dialogs.InputDialog;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddNewCategoryHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart != null && "org.eclipse.jubula.client.ui.views.TestCaseBrowser".equals(activePart.getSite().getId())) {
            IStructuredSelection selection = Plugin.getTreeViewSelection("org.eclipse.jubula.client.ui.views.TestCaseBrowser");
            try {
                this.createNewCategory(selection);
            }
            catch (PMException e) {
                PMExceptionHandler.handlePMExceptionForMasterSession(e);
            }
            catch (ProjectDeletedException projectDeletedException) {
                PMExceptionHandler.handleGDProjectDeletedException();
            }
        }
        return null;
    }

    private void createNewCategory(IStructuredSelection selection) throws PMSaveException, PMAlreadyLockedException, PMException, ProjectDeletedException {
        IProjectPO catParentPO;
        if (!selection.isEmpty()) {
            catParentPO = (INodePO)selection.getFirstElement();
            while (!(catParentPO instanceof ICategoryPO) && !(catParentPO instanceof IProjectPO)) {
                catParentPO = catParentPO.getParentNode();
            }
        } else {
            catParentPO = GeneralStorage.getInstance().getProject();
        }
        IProjectPO finalCatParent = catParentPO;
        InputDialog dialog = new InputDialog(Plugin.getShell(), Messages.CreateNewCategoryActionCatTitle, "New category", Messages.CreateNewCategoryActionCatMessage, Messages.CreateNewCategoryActionCatLabel, Messages.CreateNewCategoryActionCatError, Messages.CreateNewCategoryActionDoubleCatName, "newCategoryDialog.gif", Messages.CreateNewCategoryActionNewCategory, false, (INodePO)finalCatParent){
            private final /* synthetic */ INodePO val$finalCatParent;
            {
                this.val$finalCatParent = iNodePO;
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4, $anonymous5, $anonymous6, $anonymous7, $anonymous8, $anonymous9);
            }

            protected boolean isInputAllowed() {
                return !AddNewCategoryHandler.this.existCategory(this.val$finalCatParent, this.getInputFieldText());
            }
        };
        dialog.setHelpAvailable(true);
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.dialogNewCategoryContextId");
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            String categoryName = dialog.getName();
            ICategoryPO category = NodeMaker.createCategoryPO((String)categoryName);
            NodePM.addAndPersistChildNode((INodePO)catParentPO, (INodePO)category, null, (NodePM.AbstractCmdHandleChild)NodePM.getCmdHandleChild((INodePO)catParentPO, (INodePO)category));
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)category, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.all);
        }
        dialog.close();
    }

    boolean existCategory(INodePO node, String name) {
        Iterator iter = null;
        if (Persistor.isPoSubclass((IPersistentObject)node, ICategoryPO.class)) {
            iter = node.getNodeListIterator();
        } else {
            IProjectPO proj = GeneralStorage.getInstance().getProject();
            iter = proj.getSpecObjCont().getSpecObjList().iterator();
        }
        while (iter.hasNext()) {
            INodePO iterNode = (INodePO)iter.next();
            if (!Persistor.isPoSubclass((IPersistentObject)iterNode, ICategoryPO.class) || !iterNode.getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

