/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.handlers;

import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.ui.editors.IJBEditor;
import org.eclipse.jubula.client.ui.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.handlers.AbstractMergeComponentNameHandler;
import org.eclipse.jubula.client.ui.utils.Utils;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeLogicalNameHandler
extends AbstractMergeComponentNameHandler {
    public Object execute(ExecutionEvent event) {
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (sel instanceof IStructuredSelection && activePart instanceof IJBEditor) {
            IStructuredSelection structuredSel = (IStructuredSelection)sel;
            IJBEditor editor = (IJBEditor)activePart;
            if (editor.isDirty()) {
                Utils.createMessageDialog(MessageIDs.I_SAVE_EDITOR);
                return null;
            }
            Set<IComponentNamePO> compNames = this.getComponentNames(structuredSel);
            IComponentNamePO selectedCompNamePo = this.openDialog(compNames);
            if (selectedCompNamePo == null) {
                return null;
            }
            if (editor.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK) {
                return null;
            }
            this.performOperation(editor, compNames, selectedCompNamePo);
        }
        return null;
    }

    private void performOperation(IJBEditor editor, Set<IComponentNamePO> compNames, IComponentNamePO selectedCompNamePo) {
        this.performOperation(compNames, selectedCompNamePo);
        editor.getEditorHelper().setDirty(true);
        NullProgressMonitor saveProgressMonitor = new NullProgressMonitor();
        editor.doSave((IProgressMonitor)saveProgressMonitor);
        if (!saveProgressMonitor.isCanceled()) {
            this.fireChangeEvents(compNames);
        }
    }
}

