/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.dialogs.InputDialog;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.swt.widgets.Control;

public class NewTestJobHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        this.newTestJob();
        return null;
    }

    private void newTestJob() {
        InputDialog dialog = this.newTestJobPopUp();
        if (dialog.getReturnCode() == 1) {
            return;
        }
        IProjectPO project = GeneralStorage.getInstance().getProject();
        try {
            ITestJobPO testJob = NodeMaker.createTestJobPO((String)dialog.getName());
            NodePM.AbstractCmdHandleChild cmd = NodePM.getCmdHandleChild((INodePO)project, (INodePO)testJob);
            NodePM.addAndPersistChildNode((INodePO)project, (INodePO)testJob, null, (NodePM.AbstractCmdHandleChild)cmd);
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)testJob, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.all);
        }
        catch (PMException e) {
            PMExceptionHandler.handlePMExceptionForMasterSession(e);
        }
        catch (ProjectDeletedException projectDeletedException) {
            PMExceptionHandler.handleGDProjectDeletedException();
        }
    }

    private InputDialog newTestJobPopUp() {
        final IProjectPO project = GeneralStorage.getInstance().getProject();
        int testJobCount = project.getTestJobCont().getTestJobList().size();
        String str = "";
        if (testJobCount > 0) {
            str = String.valueOf(str) + testJobCount;
        }
        str = "New Test Job" + str;
        InputDialog dialog = new InputDialog(Plugin.getShell(), Messages.NewTestJobTJTitle, str, Messages.NewTestJobTJMessage, Messages.NewTestJobTJLabel, Messages.NewTestJobTJError, Messages.NewTestJobDoubleTJName, "newTestJobDialog.gif", Messages.NewTestJobTJShell, false){

            protected boolean isInputAllowed() {
                String newName = this.getInputFieldText();
                return !ProjectPM.doesTestJobExists((Long)project.getId(), (String)newName);
            }
        };
        dialog.setHelpAvailable(true);
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.dialogTestJobNewContextId");
        dialog.open();
        return dialog;
    }
}

