/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.handlers.rename;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.actions.OMSetCategoryToMapInto;
import org.eclipse.jubula.client.ui.businessprocess.OMEditorBP;
import org.eclipse.jubula.client.ui.dialogs.InputDialog;
import org.eclipse.jubula.client.ui.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.editors.ObjectMappingMultiPageEditor;
import org.eclipse.jubula.client.ui.handlers.rename.AbstractRenameTreeItemHandler;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.sourceprovider.AbstractJBSourceProvider;
import org.eclipse.jubula.client.ui.sourceprovider.ObjectMappingModeSourceProvider;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class RenameCategoryHandlerOMEditor
extends AbstractRenameTreeItemHandler {
    public Object execute(ExecutionEvent event) {
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (editor instanceof ObjectMappingMultiPageEditor && sel instanceof IStructuredSelection) {
            this.dialogPopUp((ObjectMappingMultiPageEditor)editor, (IStructuredSelection)sel);
        }
        return null;
    }

    protected void dialogPopUp(ObjectMappingMultiPageEditor editor, IStructuredSelection sel) {
        IObjectMappingCategoryPO category = (IObjectMappingCategoryPO)sel.getFirstElement();
        IObjectMappingCategoryPO categoryToMapIn = editor.getOmEditorBP().getCategoryToCreateIn();
        InputDialog dialog = this.createDialog(category, editor.getOmEditorBP());
        if (dialog != null) {
            dialog.setHelpAvailable(true);
            dialog.create();
            DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
            Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.dialogRenameContextId");
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                if (editor.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK) {
                    return;
                }
                if (!category.getName().equals(dialog.getName())) {
                    category.setName(dialog.getName());
                    editor.getEditorHelper().setDirty(true);
                    DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)category, DataEventDispatcher.DataState.Renamed, DataEventDispatcher.UpdateState.onlyInEditor);
                    ObjectMappingModeSourceProvider omsp = (ObjectMappingModeSourceProvider)AbstractJBSourceProvider.getSourceProviderInstance(null, "org.eclipse.jubula.client.ui.sourceprovider.ObjectMappingModeSourceProvider");
                    if (categoryToMapIn != null && omsp != null && omsp.isRunning()) {
                        OMSetCategoryToMapInto action = new OMSetCategoryToMapInto();
                        action.runWithEvent(null, null);
                        action.dispose();
                    }
                }
            }
        }
    }

    private InputDialog createDialog(final IObjectMappingCategoryPO category, final OMEditorBP editorBp) {
        return new InputDialog(Plugin.getShell(), Messages.RenameCategoryActionOMEditorTitle, category.getName(), Messages.RenameCategoryActionOMEditorMessage, Messages.RenameCategoryActionOMEditorLabel, Messages.RenameCategoryActionOMEditorError1, Messages.RenameCategoryActionOMEditorDoubleCatName, "category_big.gif", Messages.RenameCategoryActionOMEditorShell, false){

            protected boolean isInputAllowed() {
                return !editorBp.existCategory(category.getParent(), this.getInputFieldText()) || category.getName().equals(this.getInputFieldText());
            }
        };
    }
}

