/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.preferences;

import java.util.HashSet;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jubula.client.core.utils.PrefStoreHelper;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.constants.Layout;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.widgets.CheckedRequiredText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TestDataPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int NUM_COLUMNS = 3;
    private static final int HORIZONTAL_SPACING_10 = 10;
    private static final int VERTICAL_SPACING_10 = 10;
    private static final int MARGIN_HEIGHT_10 = 10;
    private static final int MARGIN_WIDTH_10 = 10;
    private static final int REF_TF_LIMIT = 1;
    private static final int VALSEP_TF_LIMIT = 1;
    private static final int PATHSEP_TF_LIMIT = 1;
    private static final int ESC_TF_LIMIT = 1;
    private static final int HORIZONTAL_SPAN = 2;
    private CheckedRequiredText m_textEscape = null;
    private CheckedRequiredText m_textRef = null;
    private CheckedRequiredText m_textValueSep = null;
    private CheckedRequiredText m_textPathSep = null;
    private CheckedRequiredText m_textFunc = null;

    public TestDataPreferencePage() {
        this.setPreferenceStore(Plugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.compositeGridData(composite);
        this.createEscapeTextfield(composite);
        this.createRefTextField(composite);
        this.createPathSepTextField(composite);
        this.createValueSepTextField(composite);
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.prefPageTestDataContextId");
        KeyListener checker = new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                TestDataPreferencePage.this.checkCompleteness();
            }
        };
        this.m_textEscape.addKeyListener(checker);
        this.m_textRef.addKeyListener(checker);
        this.m_textPathSep.addKeyListener(checker);
        this.m_textValueSep.addKeyListener(checker);
        return composite;
    }

    protected void checkCompleteness() {
        String esc = this.m_textEscape.getText();
        String ref = this.m_textRef.getText();
        String valSep = this.m_textValueSep.getText();
        String pathSep = this.m_textPathSep.getText();
        HashSet<String> list = new HashSet<String>();
        int numberOfDistinctOptions = 2;
        list.add(esc);
        list.add(ref);
        if (esc.length() == 0 || " ".equals(esc)) {
            this.setErrorMessage(Messages.TestDataPreferencePageEscEmpty);
            this.setValid(false);
        } else if (ref.length() == 0 || " ".equals(ref)) {
            this.setErrorMessage(Messages.TestDataPreferencePageRefEmpty);
            this.setValid(false);
        } else if (valSep.length() == 0 || " ".equals(valSep)) {
            this.setErrorMessage(Messages.TestDataPreferencePagePathEmpty);
            this.setValid(false);
        } else if (pathSep.length() == 0 || " ".equals(pathSep)) {
            this.setErrorMessage(Messages.TestDataPreferencePageValueEmpty);
            this.setValid(false);
        } else if (list.size() != numberOfDistinctOptions) {
            this.setErrorMessage(Messages.TestDataPreferencePageNotDisjunkt);
            this.setValid(false);
        } else {
            this.setErrorMessage(null);
            this.setMessage(null);
            this.setValid(true);
        }
    }

    private void compositeGridData(Composite composite) {
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = 3;
        compositeLayout.horizontalSpacing = 10;
        compositeLayout.verticalSpacing = 10;
        compositeLayout.marginHeight = 10;
        compositeLayout.marginWidth = 10;
        composite.setLayout((org.eclipse.swt.widgets.Layout)compositeLayout);
        GridData compositeData = new GridData(1808);
        compositeData.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)compositeData);
    }

    private void createRefTextField(Composite parent) {
        Label labelRef = new Label(parent, 0);
        labelRef.setText(Messages.TestDataPreferencePageCharForRef);
        this.m_textRef = new CheckedRequiredText(parent, 2052);
        this.m_textRef.setText(this.getPreferenceStore().getString("REFERENCE_CHAR_PREF_KEY"));
        this.m_textRef.setTextLimit(1);
        GridData textDataRef = new GridData();
        textDataRef.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)Layout.getFontMetrics((Control)parent), (int)2);
        textDataRef.horizontalSpan = 2;
        this.m_textRef.setLayoutData(textDataRef);
    }

    private void createPathSepTextField(Composite parent) {
        Label labelRef = new Label(parent, 0);
        labelRef.setVisible(false);
        labelRef.setText(Messages.TestDataPreferencePagePathSepForRef);
        this.m_textPathSep = new CheckedRequiredText(parent, 2052);
        this.m_textPathSep.setText(this.getPreferenceStore().getString("PATH_CHAR_PREF_KEY"));
        this.m_textPathSep.setTextLimit(1);
        this.m_textPathSep.setVisible(false);
        GridData textDataRef = new GridData();
        textDataRef.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)Layout.getFontMetrics((Control)parent), (int)2);
        textDataRef.horizontalSpan = 2;
        this.m_textPathSep.setLayoutData(textDataRef);
    }

    private void createValueSepTextField(Composite parent) {
        Label labelRef = new Label(parent, 0);
        labelRef.setVisible(false);
        labelRef.setText(Messages.TestDataPreferencePageValueSepForRef);
        this.m_textValueSep = new CheckedRequiredText(parent, 2052);
        this.m_textValueSep.setVisible(false);
        this.m_textValueSep.setText(this.getPreferenceStore().getString("VALUE_CHAR_PREF_KEY"));
        this.m_textValueSep.setTextLimit(1);
        GridData textDataRef = new GridData();
        textDataRef.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)Layout.getFontMetrics((Control)parent), (int)2);
        textDataRef.horizontalSpan = 2;
        this.m_textValueSep.setLayoutData(textDataRef);
    }

    private void createEscapeTextfield(Composite parent) {
        Label labelEsc = new Label(parent, 0);
        labelEsc.setText(Messages.TestDataPreferencePageCharForEsc);
        this.m_textEscape = new CheckedRequiredText(parent, 2052);
        this.m_textEscape.setEnabled(false);
        this.m_textEscape.setText(this.getPreferenceStore().getString("ESCAPE_CHAR_PREF_KEY"));
        this.m_textEscape.setTextLimit(1);
        GridData textDataEsc = new GridData();
        textDataEsc.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)Layout.getFontMetrics((Control)parent), (int)2);
        textDataEsc.horizontalSpan = 2;
        this.m_textEscape.setLayoutData(textDataEsc);
    }

    private void createFuncTextfield(Composite parent) {
        Label labelFunc = new Label(parent, 0);
        labelFunc.setText(Messages.TestDataPreferencePageCharForFunc);
        this.m_textFunc = new CheckedRequiredText(parent, 2052);
        this.m_textFunc.setText(this.getPreferenceStore().getString("FUNCTION_CHAR_PREF_KEY"));
        this.m_textFunc.setTextLimit(1);
        GridData textDataFunc = new GridData();
        textDataFunc.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)Layout.getFontMetrics((Control)parent), (int)2);
        textDataFunc.horizontalSpan = 2;
        this.m_textFunc.setLayoutData(textDataFunc);
    }

    public void init(IWorkbench workbench) {
        this.setDescription(Messages.TestDataPreferencePagedescription);
    }

    protected void performDefaults() {
        this.m_textEscape.setText(this.getDefaultPrefs("ESCAPE_CHAR_PREF_KEY"));
        this.m_textRef.setText(this.getDefaultPrefs("REFERENCE_CHAR_PREF_KEY"));
        this.m_textPathSep.setText(this.getDefaultPrefs("PATH_CHAR_PREF_KEY"));
        this.m_textValueSep.setText(this.getDefaultPrefs("VALUE_CHAR_PREF_KEY"));
        this.checkCompleteness();
    }

    private String getDefaultPrefs(String key) {
        return this.getPreferenceStore().getDefaultString(key);
    }

    public boolean performOk() {
        String esc = this.m_textEscape.getText();
        String ref = this.m_textRef.getText();
        String func = "";
        String valSep = this.m_textValueSep.getText();
        String pathSep = this.m_textPathSep.getText();
        this.getPreferenceStore().setValue("REFERENCE_CHAR_PREF_KEY", ref);
        this.getPreferenceStore().setValue("ESCAPE_CHAR_PREF_KEY", esc);
        this.getPreferenceStore().setValue("FUNCTION_CHAR_PREF_KEY", func);
        this.getPreferenceStore().setValue("VALUE_CHAR_PREF_KEY", valSep);
        this.getPreferenceStore().setValue("PATH_CHAR_PREF_KEY", pathSep);
        PrefStoreHelper helper = PrefStoreHelper.getInstance();
        helper.setEscapeChar(esc);
        helper.setFunctionChar(func);
        helper.setReferenceChar(ref);
        helper.setValueChar(valSep);
        return super.performOk();
    }

    protected void performApply() {
        this.performOk();
    }
}

