/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.constants.Layout;
import org.eclipse.jubula.client.ui.dialogs.AUTPropertiesDialog;
import org.eclipse.jubula.client.ui.dialogs.JBPropertyDialog;
import org.eclipse.jubula.client.ui.editors.ObjectMappingMultiPageEditor;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.properties.AbstractProjectPropertyPage;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.utils.Utils;
import org.eclipse.jubula.tools.exception.Assert;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;

public class AUTPropertyPage
extends AbstractProjectPropertyPage {
    private static final int NUM_COLUMNS_1 = 1;
    private static final int NUM_COLUMNS_2 = 2;
    private static final int LINES = 15;
    private Button m_addButton = null;
    private Button m_removeButton = null;
    private Button m_editButton = null;
    private org.eclipse.swt.widgets.List m_autList = null;
    private WidgetSelectionListener m_selectionListener = new WidgetSelectionListener();

    public AUTPropertyPage(EditSupport es) {
        super(es);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        GridData compositeData = new GridData(4, 4, true, true);
        this.createCompositeLayout(composite, compositeLayout, compositeData);
        composite.setLayoutData((Object)compositeData);
        this.noDefaultAndApplyButton();
        this.createCompositeLayout(composite, compositeLayout, compositeData);
        this.createAUTList(composite);
        this.createButtons(composite);
        this.initFields();
        this.addListeners();
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.autSettingsPageContextId");
        return composite;
    }

    private void createCompositeLayout(Composite composite, GridLayout compositeLayout, GridData compositeData) {
        compositeData.grabExcessHorizontalSpace = false;
        compositeLayout.horizontalSpacing = 10;
        compositeLayout.verticalSpacing = 10;
        compositeLayout.numColumns = 2;
        compositeLayout.marginHeight = 10;
        compositeLayout.marginWidth = 10;
        composite.setLayout((org.eclipse.swt.widgets.Layout)compositeLayout);
    }

    private void initFields() {
        this.m_autList.removeAll();
        for (IAUTMainPO autW : this.getProject().getAutMainList()) {
            this.m_autList.add(autW.getName());
        }
        this.sortAUTList();
    }

    private void createAUTList(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = 1;
        composite.setLayout((org.eclipse.swt.widgets.Layout)compositeLayout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        this.newLabel(composite, Messages.AUTPropertyPageAUTList);
        this.m_autList = new org.eclipse.swt.widgets.List(composite, 2822);
        GridData textGridData = new GridData();
        textGridData.horizontalAlignment = 4;
        textGridData.grabExcessHorizontalSpace = true;
        textGridData.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)Layout.getFontMetrics((Control)this.m_autList), (int)15);
        Layout.addToolTipAndMaxWidth(textGridData, (Control)this.m_autList);
        this.m_autList.setLayoutData((Object)textGridData);
    }

    private void createButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = 1;
        composite.setLayout((org.eclipse.swt.widgets.Layout)compositeLayout);
        GridData data = new GridData();
        data.verticalAlignment = 1;
        data.horizontalAlignment = 3;
        composite.setLayoutData((Object)data);
        new Label(composite, 0);
        this.m_addButton = new Button(composite, 8);
        this.m_addButton.setText(Messages.AUTPropertyPageAdd);
        this.m_addButton.setLayoutData((Object)this.buttonGrid());
        this.m_editButton = new Button(composite, 8);
        this.m_editButton.setText(Messages.AUTPropertyPageEdit);
        this.m_editButton.setLayoutData((Object)this.buttonGrid());
        this.m_editButton.setEnabled(false);
        this.m_removeButton = new Button(composite, 8);
        this.m_removeButton.setText(Messages.AUTPropertyPageRemove);
        this.m_removeButton.setLayoutData((Object)this.buttonGrid());
        this.m_removeButton.setEnabled(false);
    }

    private GridData buttonGrid() {
        GridData buttonData = new GridData();
        buttonData.horizontalAlignment = 4;
        return buttonData;
    }

    private Label newLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        GridData labelGrid = new GridData(1, 2, false, false, 1, 1);
        label.setLayoutData((Object)labelGrid);
        return label;
    }

    void handleAddButtonEvent() {
        String[] selection = this.m_autList.getSelection();
        AUTPropertiesDialog dialog = new AUTPropertiesDialog(this.m_addButton.getShell(), false, null, this.getProject());
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        dialog.getShell().setText(Messages.AUTPropertyPageAUTConfig);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            if (dialog.getAutMain().equals(TestExecution.getInstance().getConnectedAut())) {
                ((JBPropertyDialog)this.getContainer()).setStartedAutChanged(true);
            }
            this.getProject().addAUTMain(dialog.getAutMain());
            this.m_autList.add(dialog.getAutMain().getName());
            this.sortAUTList();
            this.setFocus(new String[]{dialog.getAutMain().getName()});
            return;
        }
        this.setFocus(selection);
    }

    private void sortAUTList() {
        Object[] sortedAUTList = this.m_autList.getItems();
        Arrays.sort(sortedAUTList);
        this.m_autList.removeAll();
        int i = 0;
        while (i < sortedAUTList.length) {
            this.m_autList.add((String)sortedAUTList[i]);
            ++i;
        }
    }

    void handleEditButtonEvent() {
        IAUTMainPO autMain = null;
        String[] selection = this.m_autList.getSelection();
        if (selection.length == 0) {
            return;
        }
        String autName = selection[0];
        for (IAUTMainPO aut : this.getProject().getAutMainList()) {
            String autMainName = aut.getName();
            if (!autName.equals(autMainName)) continue;
            autMain = aut;
            break;
        }
        if (autMain != null) {
            AUTPropertiesDialog dialog = new AUTPropertiesDialog(this.m_editButton.getShell(), true, autMain, this.getProject());
            dialog.create();
            DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
            dialog.getShell().setText(Messages.AUTPropertyPageAUTConfig);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                if (dialog.getAutMain().equals(TestExecution.getInstance().getConnectedAut())) {
                    ((JBPropertyDialog)this.getContainer()).setStartedAutChanged(true);
                }
                this.initFields();
            }
            this.setFocus(new String[]{autMain.getName()});
        }
    }

    void handleRemoveButtonEvent() {
        IAUTMainPO autMain = null;
        String[] selection = this.m_autList.getSelection();
        if (!"".equals(selection[0])) {
            for (IAUTMainPO aut : this.getProject().getAutMainList()) {
                String autMainName = aut.getName();
                if (!selection[0].equals(autMainName)) continue;
                autMain = aut;
                break;
            }
            if (autMain != null) {
                if (!this.checkTestSuiteAUT(autMain)) {
                    return;
                }
                this.closeEquivalentOMEditor(autMain);
                this.getProject().removeAUTMain(autMain);
                this.m_autList.remove(autMain.getName());
                if (this.m_autList.getItemCount() > 0) {
                    this.m_autList.setSelection(0);
                }
                this.handleAutListEvent();
            }
        }
    }

    private void closeEquivalentOMEditor(IAUTMainPO autMain) {
        IEditorReference[] editors = Plugin.getActivePage().getEditorReferences();
        int i = 0;
        while (i < editors.length) {
            ObjectMappingMultiPageEditor omEditor;
            if (editors[i].getPart(true) instanceof ObjectMappingMultiPageEditor && (omEditor = (ObjectMappingMultiPageEditor)editors[i].getPart(true)).getAut().equals(autMain)) {
                omEditor.getEditorSite().getPage().closeEditor((IEditorPart)omEditor, true);
                return;
            }
            ++i;
        }
    }

    private boolean checkTestSuiteAUT(IAUTMainPO autMain) {
        List tsList = this.getProject().getTestSuiteCont().getTestSuiteList();
        ArrayList<String> tsNameList = new ArrayList<String>();
        for (ITestSuitePO ts : tsList) {
            if (ts.getAut() == null || !ts.getAut().equals(autMain)) continue;
            tsNameList.add(ts.getName());
        }
        if (tsNameList.size() > 0) {
            String error = ((Object)tsNameList).toString();
            String output = error.substring(1, error.length() - 1);
            Utils.createMessageDialog(MessageIDs.E_CANNOT_DELETE_AUT, new Object[]{output}, null);
            return false;
        }
        return true;
    }

    private void setFocus(String[] autName) {
        this.m_autList.setSelection(autName);
        this.handleAutListEvent();
    }

    void handleAutListEvent() {
        String[] selection;
        if (this.m_autList.getItemCount() == 0) {
            this.m_editButton.setEnabled(false);
            this.m_removeButton.setEnabled(false);
            return;
        }
        if (this.m_autList.getSelectionCount() > 0 && !"".equals((selection = this.m_autList.getSelection())[0])) {
            this.m_editButton.setEnabled(true);
            this.m_removeButton.setEnabled(true);
        }
    }

    private void addListeners() {
        this.m_addButton.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_editButton.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_removeButton.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_autList.addSelectionListener((SelectionListener)this.m_selectionListener);
    }

    private class WidgetSelectionListener
    implements SelectionListener {
        private WidgetSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object o = e.getSource();
            if (o == AUTPropertyPage.this.m_addButton) {
                AUTPropertyPage.this.handleAddButtonEvent();
                return;
            }
            if (o == AUTPropertyPage.this.m_editButton) {
                AUTPropertyPage.this.handleEditButtonEvent();
                return;
            }
            if (o == AUTPropertyPage.this.m_removeButton) {
                AUTPropertyPage.this.handleRemoveButtonEvent();
                return;
            }
            if (o == AUTPropertyPage.this.m_autList) {
                AUTPropertyPage.this.handleAutListEvent();
                return;
            }
            Assert.notReached((String)(String.valueOf(Messages.EventWasCreatedByAnUnknownWidget) + "."));
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            Object o = e.getSource();
            if (o == AUTPropertyPage.this.m_autList) {
                AUTPropertyPage.this.handleEditButtonEvent();
                return;
            }
            Assert.notReached((String)Messages.DoubleClickEventWasCreatedByAnUnknownWidget);
        }
    }
}

