/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.utils;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public final class DialogUtils {
    private static final int MODAL = 229376;

    private DialogUtils() {
    }

    public static void setWidgetNameForModalDialog(Dialog dialog) {
        Shell parentShell = dialog.getShell();
        if (parentShell != null && (parentShell.getStyle() & 0x38000) > 0) {
            DialogUtils.setWidgetName((Widget)parentShell, DialogUtils.getShortClassName(dialog.getClass()));
        }
    }

    public static void setWidgetName(Widget widget, String name) {
        if (widget != null && !widget.isDisposed()) {
            widget.setData("TEST_COMP_NAME", (Object)name);
        }
    }

    private static String getShortClassName(Class classObj) {
        String longClassName = String.valueOf(classObj);
        int indexOfLastDot = longClassName.lastIndexOf(46);
        String shortClassName = indexOfLastDot >= 0 ? longClassName.substring(indexOfLastDot + 1) : longClassName;
        return shortClassName;
    }

    public static void adjustShellSizeRelativeToClientSize(Shell shell, float relWidth, float relHeight) {
        DialogUtils.adjustShellSizeRelativeToRectangleSize(shell, relWidth, relHeight, Plugin.getActiveWorkbenchWindowShell().getBounds());
    }

    public static void adjustShellSizeRelativeToDisplaySize(Shell shell, float relWidth, float relHeight) {
        Display display = Display.getCurrent();
        Rectangle r = display.getClientArea();
        DialogUtils.adjustShellSizeRelativeToRectangleSize(shell, relWidth, relHeight, r);
    }

    private static void adjustShellSizeRelativeToRectangleSize(Shell shell, float relWidth, float relHeight, Rectangle relativeTo) {
        int dWidth = relativeTo.width;
        int dHeight = relativeTo.height;
        int newShellWidth = Math.round(relWidth * (float)dWidth);
        int newShellHeight = Math.round(relHeight * (float)dHeight);
        shell.setSize(newShellWidth, newShellHeight);
        shell.setLocation((dWidth - shell.getSize().x) / 2 + relativeTo.x, (dHeight - shell.getSize().y) / 2 + relativeTo.y);
    }
}

