/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.Utils;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerManager {
    private static ServerManager instance = null;
    private SortedSet<Server> m_servers = new TreeSet<Server>();
    private Map<String, SortedSet<String>> m_jreCont = new HashMap<String, SortedSet<String>>();
    private Server m_lastUsedServer = null;
    private Server m_defaultServer = null;

    private ServerManager() {
        try {
            this.readFromPrefStore(false);
            if (this.m_servers.isEmpty()) {
                this.setDefaultValues();
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.handleError();
        }
        catch (JBException jBException) {
            this.handleError();
        }
    }

    public static ServerManager getInstance() {
        if (instance == null) {
            instance = new ServerManager();
        }
        return instance;
    }

    private void readFromPrefStore(boolean restored) throws StringIndexOutOfBoundsException, JBException {
        String storage = "";
        if (restored) {
            this.addServer(this.getDefaultServer());
        } else {
            String serverPort = Plugin.getDefault().getPreferenceStore().getString("LAST_USED_SERVER_KEY");
            if (serverPort != null && !serverPort.equals("") && !serverPort.equals(":-1")) {
                this.m_lastUsedServer = new Server(serverPort.substring(0, serverPort.indexOf(":")), new Integer(serverPort.substring(serverPort.indexOf(":") + 1)));
                this.m_servers.add(this.m_lastUsedServer);
            } else {
                this.m_lastUsedServer = null;
            }
            storage = Plugin.getDefault().getPreferenceStore().getString("SERVER_SETTINGS_KEY");
            String defServer = Plugin.getDefault().getPreferenceStore().getDefaultString("SERVER_SETTINGS_KEY");
            if (storage != null && !storage.equals(defServer)) {
                this.decodeServerPrefs(storage);
            }
            if (this.m_servers.isEmpty()) {
                this.addServer(this.getDefaultServer());
            }
        }
    }

    private void decodeServerPrefs(String store) throws JBException {
        this.m_servers.clear();
        String storage = store;
        while (storage.length() > 0) {
            String serverName = this.decodeString(storage, ";");
            storage = storage.substring(storage.indexOf(";") + 1);
            String portPart = storage.substring(0, storage.indexOf(";"));
            while (portPart.length() > 0) {
                String port = this.decodeString(portPart, ",");
                portPart = portPart.substring(portPart.indexOf(",") + 1);
                this.m_servers.add(new Server(serverName, new Integer(port)));
            }
            storage = storage.substring(storage.indexOf(";") + 1);
            String jrePart = storage.substring(0, storage.indexOf(";"));
            TreeSet<String> jres = new TreeSet<String>();
            while (jrePart.length() > 0) {
                String jre = this.decodeString(jrePart, ",");
                jrePart = jrePart.substring(jrePart.indexOf(",") + 1);
                jres.add(jre);
            }
            storage = storage.substring(storage.indexOf(";") + 1);
            this.m_jreCont.put(serverName, jres);
        }
    }

    String decodeString(String encodedString, String delimiter) throws JBException {
        String decodedString = "";
        this.checkPreferences(encodedString.substring(0, encodedString.indexOf(delimiter)));
        decodedString = new String(Base64.decodeBase64((byte[])encodedString.substring(0, encodedString.indexOf(delimiter)).getBytes()));
        return decodedString;
    }

    public void setDefaultValues() {
        this.m_servers.clear();
        try {
            this.readFromPrefStore(true);
        }
        catch (JBException jBException) {}
    }

    public void addServer(Server server) {
        Validate.notNull((Object)server, (String)(String.valueOf(Messages.ServerObjectMustNotBeNull) + "."));
        if (!server.getName().equals("") && !this.m_servers.contains(server)) {
            this.m_servers.add(server);
        }
    }

    public void addJRE(String serverName, String jre) {
        if (this.m_jreCont.get(serverName) != null) {
            SortedSet<String> jres = this.m_jreCont.get(serverName);
            if (!jres.contains(jre)) {
                jres.add(jre);
            }
        } else {
            TreeSet<String> jres = new TreeSet<String>();
            jres.add(jre);
            this.m_jreCont.put(serverName, jres);
        }
    }

    public void removeJRE(String serverName, String jre) {
        SortedSet<String> jres;
        if (this.m_jreCont.get(serverName) != null && (jres = this.m_jreCont.get(serverName)).contains(jre)) {
            jres.remove(jre);
            if (jres.isEmpty()) {
                this.m_jreCont.remove(serverName);
            }
        }
    }

    public void removeServer(Server server) {
        if (this.m_lastUsedServer != null && this.m_lastUsedServer.equals(server)) {
            this.m_lastUsedServer = null;
        }
        this.m_servers.remove(server);
        this.m_jreCont.remove(server);
    }

    public void storeServerList() {
        String storage = "";
        for (Server server : this.m_servers) {
            byte[] serverArray = server.getName().getBytes();
            String serverEncoded = new String(Base64.encodeBase64((byte[])serverArray));
            storage = String.valueOf(storage) + serverEncoded + ";";
            for (Integer port : this.getAllPorts(server.getName())) {
                serverArray = port.toString().getBytes();
                serverEncoded = new String(Base64.encodeBase64((byte[])serverArray));
                storage = String.valueOf(storage) + serverEncoded + ",";
            }
            storage = String.valueOf(storage) + ";";
            if (this.m_jreCont.get(server.getName()) != null) {
                for (String jre : this.m_jreCont.get(server.getName())) {
                    serverArray = jre.getBytes();
                    serverEncoded = new String(Base64.encodeBase64((byte[])serverArray));
                    storage = String.valueOf(storage) + serverEncoded + ",";
                }
            }
            storage = String.valueOf(storage) + ";";
        }
        Plugin.getDefault().getPreferenceStore().setValue("SERVER_SETTINGS_KEY", storage);
        if (this.m_lastUsedServer != null) {
            if (this.m_servers.contains(this.m_lastUsedServer)) {
                Plugin.getDefault().getPreferenceStore().setValue("LAST_USED_SERVER_KEY", this.buildLastUsedServerPortString(this.m_lastUsedServer));
            } else {
                this.m_lastUsedServer = null;
            }
        }
        DataEventDispatcher.getInstance().fireServerPreferencesChanged();
    }

    private String buildLastUsedServerPortString(Server lastUsedServer) {
        if (lastUsedServer != null) {
            return String.valueOf(lastUsedServer.getName()) + ":" + lastUsedServer.getPort();
        }
        Integer port = new Integer(-1);
        return ":" + port;
    }

    public Server getServer(String serverName, Integer port) {
        Server serv = null;
        for (Server server : this.m_servers) {
            if (!serverName.equals(server.getName()) || !server.getPort().equals(port)) continue;
            serv = server;
        }
        return serv;
    }

    public boolean containsServer(String serverName) {
        Validate.notNull((Object)serverName);
        for (Server server : this.m_servers) {
            if (!serverName.equals(server.getName())) continue;
            return true;
        }
        return false;
    }

    public SortedSet<String> getServerNames() {
        TreeSet<String> serverNames = new TreeSet<String>();
        for (Server server : this.m_servers) {
            if ("".equals(server.getName())) continue;
            serverNames.add(server.getName());
        }
        return serverNames;
    }

    public SortedSet<Integer> getPorts(String name) {
        Validate.notNull((Object)name);
        TreeSet<Integer> ports = new TreeSet<Integer>();
        for (Server server : this.m_servers) {
            if (!name.equals(server.getName())) continue;
            ports.add(server.getPort());
        }
        return ports;
    }

    public SortedSet<String> getJREs(String serverName) {
        SortedSet<String> jres = new TreeSet<String>();
        if (this.m_jreCont.get(serverName) != null) {
            jres = this.m_jreCont.get(serverName);
        }
        return jres;
    }

    public List<Integer> getAllPorts(String serverName) {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        for (Server server : this.m_servers) {
            if (!serverName.equals(server.getName())) continue;
            ports.add(server.getPort());
        }
        return ports;
    }

    public Server getLastUsedServer() {
        return this.m_lastUsedServer;
    }

    private void checkPreferences(String pref) throws JBException {
        if (!Base64.isArrayByteBase64((byte[])pref.getBytes())) {
            throw new JBException("", new Integer(0));
        }
    }

    private void handleError() {
        Utils.createMessageDialog(MessageIDs.I_WRONG_SERVER_PREFS);
        this.setDefaultValues();
        this.storeServerList();
    }

    public Server getDefaultServer() {
        if (this.m_defaultServer == null) {
            String defServer = Plugin.getDefault().getPreferenceStore().getDefaultString("SERVER_SETTINGS_KEY");
            String[] str = defServer.split(":");
            this.m_defaultServer = new Server(str[0], new Integer(str[1]));
        }
        return this.m_defaultServer;
    }

    public SortedSet<Server> getServers() {
        return this.m_servers;
    }

    public void setServers(SortedSet<Server> servers) {
        this.m_servers = servers;
    }

    public void setJreCont(Map<String, SortedSet<String>> jreCont) {
        this.m_jreCont = jreCont;
    }

    public void setLastUsedServer(Server server) {
        this.m_lastUsedServer = server;
    }

    public static class Server
    implements Comparable {
        private String m_name;
        private Integer m_port = new Integer(-1);

        public Server(String name, Integer port) {
            this.m_name = name;
            this.m_port = port;
        }

        public String getName() {
            return this.m_name;
        }

        public Integer getPort() {
            return this.m_port;
        }

        public void setName(String name) {
            this.m_name = name;
        }

        public void setPort(Integer port) {
            this.m_port = port;
        }

        public int compareTo(Object o) {
            Server server = (Server)o;
            if (this.getName().compareTo(server.getName()) == 0) {
                return this.getPort().compareTo(server.getPort());
            }
            return this.getName().compareTo(server.getName());
        }
    }
}

