/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.views.problemview;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jubula.client.core.businessprocess.problems.ProblemType;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.utils.ExecTreeTraverser;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.core.utils.SpecTreeTraverser;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.actions.ChooseServerAction;
import org.eclipse.jubula.client.ui.editors.ObjectMappingMultiPageEditor;
import org.eclipse.jubula.client.ui.handlers.open.AbstractOpenHandler;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.CommandHelper;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JBMarkerResolutionGenerator
implements IMarkerResolutionGenerator {
    private static Logger log = LoggerFactory.getLogger(JBMarkerResolutionGenerator.class);

    public IMarkerResolution[] getResolutions(IMarker marker) {
        try {
            Object reasonInt = marker.getAttribute("gdReason");
            if (!(reasonInt instanceof Integer) || reasonInt == null) {
                return new IMarkerResolution[0];
            }
            ProblemType type = ProblemType.values()[(Integer)reasonInt];
            Object gdObject = marker.getAttribute("gdObject");
            String gdNodeName = (String)marker.getAttribute("tstNodeName");
            return this.getResolutions(type, gdObject, gdNodeName);
        }
        catch (CoreException ce) {
            log.info(Messages.ErrorOccurredWhileFindingResolutionsForProblemMarker, (Throwable)ce);
            return new IMarkerResolution[0];
        }
    }

    private IMarkerResolution[] getResolutions(ProblemType type, Object gdObject, String gdNodeName) {
        switch (type) {
            case REASON_CONNECTED_TO_NO_SERVER: {
                return this.getNoServerConnectionResolutions();
            }
            case REASON_NO_AUT_FOR_TESTSUITE_SELECTED: 
            case REASON_EMPTY_TESTSUITE: 
            case REASON_TD_INCOMPLETE: {
                return this.getOpenTSEditorResolutions(gdObject, gdNodeName);
            }
            case REASON_NO_AUT_FOR_PROJECT_EXISTS: 
            case REASON_NO_AUTCONFIG_FOR_SERVER_EXIST: 
            case REASON_NOJAR_FOR_AUTCONFIG: 
            case REASON_NOSERVER_FOR_AUTCONFIG: {
                return this.getNoAUTResolutions();
            }
            case REASON_NO_PROJECT: {
                return this.getNoProjectResolutions();
            }
            case REASON_NO_TESTSUITE: {
                return this.getNoTestSuiteResolutions();
            }
            case REASON_OM_INCOMPLETE: {
                return this.getOMIncompleteResolutions(gdObject, gdNodeName);
            }
            case REASON_NO_SERVER_DEFINED: {
                return this.getNoServerDefinedResolutions();
            }
            case REASON_DEPRECATED_ACTION: 
            case REASON_DEPRECATED_COMP: {
                return this.getDeprecatedActionOrComponentResolutions(gdObject);
            }
            case REASON_NO_COMPTYPE: {
                return this.getNoCompTypeResolutions(gdObject, gdNodeName);
            }
            case REASON_PROJECT_DOES_NOT_EXIST: {
                return this.getMissingProjectResolutions();
            }
            case REASON_MISSING_SPEC_TC: {
                return this.getMissingSpecTcResolutions(gdObject);
            }
            case REASON_UNUSED_TESTDATA: {
                return this.getUnusedTestDataResolutions(gdObject, gdNodeName);
            }
        }
        return new IMarkerResolution[0];
    }

    private IMarkerResolution[] getNoServerConnectionResolutions() {
        return new IMarkerResolution[]{new IMarkerResolution(){

            public String getLabel() {
                return Messages.GDProblemViewConnectToAutStarter;
            }

            public void run(IMarker marker) {
                new ChooseServerAction().runWithEvent(null, new Event());
            }
        }};
    }

    private IMarkerResolution[] getMissingProjectResolutions() {
        return new IMarkerResolution[]{new IMarkerResolution(){

            public String getLabel() {
                return Messages.GDProblemViewOpenReusedProjectSettings;
            }

            public void run(IMarker marker) {
                Command projectPropertiesCommand = CommandHelper.getCommandService().getCommand("org.eclipse.jubula.client.ui.commands.ProjectProperties");
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("org.eclipse.jubula.client.ui.commands.ProjectProperties.parameter.sectionToOpen", "org.eclipse.jubula.client.ui.projectProperties.ReusedProjectPropertyPage");
                CommandHelper.executeParameterizedCommand(ParameterizedCommand.generateCommand((Command)projectPropertiesCommand, parameters));
            }
        }};
    }

    private IMarkerResolution[] getMissingSpecTcResolutions(final Object gdObject) {
        return new IMarkerResolution[]{new IMarkerResolution(){

            public String getLabel() {
                return Messages.GDProblemViewOpenTestCaseEditor;
            }

            public void run(IMarker marker) {
                ITreeNodeOperation<INodePO> op = new ITreeNodeOperation<INodePO>(){

                    public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
                        if (gdObject == null) {
                            ctx.setContinued(false);
                        } else if (node.toString().equals(gdObject.toString())) {
                            ctx.setContinued(false);
                            if (node instanceof IExecTestCasePO) {
                                IExecTestCasePO execTcPO = (IExecTestCasePO)node;
                                ISpecTestCasePO specTcPO = execTcPO.getSpecTestCase();
                                AbstractOpenHandler.openEditor((IPersistentObject)specTcPO);
                            } else if (node instanceof ISpecTestCasePO) {
                                ISpecTestCasePO specTcPO = (ISpecTestCasePO)node;
                                AbstractOpenHandler.openEditor((IPersistentObject)specTcPO);
                            } else if (node instanceof ITestSuitePO) {
                                ITestSuitePO testSuitePO = (ITestSuitePO)node;
                                AbstractOpenHandler.openEditor((IPersistentObject)testSuitePO);
                            }
                        }
                        return true;
                    }

                    public void postOperate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
                    }
                };
                IProjectPO project = GeneralStorage.getInstance().getProject();
                ExecTreeTraverser traverser = new ExecTreeTraverser((INodePO)project, (ITreeNodeOperation)op);
                traverser.traverse();
            }
        }};
    }

    private IMarkerResolution[] getDeprecatedActionOrComponentResolutions(final Object gdObject) {
        return new IMarkerResolution[]{new IMarkerResolution(){

            public String getLabel() {
                return Messages.GDProblemViewOpenTestCaseEditor;
            }

            public void run(IMarker marker) {
                ITreeNodeOperation<INodePO> op = new ITreeNodeOperation<INodePO>(){

                    public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
                        if (node.toString().equals(gdObject.toString())) {
                            ctx.setContinued(false);
                            INodePO editableNode = node.getParentNode();
                            if (editableNode == null) {
                                return true;
                            }
                            AbstractOpenHandler.openEditor((IPersistentObject)editableNode);
                        }
                        return true;
                    }

                    public void postOperate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
                    }
                };
                SpecTreeTraverser traverser = new SpecTreeTraverser((INodePO)GeneralStorage.getInstance().getProject(), (ITreeNodeOperation)op);
                traverser.traverse();
            }
        }};
    }

    private IMarkerResolution[] getNoCompTypeResolutions(final Object gdObject, String nodeName) {
        if (gdObject.toString().contains("TestSuitePO")) {
            return this.getOpenTSEditorResolutions(gdObject, nodeName);
        }
        return new IMarkerResolution[]{new IMarkerResolution(){

            public String getLabel() {
                return Messages.GDProblemViewOpenTestCaseEditor;
            }

            public void run(IMarker marker) {
                IProjectPO project = GeneralStorage.getInstance().getProject();
                OpenSpecTcEditorOperation op = new OpenSpecTcEditorOperation(gdObject);
                SpecTreeTraverser traverser = new SpecTreeTraverser((INodePO)project, (ITreeNodeOperation)op);
                traverser.traverse();
            }
        }};
    }

    private IMarkerResolution[] getNoAUTResolutions() {
        return new IMarkerResolution[]{new IMarkerResolution(){

            public String getLabel() {
                return Messages.GDProblemViewOpenAutSettings;
            }

            public void run(IMarker marker) {
                Command projectPropertiesCommand = CommandHelper.getCommandService().getCommand("org.eclipse.jubula.client.ui.commands.ProjectProperties");
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("org.eclipse.jubula.client.ui.commands.ProjectProperties.parameter.sectionToOpen", "org.eclipse.jubula.client.ui.projectProperties.AUTPropertyPage");
                CommandHelper.executeParameterizedCommand(ParameterizedCommand.generateCommand((Command)projectPropertiesCommand, parameters));
            }
        }};
    }

    private IMarkerResolution[] getNoServerDefinedResolutions() {
        return new IMarkerResolution[]{new IMarkerResolution(){

            public String getLabel() {
                return Messages.GDProblemViewOpenAutStarterPreferences;
            }

            public void run(IMarker marker) {
                PreferenceManager pm = Plugin.getDefault().getWorkbench().getPreferenceManager();
                for (Object obj : pm.getElements(0)) {
                    PreferenceNode node = (PreferenceNode)obj;
                    if (!node.getId().equals("org.eclipse.jubula.client.ui.preferences.AutAgentPrefPage")) continue;
                    PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, (String)"org.eclipse.jubula.client.ui.preferences.AutAgentPrefPage", null, null);
                    DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
                    dialog.open();
                    break;
                }
            }
        }};
    }

    private IMarkerResolution[] getNoProjectResolutions() {
        return new IMarkerResolution[]{new IMarkerResolution(){

            public String getLabel() {
                return Messages.GDProblemViewCreate;
            }

            public void run(IMarker marker) {
                CommandHelper.executeCommand("org.eclipse.jubula.client.ui.commands.NewProject");
            }
        }, new IMarkerResolution(){

            public String getLabel() {
                return Messages.GDProblemViewImport;
            }

            public void run(IMarker marker) {
                CommandHelper.executeCommand("org.eclipse.jubula.client.ui.commands.ImportProject");
            }
        }, new IMarkerResolution(){

            public String getLabel() {
                return Messages.GDProblemViewOpen;
            }

            public void run(IMarker marker) {
                CommandHelper.executeCommand("org.eclipse.jubula.client.ui.commands.OpenProject");
            }
        }};
    }

    private IMarkerResolution[] getOMIncompleteResolutions(Object obj, String nodeName) {
        if (obj instanceof String) {
            return new IMarkerResolution[]{new OpenOMEditorMarkerResolution((String)obj, nodeName)};
        }
        return new IMarkerResolution[0];
    }

    private IMarkerResolution[] getUnusedTestDataResolutions(Object gdObject, String nodeName) {
        return this.getNoCompTypeResolutions(gdObject, nodeName);
    }

    private IMarkerResolution[] getOpenTSEditorResolutions(Object obj, String nodeName) {
        if (obj instanceof String) {
            return new IMarkerResolution[]{new OpenTSEditorMarkerResolution((String)obj, nodeName)};
        }
        return new IMarkerResolution[0];
    }

    private IMarkerResolution[] getNoTestSuiteResolutions() {
        return new IMarkerResolution[]{new IMarkerResolution(){

            public String getLabel() {
                return Messages.GDProblemViewCreateTestSuite;
            }

            public void run(IMarker marker) {
                CommandHelper.executeCommand("org.eclipse.jubula.client.ui.commands.NewTestSuiteCommand");
            }
        }};
    }

    private static class OpenOMEditorMarkerResolution
    implements IMarkerResolution {
        private String m_tsName;
        private String m_nodeName;

        public OpenOMEditorMarkerResolution(String testSuiteName, String nodeName) {
            this.m_tsName = testSuiteName;
            this.m_nodeName = nodeName;
        }

        public String getLabel() {
            return NLS.bind((String)Messages.GDProblemViewOpenObjectMappingEditor, (Object)this.m_nodeName);
        }

        public void run(IMarker marker) {
            List tsList = GeneralStorage.getInstance().getProject().getTestSuiteCont().getTestSuiteList();
            for (ITestSuitePO ts : tsList) {
                if (!ts.toString().equals(this.m_tsName)) continue;
                ObjectMappingMultiPageEditor editor = (ObjectMappingMultiPageEditor)AbstractOpenHandler.openEditor((IPersistentObject)ts.getAut());
                editor.getSite().getPage().activate((IWorkbenchPart)editor);
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OpenSpecTcEditorOperation
    implements ITreeNodeOperation<INodePO> {
        private final Object m_gdObject;

        public OpenSpecTcEditorOperation(Object gdObject) {
            this.m_gdObject = gdObject;
        }

        public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            if (node.toString().equals(this.m_gdObject.toString())) {
                ctx.setContinued(false);
                if (node instanceof IExecTestCasePO) {
                    IExecTestCasePO execTcPO = (IExecTestCasePO)node;
                    ISpecTestCasePO specTcPO = execTcPO.getSpecTestCase();
                    AbstractOpenHandler.openEditor((IPersistentObject)specTcPO);
                } else if (node instanceof ISpecTestCasePO) {
                    ISpecTestCasePO specTcPO = (ISpecTestCasePO)node;
                    AbstractOpenHandler.openEditor((IPersistentObject)specTcPO);
                }
            }
            return true;
        }

        public void postOperate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
        }
    }

    private static class OpenTSEditorMarkerResolution
    implements IMarkerResolution {
        private String m_tsName;
        private String m_nodeName;

        public OpenTSEditorMarkerResolution(String testSuiteName, String nodeName) {
            this.m_tsName = testSuiteName;
            this.m_nodeName = nodeName;
        }

        public String getLabel() {
            return NLS.bind((String)Messages.GDProblemViewOpenTestSuiteEditor, (Object)this.m_nodeName);
        }

        public void run(IMarker marker) {
            List tsList = GeneralStorage.getInstance().getProject().getTestSuiteCont().getTestSuiteList();
            for (ITestSuitePO ts : tsList) {
                if (!ts.toString().equals(this.m_tsName)) continue;
                IEditorPart editor = AbstractOpenHandler.openEditor((IPersistentObject)ts);
                if (editor == null) break;
                editor.setFocus();
                break;
            }
        }
    }
}

