/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.widgets;

import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalListener2;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameMapper;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.widgets.CheckedCompNameText;
import org.eclipse.jubula.client.ui.widgets.CompNamesProposal;
import org.eclipse.jubula.client.ui.widgets.CompNamesProposalProvider;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public final class CompNamePopUpTextField
extends CheckedCompNameText {
    public static final String INITPOPUP = "INITPOPUP";
    protected static final int HEIGHT = 8;
    protected static final int WIDTH = 130;
    protected static final char SPACE = ' ';
    private CompNamesProposalProvider m_contentProposalProvider;
    private ILabelProvider m_labelProvider;
    private boolean m_popupOpen = false;
    private boolean m_modified = false;
    private IContentProposalListener2 m_popupListener;

    public CompNamePopUpTextField(IComponentNameMapper compMapper, Composite composite, int style) {
        super(composite, style);
        KeyStroke ks = null;
        try {
            ks = KeyStroke.getInstance((String)"Ctrl+Space");
        }
        catch (ParseException parseException) {}
        this.m_labelProvider = new LabelProvider(){

            public Image getImage(Object element) {
                CompNamesProposal p = (CompNamesProposal)element;
                char type = p.getLabel().charAt(0);
                switch (type) {
                    case 'G': {
                        return IconConstants.GLOBAL_NAME_IMAGE;
                    }
                    case 'L': {
                        return IconConstants.LOCAL_NAME_IMAGE;
                    }
                    case 'A': {
                        return IconConstants.AUT_COMP_NAME_IMAGE;
                    }
                }
                return null;
            }

            public String getText(Object element) {
                CompNamesProposal p = (CompNamesProposal)element;
                return p.getLabel().substring(1);
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }
        };
        this.m_popupListener = new IContentProposalListener2Implementation();
        this.m_contentProposalProvider = new CompNamesProposalProvider(compMapper);
        this.enableContentProposal(this.m_contentProposalProvider, ks, this.createTriggerChars());
    }

    public void activateSelectionEvent() {
        this.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CompNamePopUpTextField.this.m_modified = true;
            }
        });
        this.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!CompNamePopUpTextField.this.m_popupOpen && CompNamePopUpTextField.this.m_modified) {
                    CompNamePopUpTextField.this.fireSelectionEvent();
                }
            }
        });
    }

    private void fireSelectionEvent() {
        this.getDisplay().syncExec(new Runnable(){

            public void run() {
                if (!CompNamePopUpTextField.this.isDisposed()) {
                    Event modifyEvent = new Event();
                    modifyEvent.widget = CompNamePopUpTextField.this;
                    modifyEvent.type = 24;
                    CompNamePopUpTextField.this.notifyListeners(24, modifyEvent);
                }
            }
        });
    }

    private void enableContentProposal(IContentProposalProvider contentProposalProvider, KeyStroke keyStroke, char[] autoActivationCharacters) {
        ContentProposalAdapter contentProposalAdapter = new ContentProposalAdapter((Control)this, (IControlContentAdapter)new TextContentAdapter(), contentProposalProvider, keyStroke, autoActivationCharacters);
        contentProposalAdapter.setLabelProvider(this.m_labelProvider);
        contentProposalAdapter.addContentProposalListener(this.m_popupListener);
        contentProposalAdapter.setProposalAcceptanceStyle(2);
    }

    private char[] createTriggerChars() {
        char[] trigger = new char[64];
        int index = 0;
        char c = 'a';
        while (c <= 'z') {
            trigger[index++] = c;
            trigger[index++] = Character.toUpperCase(c);
            c = (char)(c + '\u0001');
        }
        int i = 0;
        while (i < 10) {
            trigger[index++] = Character.forDigit(i, 10);
            ++i;
        }
        trigger[index++] = 95;
        trigger[index++] = 8;
        return trigger;
    }

    protected void checkSubclass() {
    }

    public void setFilter(String filter) {
        if (this.m_contentProposalProvider != null) {
            this.m_contentProposalProvider.setTypeFilter(filter);
        }
    }

    public boolean isPopupOpen() {
        return this.m_popupOpen;
    }

    public void setComponentNameMapper(IComponentNameMapper compMapper) {
        if (this.m_contentProposalProvider != null) {
            this.m_contentProposalProvider.setComponentNameMapper(compMapper);
        }
    }

    private final class IContentProposalListener2Implementation
    implements IContentProposalListener2 {
        private IContentProposalListener2Implementation() {
        }

        public void proposalPopupClosed(ContentProposalAdapter adapter) {
            CompNamePopUpTextField.this.m_popupOpen = false;
        }

        public void proposalPopupOpened(ContentProposalAdapter adapter) {
            CompNamePopUpTextField.this.m_popupOpen = true;
        }
    }
}

