/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.widgets;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.widgets.IModifiableListObservable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifiableListObservable
implements IModifiableListObservable {
    private static final Logger LOG = LoggerFactory.getLogger(ModifiableListObservable.class);
    private List<IContentAddedListener> m_contentAddedListener = new ArrayList<IContentAddedListener>();
    private List<IContentChangedListener> m_contentChangedListener = new ArrayList<IContentChangedListener>();
    private List<IContentRemovedListener> m_contentRemovedListener = new ArrayList<IContentRemovedListener>();
    private List<ISelectionChangedListener> m_selectionChangedListener = new ArrayList<ISelectionChangedListener>();
    private List<IOptionalButtonSelectedListener> m_optionalButtonSelectedListener = new ArrayList<IOptionalButtonSelectedListener>();

    public void addContentAddedListener(IContentAddedListener listener) {
        this.m_contentAddedListener.add(listener);
    }

    public void addContentChangedListener(IContentChangedListener listener) {
        this.m_contentChangedListener.add(listener);
    }

    public void addContentRemovedListener(IContentRemovedListener listener) {
        this.m_contentRemovedListener.add(listener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.m_selectionChangedListener.add(listener);
    }

    public void addOptionalButtonSelectedListener(IOptionalButtonSelectedListener listener) {
        this.m_optionalButtonSelectedListener.add(listener);
    }

    public void removeContentAddedListener(IContentAddedListener listener) {
        this.m_contentAddedListener.remove(listener);
    }

    public void removeContentChangedListener(IContentChangedListener listener) {
        this.m_contentChangedListener.remove(listener);
    }

    public void removeContentRemovedListener(IContentRemovedListener listener) {
        this.m_contentRemovedListener.remove(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.m_selectionChangedListener.remove(listener);
    }

    public void removeOptionalButtonSelectedListener(IOptionalButtonSelectedListener listener) {
        this.m_optionalButtonSelectedListener.remove(listener);
    }

    public void fireContentAdded(String newValue) {
        HashSet<IContentAddedListener> listener = new HashSet<IContentAddedListener>(this.m_contentAddedListener);
        for (IContentAddedListener l : listener) {
            try {
                l.updateContentAdded(newValue);
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionWhileCallingListeners, t);
            }
        }
    }

    public void fireContentChanged(String oldValue, String newValue) {
        HashSet<IContentChangedListener> listener = new HashSet<IContentChangedListener>(this.m_contentChangedListener);
        for (IContentChangedListener l : listener) {
            try {
                l.updateContentChanged(oldValue, newValue);
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionWhileCallingListeners, t);
            }
        }
    }

    public void fireContentRemoved(String oldValue) {
        HashSet<IContentRemovedListener> listener = new HashSet<IContentRemovedListener>(this.m_contentRemovedListener);
        for (IContentRemovedListener l : listener) {
            try {
                l.updateContentRemoved(oldValue);
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionWhileCallingListeners, t);
            }
        }
    }

    public void fireSelectionChanged(String value) {
        HashSet<ISelectionChangedListener> listener = new HashSet<ISelectionChangedListener>(this.m_selectionChangedListener);
        for (ISelectionChangedListener l : listener) {
            try {
                l.updateSelectionChanged(value);
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionWhileCallingListeners, t);
            }
        }
    }

    public void fireOptionalButtonSelected() {
        HashSet<IOptionalButtonSelectedListener> listener = new HashSet<IOptionalButtonSelectedListener>(this.m_optionalButtonSelectedListener);
        for (IOptionalButtonSelectedListener l : listener) {
            try {
                l.updateOptionalButtonSelected();
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionWhileCallingListeners, t);
            }
        }
    }

    public static interface IContentAddedListener {
        public void updateContentAdded(String var1);
    }

    public static interface IContentChangedListener {
        public void updateContentChanged(String var1, String var2);
    }

    public static interface IContentRemovedListener {
        public void updateContentRemoved(String var1);
    }

    public static interface IOptionalButtonSelectedListener {
        public void updateOptionalButtonSelected();
    }

    public static interface ISelectionChangedListener {
        public void updateSelectionChanged(String var1);
    }
}

