/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.swing.implclasses;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.HashSet;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.MatchUtil;
import org.eclipse.jubula.rc.swing.swing.implclasses.AbstractSwingImplClass;
import org.eclipse.jubula.tools.objects.event.EventFactory;

public class JListHelper {
    private final AbstractSwingImplClass m_implClass;

    public JListHelper(AbstractSwingImplClass implClass) {
        this.m_implClass = implClass;
    }

    public void clickOnIndex(JList list, Integer i, ClickOptions co, double maxWidth) {
        int index = i;
        ListModel model = list.getModel();
        if (model == null || index >= model.getSize() || index < 0) {
            throw new StepExecutionException("List index '" + i + "' is out of range", EventFactory.createActionError((String)"TestErrorEvent.InvalidIndex"));
        }
        Rectangle r = list.getCellBounds(index, index);
        if (r == null) {
            throw new StepExecutionException("List index '" + i + "' is not visible", EventFactory.createActionError((String)"TestErrorEvent.NotVisible"));
        }
        ListCellRenderer lcr = list.getCellRenderer();
        if (lcr != null) {
            Component listItem = lcr.getListCellRendererComponent(list, model.getElementAt(index), index, false, false);
            Dimension preferredSize = listItem.getPreferredSize();
            r.setSize(preferredSize);
        }
        if (maxWidth != -1.0 && r.getWidth() > maxWidth) {
            Dimension d = new Dimension();
            d.setSize(maxWidth, r.getHeight());
            r.setSize(d);
        }
        this.m_implClass.getRobot().click((Object)list, (Object)r, co.setClickType(ClickOptions.ClickType.RELEASED));
    }

    public void clickOnIndex(JList list, Integer i, ClickOptions co) {
        this.clickOnIndex(list, i, co, -1.0);
    }

    public void clickOnIndex(JList list, Integer i) {
        this.clickOnIndex(list, i, ClickOptions.create().setClickCount(1));
    }

    public Integer[] findIndicesOfValues(final JList list, final String[] values, final String operator, final String searchType) {
        final HashSet indexSet = new HashSet();
        this.m_implClass.getEventThreadQueuer().invokeAndWait("findIndices", new IRunnable(){

            public Object run() {
                ListCellRenderer renderer = list.getCellRenderer();
                ListModel model = list.getModel();
                int i = JListHelper.this.getStartingIndex(list, searchType);
                while (i < model.getSize()) {
                    Object obj = model.getElementAt(i);
                    list.ensureIndexIsVisible(i);
                    Component comp = renderer.getListCellRendererComponent(list, obj, i, false, false);
                    String str = JListHelper.this.m_implClass.getRenderedText(comp, false);
                    if (MatchUtil.getInstance().match(str, values, operator)) {
                        indexSet.add(new Integer(i));
                    }
                    ++i;
                }
                return null;
            }
        });
        Integer[] indices = new Integer[indexSet.size()];
        indexSet.toArray(indices);
        return indices;
    }

    public Integer[] findIndicesOfValues(JList list, String[] values, String operator) {
        return this.findIndicesOfValues(list, values, operator, "absolute");
    }

    public boolean containsValue(JList list, String value) {
        Integer[] indices = this.findIndicesOfValues(list, new String[]{value}, "equals");
        return indices.length > 0;
    }

    public boolean containsValue(JList list, String value, String operator) {
        Integer[] indices = null;
        if (operator.equals("not equals")) {
            indices = this.findIndicesOfValues(list, new String[]{value}, "equals");
            return indices.length == 0;
        }
        indices = this.findIndicesOfValues(list, new String[]{value}, operator);
        return indices.length > 0;
    }

    public int[] getSelectedIndices(final JList list) {
        return (int[])this.m_implClass.getEventThreadQueuer().invokeAndWait("getSelectedIndices", new IRunnable(){

            public Object run() {
                return list.getSelectedIndices();
            }
        });
    }

    public String[] getSelectedValues(final JList list) {
        final int[] indices = this.getSelectedIndices(list);
        return (String[])this.m_implClass.getEventThreadQueuer().invokeAndWait("getSelectedValues", new IRunnable(){

            public Object run() {
                Object[] values = list.getSelectedValues();
                String[] selected = new String[values.length];
                ListCellRenderer<Object> renderer = list.getCellRenderer();
                int i = 0;
                while (i < values.length) {
                    Object value = values[i];
                    Component c = renderer.getListCellRendererComponent(list, value, indices[i], true, false);
                    selected[i] = JListHelper.this.m_implClass.getRenderedText(c, false);
                    ++i;
                }
                return selected;
            }
        });
    }

    private int getStartingIndex(JList list, String searchType) {
        int startingIndex = 0;
        if (searchType.equalsIgnoreCase("relative")) {
            int[] selectedIndices = this.getSelectedIndices(list);
            startingIndex = selectedIndices[selectedIndices.length - 1] + 1;
        }
        return startingIndex;
    }

    public String getText(boolean switchToGUIThread) {
        String[] values = this.getSelectedValues((JList)this.m_implClass.getComponent());
        int size = 0;
        int i = 0;
        while (i < values.length) {
            size += values[i].length();
            ++i;
        }
        StringBuffer txt = new StringBuffer(size);
        int i2 = 0;
        while (i2 < values.length) {
            txt.append(values[i2]);
            ++i2;
        }
        return txt.toString();
    }
}

