/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.implclasses;

import java.awt.Point;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.exception.StepVerifyFailedException;
import org.eclipse.jubula.rc.common.implclasses.Verifier;
import org.eclipse.jubula.rc.swt.driver.DragAndDropHelperSwt;
import org.eclipse.jubula.rc.swt.driver.SwtRobot;
import org.eclipse.jubula.rc.swt.implclasses.AbstractSwtImplClass;
import org.eclipse.jubula.rc.swt.implclasses.MenuUtil;
import org.eclipse.jubula.rc.swt.implclasses.PopupMenuUtil;
import org.eclipse.jubula.rc.swt.implclasses.SimulatedTooltip;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.jubula.tools.utils.EnvironmentUtils;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractControlImplClass
extends AbstractSwtImplClass {
    public abstract Control getComponent();

    public void gdWaitForComponent(int timeout, int delay) {
    }

    protected void verify(boolean expected, String name, IRunnable runnable) throws StepVerifyFailedException {
        Boolean actual = (Boolean)this.getEventThreadQueuer().invokeAndWait(name, runnable);
        Verifier.equals((boolean)expected, (boolean)actual);
    }

    String getRenderedTextImpl(Control renderer) throws StepExecutionException {
        if (renderer instanceof Label) {
            return ((Label)renderer).getText();
        }
        if (renderer instanceof Button) {
            return ((Button)renderer).getText();
        }
        if (renderer instanceof Text) {
            return ((Text)renderer).getText();
        }
        throw new StepExecutionException("Table cell renderer not supported: " + renderer.getClass(), EventFactory.createActionError((String)"TestErrorEvent.RendererNotSupported"));
    }

    protected String getRenderedText(final Control renderer, boolean queueInEventThread) throws StepExecutionException {
        if (queueInEventThread) {
            return (String)this.getEventThreadQueuer().invokeAndWait("getRenderedText", new IRunnable(){

                public Object run() {
                    return AbstractControlImplClass.this.getRenderedTextImpl(renderer);
                }
            });
        }
        return this.getRenderedTextImpl(renderer);
    }

    public void gdVerifyEnabled(boolean enabled) {
        this.verify(enabled, "isEnabled", new IRunnable(){

            public Object run() {
                return AbstractControlImplClass.this.getComponent().isEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    public void gdVerifyExists(boolean exists) {
        this.verify(exists, "exists", new IRunnable(){

            public Object run() {
                return AbstractControlImplClass.this.getComponent().isVisible() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    public void gdVerifyFocus(boolean hasFocus) {
        this.verify(hasFocus, "hasFocus", new IRunnable(){

            public Object run() {
                return AbstractControlImplClass.this.getComponent().isFocusControl() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    public void gdVerifyProperty(final String name, String value, String operator) {
        final Control bean = this.getComponent();
        Validate.notNull((Object)bean, (String)"Tested component must not be null");
        Object prop = this.getEventThreadQueuer().invokeAndWait("getProperty", new IRunnable(){

            public Object run() throws StepExecutionException {
                try {
                    return PropertyUtils.getProperty((Object)bean, (String)name);
                }
                catch (IllegalAccessException e) {
                    throw new StepExecutionException(e.getMessage(), EventFactory.createActionError((String)"TestErrorEvent.PropertyNotAccessable"));
                }
                catch (InvocationTargetException e) {
                    throw new StepExecutionException(e.getMessage(), EventFactory.createActionError((String)"TestErrorEvent.PropertyNotAccessable"));
                }
                catch (NoSuchMethodException e) {
                    throw new StepExecutionException(e.getMessage(), EventFactory.createActionError((String)"TestErrorEvent.PropertyNotAccessable"));
                }
            }
        });
        String propToStr = String.valueOf(prop);
        Verifier.match((String)propToStr, (String)value, (String)operator);
    }

    public void gdClick(int count, int button) {
        this.getRobot().click((Object)this.getComponent(), null, ClickOptions.create().setClickCount(count).setMouseButton(button));
    }

    public void gdClick(int count) {
        this.gdClick(count, 1);
    }

    public void gdClickDirect(int count, int button, int xPos, String xUnits, int yPos, String yUnits) throws StepExecutionException {
        this.clickDirect(count, button, xPos, xUnits, yPos, yUnits, null);
    }

    protected void clickDirect(int count, int button, int xPos, String xUnits, int yPos, String yUnits, Object constraints) throws StepExecutionException {
        this.getRobot().click((Object)this.getComponent(), constraints, ClickOptions.create().setClickCount(count).setMouseButton(button), xPos, xUnits.equalsIgnoreCase("Pixel"), yPos, yUnits.equalsIgnoreCase("Pixel"));
    }

    protected boolean hasFocus() {
        Boolean hasFocus = (Boolean)this.getEventThreadQueuer().invokeAndWait("hasFocus", new IRunnable(){

            public Object run() {
                return AbstractControlImplClass.this.getComponent().isFocusControl() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return hasFocus;
    }

    public void gdPopupSelectByIndexPath(int xPos, int yPos, String units, String indexPath) throws StepExecutionException {
        this.gdPopupSelectByIndexPath(xPos, units, yPos, units, indexPath, 3);
    }

    public void gdPopupSelectByIndexPath(int xPos, String xUnits, int yPos, String yUnits, String indexPath, int button) throws StepExecutionException {
        Menu popup = PopupMenuUtil.showPopup((Widget)this.getComponent(), this.getRobot(), xPos, xUnits, yPos, yUnits, button);
        PopupMenuUtil.selectMenuItem(this.getRobot(), popup, MenuUtil.splitIndexPath(indexPath));
    }

    public void gdPopupSelectByIndexPath(String indexPath) throws StepExecutionException {
        this.gdPopupSelectByIndexPath(indexPath, 3);
    }

    public void gdPopupSelectByIndexPath(String indexPath, int button) throws StepExecutionException {
        Menu popup = PopupMenuUtil.showPopup((Widget)this.getComponent(), this.getRobot(), button);
        PopupMenuUtil.selectMenuItem(this.getRobot(), popup, MenuUtil.splitIndexPath(indexPath));
    }

    public void gdPopupSelectByTextPath(String textPath, String operator) throws StepExecutionException {
        this.gdPopupSelectByTextPath(textPath, operator, 3);
    }

    public void gdPopupSelectByTextPath(String textPath, String operator, int button) throws StepExecutionException {
        Menu popup = PopupMenuUtil.showPopup((Widget)this.getComponent(), this.getRobot(), button);
        PopupMenuUtil.selectMenuItem(this.getRobot(), popup, MenuUtil.splitPath(textPath), operator);
    }

    public void gdPopupSelectByTextPath(int xPos, int yPos, String units, String textPath, String operator) throws StepExecutionException {
        this.gdPopupSelectByTextPath(xPos, units, yPos, units, textPath, operator, 3);
    }

    public void gdPopupSelectByTextPath(int xPos, String xUnits, int yPos, String yUnits, String textPath, String operator, int button) throws StepExecutionException {
        Menu popup = PopupMenuUtil.showPopup((Widget)this.getComponent(), this.getRobot(), xPos, xUnits, yPos, yUnits, button);
        PopupMenuUtil.selectMenuItem(this.getRobot(), popup, MenuUtil.splitPath(textPath), operator);
    }

    public void gdPopupVerifyEnabledByIndexPath(String indexPath, boolean enabled, int button) throws StepExecutionException {
        Menu popup = PopupMenuUtil.showPopup((Widget)this.getComponent(), this.getRobot(), button);
        this.popupVerifyEnabledByIndexPath(indexPath, popup, enabled);
    }

    public void gdPopupVerifyEnabledByIndexPath(int xPos, String xUnits, int yPos, String yUnits, String indexPath, boolean enabled, int button) throws StepExecutionException {
        Menu popup = PopupMenuUtil.showPopup((Widget)this.getComponent(), this.getRobot(), xPos, xUnits, yPos, yUnits, button);
        this.popupVerifyEnabledByIndexPath(indexPath, popup, enabled);
    }

    public void gdPopupVerifyEnabledByTextPath(String textPath, String operator, boolean enabled, int button) throws StepExecutionException {
        Menu popup = PopupMenuUtil.showPopup((Widget)this.getComponent(), this.getRobot(), button);
        this.popupVerifyEnabledByTextPath(textPath, operator, popup, enabled);
    }

    public void gdPopupVerifyEnabledByTextPath(int xPos, String xUnits, int yPos, String yUnits, String textPath, String operator, boolean enabled, int button) throws StepExecutionException {
        Menu popup = PopupMenuUtil.showPopup((Widget)this.getComponent(), this.getRobot(), xPos, xUnits, yPos, yUnits, button);
        this.popupVerifyEnabledByTextPath(textPath, operator, popup, enabled);
    }

    public void gdPopupVerifyExistsByIndexPath(String indexPath, boolean exists, int button) throws StepExecutionException {
        Menu popup = PopupMenuUtil.showPopup((Widget)this.getComponent(), this.getRobot(), button);
        this.popupVerifyExistsByIndexPath(indexPath, popup, exists);
    }

    public void gdPopupVerifyExistsByIndexPath(int xPos, String xUnits, int yPos, String yUnits, String indexPath, boolean exists, int button) throws StepExecutionException {
        Menu popup = PopupMenuUtil.showPopup((Widget)this.getComponent(), this.getRobot(), xPos, xUnits, yPos, yUnits, button);
        this.popupVerifyExistsByIndexPath(indexPath, popup, exists);
    }

    public void gdPopupVerifyExistsByTextPath(String textPath, String operator, boolean exists, int button) throws StepExecutionException {
        Menu popup = PopupMenuUtil.showPopup((Widget)this.getComponent(), this.getRobot(), button);
        this.popupVerifyExistsByTextPath(textPath, operator, popup, exists);
    }

    public void gdPopupVerifyExistsByTextPath(int xPos, String xUnits, int yPos, String yUnits, String textPath, String operator, boolean exists, int button) throws StepExecutionException {
        Menu popup = PopupMenuUtil.showPopup((Widget)this.getComponent(), this.getRobot(), xPos, xUnits, yPos, yUnits, button);
        this.popupVerifyExistsByTextPath(textPath, operator, popup, exists);
    }

    public void gdPopupVerifySelectedByIndexPath(String indexPath, boolean selected, int button) throws StepExecutionException {
        Menu popup = PopupMenuUtil.showPopup((Widget)this.getComponent(), this.getRobot(), button);
        this.popupVerifySelectedByIndexPath(indexPath, popup, selected);
    }

    public void gdPopupVerifySelectedByIndexPath(int xPos, String xUnits, int yPos, String yUnits, String indexPath, boolean selected, int button) throws StepExecutionException {
        Menu popup = PopupMenuUtil.showPopup((Widget)this.getComponent(), this.getRobot(), xPos, xUnits, yPos, yUnits, button);
        this.popupVerifySelectedByIndexPath(indexPath, popup, selected);
    }

    public void gdPopupVerifySelectedByTextPath(String textPath, String operator, boolean selected, int button) throws StepExecutionException {
        Menu popup = PopupMenuUtil.showPopup((Widget)this.getComponent(), this.getRobot(), button);
        this.popupVerifySelectedByTextPath(textPath, operator, popup, selected);
    }

    public void gdPopupVerifySelectedByTextPath(int xPos, String xUnits, int yPos, String yUnits, String textPath, String operator, boolean selected, int button) throws StepExecutionException {
        Menu popup = PopupMenuUtil.showPopup((Widget)this.getComponent(), this.getRobot(), xPos, xUnits, yPos, yUnits, button);
        this.popupVerifySelectedByTextPath(textPath, operator, popup, selected);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void popupVerifyEnabledByIndexPath(String indexPath, Menu popup, boolean enabled) {
        int[] indexItems = MenuUtil.splitIndexPath(indexPath);
        try {
            MenuItem menuItem = MenuUtil.navigateToMenuItem(this.getRobot(), popup, indexItems);
            if (menuItem == null) {
                throw new StepExecutionException("no such menu item found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
            }
            boolean isEnabled = MenuUtil.isMenuItemEnabled(menuItem);
            Verifier.equals((boolean)enabled, (boolean)isEnabled);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                int pathLength = indexItems != null ? indexItems.length : 0;
                PopupMenuUtil.closePopup(this.getRobot(), popup, pathLength);
                throw throwable;
            }
            catch (StepExecutionException stepExecutionException) {}
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        try {}
        catch (StepExecutionException stepExecutionException) {
            return;
        }
        int pathLength = indexItems != null ? indexItems.length : 0;
        PopupMenuUtil.closePopup(this.getRobot(), popup, pathLength);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void popupVerifyEnabledByTextPath(String textPath, String operator, Menu popup, boolean enabled) throws StepExecutionException {
        String[] pathItems = MenuUtil.splitPath(textPath);
        try {
            MenuItem menuItem = MenuUtil.navigateToMenuItem(this.getRobot(), popup, pathItems, operator);
            if (menuItem == null) {
                throw new StepExecutionException("no such menu item found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
            }
            boolean isEnabled = MenuUtil.isMenuItemEnabled(menuItem);
            Verifier.equals((boolean)enabled, (boolean)isEnabled);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                int pathLength = pathItems != null ? pathItems.length : 0;
                PopupMenuUtil.closePopup(this.getRobot(), popup, pathLength);
                throw throwable;
            }
            catch (StepExecutionException stepExecutionException) {}
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        try {}
        catch (StepExecutionException stepExecutionException) {
            return;
        }
        int pathLength = pathItems != null ? pathItems.length : 0;
        PopupMenuUtil.closePopup(this.getRobot(), popup, pathLength);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void popupVerifyExistsByIndexPath(String indexPath, Menu popup, boolean exists) {
        int[] indexItems = MenuUtil.splitIndexPath(indexPath);
        boolean isExisting = false;
        Menu menu = popup;
        try {
            MenuItem menuItem = MenuUtil.navigateToMenuItem(this.getRobot(), menu, indexItems);
            if (menuItem != null) {
                isExisting = true;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                int pathLength = indexItems != null ? indexItems.length : 0;
                PopupMenuUtil.closePopup(this.getRobot(), popup, pathLength);
                throw throwable;
            }
            catch (StepExecutionException stepExecutionException) {}
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        try {}
        catch (StepExecutionException stepExecutionException) {}
        int pathLength = indexItems != null ? indexItems.length : 0;
        PopupMenuUtil.closePopup(this.getRobot(), popup, pathLength);
        Verifier.equals((boolean)exists, (boolean)isExisting);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void popupVerifyExistsByTextPath(String textPath, String operator, Menu popup, boolean exists) throws StepExecutionException {
        String[] pathItems = MenuUtil.splitPath(textPath);
        boolean isExisting = false;
        try {
            MenuItem menuItem = MenuUtil.navigateToMenuItem(this.getRobot(), popup, pathItems, operator);
            if (menuItem != null) {
                isExisting = true;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                int pathLength = pathItems != null ? pathItems.length : 0;
                PopupMenuUtil.closePopup(this.getRobot(), popup, pathLength);
                throw throwable;
            }
            catch (StepExecutionException stepExecutionException) {}
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        try {}
        catch (StepExecutionException stepExecutionException) {}
        int pathLength = pathItems != null ? pathItems.length : 0;
        PopupMenuUtil.closePopup(this.getRobot(), popup, pathLength);
        Verifier.equals((boolean)exists, (boolean)isExisting);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void popupVerifySelectedByIndexPath(String indexPath, Menu popup, boolean selected) throws StepExecutionException {
        int[] indexItems = MenuUtil.splitIndexPath(indexPath);
        try {
            MenuItem menuItem = MenuUtil.navigateToMenuItem(this.getRobot(), popup, indexItems);
            if (menuItem == null) {
                throw new StepExecutionException("no such menu item found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
            }
            boolean isSelected = MenuUtil.isMenuItemSelected(menuItem);
            Verifier.equals((boolean)selected, (boolean)isSelected);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                int pathLength = indexItems != null ? indexItems.length : 0;
                PopupMenuUtil.closePopup(this.getRobot(), popup, pathLength);
                throw throwable;
            }
            catch (StepExecutionException stepExecutionException) {}
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        try {}
        catch (StepExecutionException stepExecutionException) {
            return;
        }
        int pathLength = indexItems != null ? indexItems.length : 0;
        PopupMenuUtil.closePopup(this.getRobot(), popup, pathLength);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void popupVerifySelectedByTextPath(String textPath, String operator, Menu popup, boolean selected) throws StepExecutionException {
        String[] pathItems = MenuUtil.splitPath(textPath);
        try {
            MenuItem menuItem = MenuUtil.navigateToMenuItem(this.getRobot(), popup, pathItems, operator);
            if (menuItem == null) {
                throw new StepExecutionException("no such menu item found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
            }
            boolean isSelected = MenuUtil.isMenuItemSelected(menuItem);
            Verifier.equals((boolean)selected, (boolean)isSelected);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                int pathLength = pathItems != null ? pathItems.length : 0;
                PopupMenuUtil.closePopup(this.getRobot(), popup, pathLength);
                throw throwable;
            }
            catch (StepExecutionException stepExecutionException) {}
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        try {}
        catch (StepExecutionException stepExecutionException) {
            return;
        }
        int pathLength = pathItems != null ? pathItems.length : 0;
        PopupMenuUtil.closePopup(this.getRobot(), popup, pathLength);
    }

    public void gdShowText(final String text, final int textSize, final int timePerWord, final int windowWidth) {
        final Rectangle bounds = (Rectangle)this.getEventThreadQueuer().invokeAndWait("gdShowText.getBounds", new IRunnable(){

            public Object run() {
                return SwtUtils.getWidgetBounds((Widget)AbstractControlImplClass.this.getComponent());
            }
        });
        SimulatedTooltip sp = (SimulatedTooltip)this.getEventThreadQueuer().invokeAndWait("gdShowText.initToolTip", new IRunnable(){

            public Object run() throws StepExecutionException {
                return new SimulatedTooltip(timePerWord, text, windowWidth, textSize, bounds);
            }
        });
        sp.start();
        try {
            sp.join();
        }
        catch (InterruptedException e) {
            throw new StepExecutionException((Throwable)e);
        }
    }

    public void gdDrag(int mouseButton, String modifier, int xPos, String xUnits, int yPos, String yUnits) {
        DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setModifier(modifier);
        dndHelper.setDragComponent(null);
        this.gdClickDirect(0, mouseButton, xPos, xUnits, yPos, yUnits);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gdDrop(final int xPos, final String xUnits, final int yPos, final String yUnits, int delayBeforeDrop) {
        final DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        final IRobot robot = this.getRobot();
        String modifier = dndHelper.getModifier();
        final int mouseButton = dndHelper.getMouseButton();
        try {
            this.pressOrReleaseModifiers(modifier, true);
            this.getEventThreadQueuer().invokeAndWait("gdStartDrag", new IRunnable(){

                public Object run() throws StepExecutionException {
                    robot.mousePress((Object)dndHelper.getDragComponent(), null, mouseButton);
                    AbstractControlImplClass.this.shakeMouse();
                    AbstractControlImplClass.this.gdClickDirect(0, mouseButton, xPos, xUnits, yPos, yUnits);
                    return null;
                }
            });
            AbstractControlImplClass.waitBeforeDrop(delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.getRobot().mouseRelease(null, null, mouseButton);
            this.pressOrReleaseModifiers(modifier, false);
            throw throwable;
        }
        {
            Object var10_12 = null;
        }
        this.getRobot().mouseRelease(null, null, mouseButton);
        this.pressOrReleaseModifiers(modifier, false);
    }

    protected void shakeMouse() {
        Point p = this.getRobot().getCurrentMousePosition();
        SwtRobot lowLevelRobot = new SwtRobot(Display.getDefault());
        lowLevelRobot.mouseMove(p.x + 10, p.y + 10);
        lowLevelRobot.mouseMove(p.x - 10, p.y - 10);
        lowLevelRobot.mouseMove(p.x, p.y);
        if (!EnvironmentUtils.isWindowsOS()) {
            boolean moreEvents = true;
            while (moreEvents) {
                moreEvents = Display.getDefault().readAndDispatch();
            }
        }
    }

    protected ClickOptions.ClickModifier getClickModifier(String extendSelection) {
        ClickOptions.ClickModifier cm = ClickOptions.ClickModifier.create();
        if ("yes".equalsIgnoreCase(extendSelection)) {
            cm.add(1);
        }
        return cm;
    }
}

