/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.implclasses;

import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.driver.RobotTiming;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.listener.EventLock;
import org.eclipse.jubula.rc.swt.driver.EventThreadQueuerSwtImpl;
import org.eclipse.jubula.rc.swt.implclasses.EventListener;
import org.eclipse.jubula.rc.swt.implclasses.MenuUtil;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.jubula.tools.utils.EnvironmentUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class PopupMenuUtil {
    private PopupMenuUtil() {
    }

    public static Menu showPopup(final Widget component, final IRobot robot, final int button) {
        if (SwtUtils.isMouseCursorInWidget(component)) {
            return PopupMenuUtil.showPopup(component, new Runnable(){

                public void run() {
                    RobotTiming.sleepPreShowPopupDelay();
                    robot.clickAtCurrentPosition((Object)component, 1, button);
                }
            });
        }
        return PopupMenuUtil.showPopup(component, robot, 50, "Percent", 50, "Percent", button);
    }

    public static Menu showPopup(final Widget component, final IRobot robot, final int xPos, final String xUnits, final int yPos, final String yUnits, final int button) throws StepExecutionException {
        return PopupMenuUtil.showPopup(component, new Runnable(){

            public void run() {
                RobotTiming.sleepPreShowPopupDelay();
                boolean isAbsoluteUnitsX = "Pixel".equalsIgnoreCase(xUnits);
                boolean isAbsoluteUnitsY = "Pixel".equalsIgnoreCase(yUnits);
                robot.click((Object)component, null, ClickOptions.create().setClickCount(1).setMouseButton(button), xPos, isAbsoluteUnitsX, yPos, isAbsoluteUnitsY);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Menu showPopup(Widget component, Runnable showPopup) throws StepExecutionException {
        PopupShownCondition cond = new PopupShownCondition();
        EventLock lock = new EventLock();
        final EventListener listener = new EventListener(lock, cond);
        final Display d = component.getDisplay();
        EventThreadQueuerSwtImpl queuer = new EventThreadQueuerSwtImpl();
        queuer.invokeAndWait("addPopupShownListeners", new IRunnable(){

            public Object run() {
                d.addFilter(22, (Listener)listener);
                return null;
            }
        });
        try {
            try {
                showPopup.run();
                EventLock eventLock = lock;
                synchronized (eventLock) {
                    long timeout = 10000L;
                    long done = System.currentTimeMillis() + timeout;
                    while (true) {
                        block10: {
                            if (!lock.isReleased() && timeout > 0L) break block10;
                            break;
                        }
                        lock.wait(timeout);
                        long now = System.currentTimeMillis();
                        timeout = done - now;
                    }
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Throwable throwable) {
            Object var14_12 = null;
            queuer.invokeAndWait("removePopupShownListeners", new IRunnable(d, listener){
                private final /* synthetic */ Display val$d;
                private final /* synthetic */ EventListener val$listener;
                {
                    this.val$d = display;
                    this.val$listener = eventListener;
                }

                public Object run() {
                    this.val$d.removeFilter(22, (Listener)this.val$listener);
                    return null;
                }
            });
            throw throwable;
        }
        {
            Object var14_13 = null;
        }
        queuer.invokeAndWait("removePopupShownListeners", new /* invalid duplicate definition of identical inner class */);
        if (!lock.isReleased()) {
            throw new StepExecutionException("popup not shown", EventFactory.createActionError((String)"TestErrorEvent.PopupNotFound"));
        }
        return cond.getPopup();
    }

    public static void selectMenuItem(IRobot robot, Menu popup, int[] path) {
        if (path.length == 0) {
            throw new StepExecutionException("empty path to menuitem not allowed", EventFactory.createActionError());
        }
        MenuItem item = MenuUtil.navigateToMenuItem(robot, popup, path);
        PopupMenuUtil.selectItem(item, robot);
    }

    public static void selectMenuItem(IRobot robot, Menu popup, String[] path, String operator) {
        if (path.length == 0) {
            throw new StepExecutionException("empty path to menuitem not allowed", EventFactory.createActionError());
        }
        MenuItem item = MenuUtil.navigateToMenuItem(robot, popup, path, operator);
        PopupMenuUtil.selectItem(item, robot);
    }

    private static void selectItem(MenuItem item, IRobot robot) {
        if (item == null) {
            throw new StepExecutionException("no such menu item found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        if (EnvironmentUtils.isMacOS()) {
            MenuUtil.selectProgramatically(item);
            robot.keyType(null, 27);
        } else {
            MenuUtil.clickMenuItem(robot, item, 1);
        }
    }

    public static void closePopup(IRobot robot, Menu popup, int pathLength) {
        int i = 0;
        while (i < pathLength && popup != null && MenuUtil.isMenuVisible(popup)) {
            robot.keyType((Object)popup, 27);
            RobotTiming.sleepPostMouseUpDelay();
            ++i;
        }
    }

    private static class PopupShownCondition
    implements EventListener.Condition {
        private Menu m_popup = null;

        private PopupShownCondition() {
        }

        public Menu getPopup() {
            return this.m_popup;
        }

        public boolean isTrue(Event event) {
            if (event.type == 22 && event.widget instanceof Menu) {
                this.m_popup = (Menu)event.widget;
                return true;
            }
            return false;
        }
    }
}

