/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ddf;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ddf.EscherBSERecord;
import org.apache.poi.ddf.EscherBitmapBlip;
import org.apache.poi.ddf.EscherBlipRecord;
import org.apache.poi.ddf.EscherChildAnchorRecord;
import org.apache.poi.ddf.EscherClientAnchorRecord;
import org.apache.poi.ddf.EscherClientDataRecord;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherDgRecord;
import org.apache.poi.ddf.EscherDggRecord;
import org.apache.poi.ddf.EscherMetafileBlip;
import org.apache.poi.ddf.EscherOptRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherRecordFactory;
import org.apache.poi.ddf.EscherSpRecord;
import org.apache.poi.ddf.EscherSpgrRecord;
import org.apache.poi.ddf.EscherSplitMenuColorsRecord;
import org.apache.poi.ddf.EscherTextboxRecord;
import org.apache.poi.ddf.UnknownEscherRecord;
import org.apache.poi.hssf.record.RecordFormatException;

public class DefaultEscherRecordFactory
implements EscherRecordFactory {
    private static Class[] escherRecordClasses = new Class[]{EscherBSERecord.class, EscherOptRecord.class, EscherClientAnchorRecord.class, EscherDgRecord.class, EscherSpgrRecord.class, EscherSpRecord.class, EscherClientDataRecord.class, EscherDggRecord.class, EscherSplitMenuColorsRecord.class, EscherChildAnchorRecord.class, EscherTextboxRecord.class};
    private static Map recordsMap = DefaultEscherRecordFactory.recordsToMap(escherRecordClasses);

    public EscherRecord createRecord(byte[] data, int offset) {
        EscherRecord.EscherRecordHeader header = EscherRecord.EscherRecordHeader.readHeader(data, offset);
        if ((header.getOptions() & 0xF) == 15 && header.getRecordId() != -4083) {
            EscherContainerRecord r = new EscherContainerRecord();
            r.setRecordId(header.getRecordId());
            r.setOptions(header.getOptions());
            return r;
        }
        if (header.getRecordId() >= -4072 && header.getRecordId() <= -3817) {
            EscherBlipRecord r = header.getRecordId() == -4065 || header.getRecordId() == -4067 || header.getRecordId() == -4066 ? new EscherBitmapBlip() : (header.getRecordId() == -4070 || header.getRecordId() == -4069 || header.getRecordId() == -4068 ? new EscherMetafileBlip() : new EscherBlipRecord());
            r.setRecordId(header.getRecordId());
            r.setOptions(header.getOptions());
            return r;
        }
        Constructor recordConstructor = (Constructor)recordsMap.get(new Short(header.getRecordId()));
        EscherRecord escherRecord = null;
        if (recordConstructor != null) {
            try {
                escherRecord = (EscherRecord)recordConstructor.newInstance(new Object[0]);
                escherRecord.setRecordId(header.getRecordId());
                escherRecord.setOptions(header.getOptions());
            }
            catch (Exception exception) {
                escherRecord = null;
            }
        }
        return escherRecord == null ? new UnknownEscherRecord() : escherRecord;
    }

    private static Map recordsToMap(Class[] records) {
        HashMap result = new HashMap();
        int i = 0;
        while (i < records.length) {
            Constructor constructor;
            Class record = null;
            short sid = 0;
            record = records[i];
            try {
                sid = record.getField("RECORD_ID").getShort(null);
                constructor = record.getConstructor(new Class[0]);
            }
            catch (Exception exception) {
                throw new RecordFormatException("Unable to determine record types");
            }
            result.put(new Short(sid), constructor);
            ++i;
        }
        return result;
    }
}

