/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

public final class BoundSheetRecord
extends Record {
    public static final short sid = 133;
    private static final BitField hiddenFlag = BitFieldFactory.getInstance(1);
    private static final BitField veryHiddenFlag = BitFieldFactory.getInstance(2);
    private int field_1_position_of_BOF;
    private int field_2_option_flags;
    private int field_4_isMultibyteUnicode;
    private String field_5_sheetname;
    private static final Comparator BOFComparator = new Comparator(){

        public int compare(Object bsr1, Object bsr2) {
            return this.compare((BoundSheetRecord)bsr1, (BoundSheetRecord)bsr2);
        }

        public int compare(BoundSheetRecord bsr1, BoundSheetRecord bsr2) {
            return bsr1.getPositionOfBof() - bsr2.getPositionOfBof();
        }
    };

    public BoundSheetRecord(String sheetname) {
        this.field_2_option_flags = 0;
        this.setSheetname(sheetname);
    }

    public BoundSheetRecord(RecordInputStream in) {
        this.field_1_position_of_BOF = in.readInt();
        this.field_2_option_flags = in.readUShort();
        short field_3_sheetname_length = in.readUByte();
        this.field_4_isMultibyteUnicode = in.readByte();
        this.field_5_sheetname = this.isMultibyte() ? in.readUnicodeLEString(field_3_sheetname_length) : in.readCompressedUnicode(field_3_sheetname_length);
    }

    public void setPositionOfBof(int pos) {
        this.field_1_position_of_BOF = pos;
    }

    public void setSheetname(String sheetName) {
        BoundSheetRecord.validateSheetName(sheetName);
        this.field_5_sheetname = sheetName;
        this.field_4_isMultibyteUnicode = StringUtil.hasMultibyte(sheetName) ? 1 : 0;
    }

    private static void validateSheetName(String sheetName) {
        if (sheetName == null) {
            throw new IllegalArgumentException("sheetName must not be null");
        }
        int len = sheetName.length();
        if (len < 1) {
            throw new IllegalArgumentException("sheetName must not be empty string");
        }
        int i = 0;
        while (i < len) {
            block6: {
                char ch = sheetName.charAt(i);
                switch (ch) {
                    case '*': 
                    case '/': 
                    case '?': 
                    case '[': 
                    case '\\': 
                    case ']': {
                        break;
                    }
                    default: {
                        break block6;
                    }
                }
                throw new IllegalArgumentException("Invalid char (" + ch + ") found at index (" + i + ") in sheet name '" + sheetName + "'");
            }
            ++i;
        }
    }

    public int getPositionOfBof() {
        return this.field_1_position_of_BOF;
    }

    private boolean isMultibyte() {
        return (this.field_4_isMultibyteUnicode & 1) != 0;
    }

    public String getSheetname() {
        return this.field_5_sheetname;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[BOUNDSHEET]\n");
        buffer.append("    .bof        = ").append(HexDump.intToHex(this.getPositionOfBof())).append("\n");
        buffer.append("    .options    = ").append(HexDump.shortToHex(this.field_2_option_flags)).append("\n");
        buffer.append("    .unicodeflag= ").append(HexDump.byteToHex(this.field_4_isMultibyteUnicode)).append("\n");
        buffer.append("    .sheetname  = ").append(this.field_5_sheetname).append("\n");
        buffer.append("[/BOUNDSHEET]\n");
        return buffer.toString();
    }

    private int getDataSize() {
        return 8 + this.field_5_sheetname.length() * (this.isMultibyte() ? 2 : 1);
    }

    public int serialize(int offset, byte[] data) {
        int dataSize = this.getDataSize();
        LittleEndian.putUShort(data, 0 + offset, 133);
        LittleEndian.putUShort(data, 2 + offset, dataSize);
        LittleEndian.putInt(data, 4 + offset, this.getPositionOfBof());
        LittleEndian.putUShort(data, 8 + offset, this.field_2_option_flags);
        String name = this.field_5_sheetname;
        LittleEndian.putByte(data, 10 + offset, name.length());
        LittleEndian.putByte(data, 11 + offset, this.field_4_isMultibyteUnicode);
        if (this.isMultibyte()) {
            StringUtil.putUnicodeLE(name, data, 12 + offset);
        } else {
            StringUtil.putCompressedUnicode(name, data, 12 + offset);
        }
        return 4 + dataSize;
    }

    public int getRecordSize() {
        return 4 + this.getDataSize();
    }

    public short getSid() {
        return 133;
    }

    public boolean isHidden() {
        return hiddenFlag.isSet(this.field_2_option_flags);
    }

    public void setHidden(boolean hidden) {
        this.field_2_option_flags = hiddenFlag.setBoolean(this.field_2_option_flags, hidden);
    }

    public boolean isVeryHidden() {
        return veryHiddenFlag.isSet(this.field_2_option_flags);
    }

    public void setVeryHidden(boolean veryHidden) {
        this.field_2_option_flags = veryHiddenFlag.setBoolean(this.field_2_option_flags, veryHidden);
    }

    public static BoundSheetRecord[] orderByBofPosition(List boundSheetRecords) {
        BoundSheetRecord[] bsrs = new BoundSheetRecord[boundSheetRecords.size()];
        boundSheetRecords.toArray(bsrs);
        Arrays.sort(bsrs, BOFComparator);
        return bsrs;
    }
}

