/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.app.dbtool.core;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jubula.app.dbtool.i18n.Messages;
import org.eclipse.jubula.client.archive.businessprocess.FileStorageBP;
import org.eclipse.jubula.client.cmd.AbstractCmdlineClient;
import org.eclipse.jubula.client.core.businessprocess.JobConfiguration;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.DatabaseConnectionInfo;
import org.eclipse.jubula.client.core.persistence.Hibernator;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.core.persistence.TestResultPM;
import org.eclipse.jubula.client.core.persistence.TestResultSummaryPM;
import org.eclipse.jubula.client.core.progress.IProgressConsole;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;

public class DBToolClient
extends AbstractCmdlineClient {
    private static final String OPTION_DELETE = "delete";
    private static final String OPTION_DELETE_ALL = "deleteall";
    private static final String OPTION_KEEPSUMMARY_ON_DELETE = "keepsummary";
    private static final String PAR_PROJECT = "project-name project-version";
    private static final String OPTION_EXPORT_ALL = "exportall";
    private static final String OPTION_EXPORT = "export";
    private static final String OPTION_DIR = "directory";
    private static final String PAR_DIR = "directory path";
    private static final String OPTION_IMPORT = "import";
    private static final String PAR_IMPORT = "import file";
    private static DBToolClient instance;

    private DBToolClient() {
    }

    public static DBToolClient getInstance() {
        if (instance == null) {
            instance = new DBToolClient();
        }
        return instance;
    }

    protected void extendOptions(Options opt, boolean req) {
        Option delOption = DBToolClient.createOption((String)OPTION_DELETE, (boolean)true, (String)PAR_PROJECT, (String)Messages.DBToolDelete, (boolean)false);
        delOption.setArgs(2);
        opt.addOption(delOption);
        opt.addOption(DBToolClient.createOption((String)OPTION_DELETE_ALL, (boolean)false, null, (String)Messages.DBToolDeleteAll, (boolean)false));
        opt.addOption(DBToolClient.createOption((String)OPTION_KEEPSUMMARY_ON_DELETE, (boolean)false, null, (String)Messages.DBToolDeleteKeepSummary, (boolean)false));
        opt.addOption(DBToolClient.createOption((String)OPTION_DIR, (boolean)true, (String)PAR_DIR, (String)Messages.DBToolDir, (boolean)false));
        opt.addOption(DBToolClient.createOption((String)OPTION_EXPORT_ALL, (boolean)false, null, (String)Messages.DBToolExportAll, (boolean)false));
        Option exportOption = DBToolClient.createOption((String)OPTION_EXPORT, (boolean)true, (String)PAR_PROJECT, (String)Messages.DBToolExport, (boolean)false);
        exportOption.setArgs(2);
        opt.addOption(exportOption);
        opt.addOption(DBToolClient.createOption((String)OPTION_IMPORT, (boolean)true, (String)PAR_IMPORT, (String)Messages.DBToolImport, (boolean)false));
    }

    protected void extendValidate(JobConfiguration job, StringBuilder errorMsgs) {
        String[] args = this.getCmdLine().getOptionValues(OPTION_DELETE);
        if (args != null && args.length != 2) {
            this.appendError(errorMsgs, OPTION_DELETE, PAR_PROJECT);
        }
        if ((args = this.getCmdLine().getOptionValues(OPTION_EXPORT)) != null && args.length != 2) {
            this.appendError(errorMsgs, OPTION_EXPORT, PAR_PROJECT);
        }
    }

    protected void preRun() {
    }

    public int doRun() {
        String[] projValues;
        String[] projValues2;
        boolean keepSummariesOnDelete = false;
        this.setupDB();
        CommandLine cmdLine = this.getCmdLine();
        if (cmdLine.hasOption(OPTION_KEEPSUMMARY_ON_DELETE)) {
            keepSummariesOnDelete = true;
        }
        if (cmdLine.hasOption(OPTION_DELETE) && (projValues2 = cmdLine.getOptionValues(OPTION_DELETE)) != null && projValues2.length == 2) {
            this.deleteProject(projValues2[0], projValues2[1], keepSummariesOnDelete);
        }
        if (cmdLine.hasOption(OPTION_DELETE_ALL)) {
            this.deleteAllProjects(keepSummariesOnDelete);
        }
        String exportDir = cmdLine.getOptionValue(OPTION_DIR, ".");
        if (cmdLine.hasOption(OPTION_EXPORT) && (projValues = cmdLine.getOptionValues(OPTION_EXPORT)) != null && projValues.length == 2) {
            this.exportProject(projValues[0], projValues[1], exportDir);
        }
        if (cmdLine.hasOption(OPTION_EXPORT_ALL)) {
            this.exportAll(exportDir);
        }
        if (cmdLine.hasOption(OPTION_IMPORT)) {
            this.importProject(cmdLine.getOptionValue(OPTION_IMPORT), exportDir);
        }
        return 0;
    }

    private void importProject(String fileName, String exportDir) {
        File impFile = new File(fileName);
        if (!impFile.isAbsolute()) {
            impFile = new File(new File(exportDir), fileName);
        }
        try {
            ArrayList<URL> fileURLs = new ArrayList<URL>(1);
            fileURLs.add(impFile.toURI().toURL());
            FileStorageBP.importFiles(fileURLs, (IProgressMonitor)new NullProgressMonitor(), (IProgressConsole)this, (boolean)false);
        }
        catch (PMException pme) {
            this.writeErrorLine(pme.getLocalizedMessage());
        }
        catch (ProjectDeletedException gdpde) {
            this.writeErrorLine(gdpde.getLocalizedMessage());
        }
        catch (MalformedURLException e) {
            this.writeErrorLine(e.getLocalizedMessage());
        }
    }

    private void exportProject(String name, String version, String exportDir) {
        int[] versionNrs = this.buildVersionNrs(name, version);
        if (versionNrs != null) {
            File export = new File(exportDir);
            if (!export.isDirectory() || !export.canWrite()) {
                this.reportBadDirectory(exportDir);
                return;
            }
            String dirName = String.valueOf(export.getAbsolutePath()) + File.separator;
            EntityManager session = Hibernator.instance().openSession();
            try {
                List projects = ProjectPM.findAllProjects((EntityManager)session);
                ArrayList<IProjectPO> exportProjects = new ArrayList<IProjectPO>(1);
                for (IProjectPO project : projects) {
                    if (!project.getName().equals(name) || !project.getMajorProjectVersion().equals(new Integer(versionNrs[0])) || !project.getMinorProjectVersion().equals(new Integer(versionNrs[1]))) continue;
                    exportProjects.add(project);
                }
                if (exportProjects.size() == 0) {
                    this.reportMissingProject(name, version);
                    return;
                }
                try {
                    ArrayList listOfProjectFiles = new ArrayList(exportProjects.size());
                    FileStorageBP.exportProjectList(exportProjects, (String)dirName, (EntityManager)session, (IProgressMonitor)new NullProgressMonitor(), (boolean)false, listOfProjectFiles, (IProgressConsole)this);
                }
                catch (JBException e) {
                    this.reportExportAllFailed(exportDir, e);
                }
                catch (InterruptedException interruptedException) {}
            }
            finally {
                Hibernator.instance().dropSession(session);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void exportAll(String exportDir) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index: 0, Size: 0
         *     at java.base/java.util.LinkedList.checkElementIndex(LinkedList.java:566)
         *     at java.base/java.util.LinkedList.get(LinkedList.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.combineInlineable(Block.java:226)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:560)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredCatch.transformStructuredChildren(StructuredCatch.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.transformStructuredChildren(StructuredTry.java:129)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.transformStructuredChildren(StructuredTry.java:127)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.inlinePossibles(Op04StructuredStatement.java:709)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:855)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void deleteProject(String name, String version, boolean keepSummaryOnDelete) {
        int[] versionNr = this.buildVersionNrs(name, version);
        if (versionNr != null) {
            IProjectPO project;
            try {
                project = ProjectPM.loadProjectByNameAndVersion((String)name, (int)versionNr[0], (int)versionNr[1]);
            }
            catch (JBException jBException) {
                this.reportMissingProject(name, version);
                return;
            }
            if (project == null) {
                this.reportMissingProject(name, version);
            } else {
                try {
                    ProjectPM.deleteProject((IProjectPO)project, (boolean)false);
                    if (keepSummaryOnDelete) {
                        TestResultSummaryPM.deleteTestrunsByProject((String)project.getGuid(), (int)project.getMajorProjectVersion(), (int)project.getMinorProjectVersion(), (boolean)true);
                    } else {
                        TestResultSummaryPM.deleteTestrunsByProject((String)project.getGuid(), (int)project.getMajorProjectVersion(), (int)project.getMinorProjectVersion(), (boolean)false);
                    }
                }
                catch (JBException e) {
                    this.reportDeleteFailed(name, version, (Exception)((Object)e));
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private void deleteAllProjects(boolean keepSummaryOnDelete) {
        try {
            List projects = ProjectPM.findAllProjects();
            for (IProjectPO proj : projects) {
                ProjectPM.deleteProject((IProjectPO)proj, (boolean)false);
            }
            if (keepSummaryOnDelete) {
                TestResultPM.deleteAllTestresultDetails();
            } else {
                TestResultSummaryPM.deleteAllTestresultSummaries();
                TestResultPM.deleteAllTestresultDetails();
            }
        }
        catch (JBException e) {
            DBToolClient.printlnConsoleError((String)e.getMessage());
        }
        catch (InterruptedException interruptedException) {}
    }

    private int[] buildVersionNrs(String name, String version) {
        int sepPos = version.indexOf(46);
        if (sepPos == -1 || sepPos == 0) {
            this.reportBadVersion(name, version);
            return null;
        }
        String majorStr = version.substring(0, sepPos);
        String minorStr = version.substring(sepPos + 1);
        int[] versionNr = new int[2];
        try {
            versionNr[0] = Integer.parseInt(majorStr);
            versionNr[1] = Integer.parseInt(minorStr);
        }
        catch (NumberFormatException numberFormatException) {
            this.reportBadVersion(name, version);
            return null;
        }
        return versionNr;
    }

    private void reportDeleteFailed(String name, String version, Exception e) {
        StringBuilder msg = new StringBuilder(Messages.DBToolDeleteFailed);
        msg.append(" ");
        msg.append(name);
        msg.append(" [");
        msg.append(version);
        msg.append("]");
        msg.append("\n");
        msg.append(e.getLocalizedMessage());
        DBToolClient.printlnConsoleError((String)msg.toString());
    }

    private void reportBadVersion(String name, String version) {
        StringBuilder msg = new StringBuilder(Messages.DBToolInvalidVersion);
        msg.append(" ");
        msg.append(name);
        msg.append(" [");
        msg.append(version);
        msg.append("]");
        DBToolClient.printlnConsoleError((String)msg.toString());
    }

    private void reportMissingProject(String name, String version) {
        StringBuilder msg = new StringBuilder(Messages.DBToolMissingProject);
        msg.append(" ");
        msg.append(name);
        msg.append(" [");
        msg.append(version);
        msg.append("]");
        DBToolClient.printlnConsoleError((String)msg.toString());
    }

    private void reportBadDirectory(String dirName) {
        StringBuilder msg = new StringBuilder(Messages.DBToolInvalidExportDirectory);
        msg.append(" ");
        msg.append(dirName);
        DBToolClient.printlnConsoleError((String)msg.toString());
    }

    private void reportNonEmptyDirectory(String dirName) {
        StringBuilder msg = new StringBuilder(Messages.DBToolNonEmptyExportDirectory);
        msg.append(" ");
        msg.append(dirName);
        DBToolClient.printlnConsoleError((String)msg.toString());
    }

    private void reportExportAllFailed(String exportDir, JBException e) {
        StringBuilder msg = new StringBuilder(Messages.DBToolExportAllFailed);
        msg.append(" ");
        msg.append(exportDir);
        msg.append("\n");
        msg.append(e.getLocalizedMessage());
        DBToolClient.printlnConsoleError((String)msg.toString());
    }

    private void setupDB() {
        Hibernator.setDbConnectionName((DatabaseConnectionInfo)this.getJob().getDbscheme());
        Hibernator.setUser((String)this.getJob().getDbuser());
        Hibernator.setPw((String)this.getJob().getDbpw());
        Hibernator.setUrl((String)this.getJob().getDb());
        Hibernator.setHeadless((boolean)true);
        if (!Hibernator.init()) {
            throw new IllegalArgumentException(Messages.ExecutionControllerInvalidDBDataError, null);
        }
    }

    public String getCmdlineClientExecName() {
        return Messages.DBToolName;
    }
}

