/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.Date;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.ITestCasePO;
import org.eclipse.jubula.client.core.model.ITestResult;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.tools.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.i18n.I18n;

public abstract class AbstractXMLReportGenerator {
    private static final Log LOG = LogFactory.getLog(AbstractXMLReportGenerator.class);
    private Document m_document = DocumentHelper.createDocument();
    private ITestResult m_testResult;

    public AbstractXMLReportGenerator(ITestResult testResult) {
        this.m_testResult = testResult;
    }

    public abstract Document generateXmlReport();

    protected Element generateHeader() {
        Date endTime;
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Generating Result XML Report");
        }
        this.m_document.normalize();
        this.m_document.addComment("<?xml-stylesheet type=\"text/xsl\" href=\"format.xsl\"?>");
        Element root = this.m_document.addElement("report");
        root.addAttribute("style", this.getStyleName());
        Element general = root.addElement("project");
        StringBuilder nameSb = new StringBuilder(this.m_testResult.getProjectName());
        nameSb.append(" ").append(this.m_testResult.getProjectMajorVersion());
        nameSb.append(".").append(this.m_testResult.getProjectMinorVersion());
        general.addElement("name").addText(nameSb.toString());
        Date startTime = this.m_testResult.getStartTime();
        if (startTime != null) {
            general.addElement("test-start").addText(startTime.toString());
        }
        if ((endTime = this.m_testResult.getEndTime()) != null) {
            general.addElement("test-end").addText(endTime.toString());
        }
        if (startTime != null && endTime != null) {
            long minutes;
            long seconds;
            long timeInSeconds = endTime.getTime() - startTime.getTime();
            long hours = (timeInSeconds /= 1000L) / 3600L;
            timeInSeconds -= hours * 3600L;
            String secondsString = (seconds = (timeInSeconds -= (minutes = timeInSeconds / 60L) * 60L)) < 10L ? "0" + seconds : String.valueOf(seconds);
            String minutesString = minutes < 10L ? "0" + minutes : String.valueOf(minutes);
            String hoursString = hours < 10L ? "0" + hours : String.valueOf(hours);
            general.addElement("test-length").addText(String.valueOf(hoursString) + ":" + minutesString + ":" + secondsString);
        }
        this.addStepCountElements(this.m_testResult, general);
        general.addElement("language").addText(this.m_testResult.getTestLanguage());
        return general;
    }

    private void addStepCountElements(ITestResult result, Element general) {
        int expectedNumberOfSteps = result.getExpectedNumberOfSteps();
        int numberOfStepsExecuted = result.getNumberOfTestedSteps();
        int numberOfEventHandlerSteps = result.getNumberOfEventHandlerSteps();
        int numberOfFailedTestSteps = result.getNumberOfFailedSteps();
        general.addElement("expectedNumSteps").addText(String.valueOf(expectedNumberOfSteps));
        general.addElement("numStepsTested").addText(String.valueOf(numberOfStepsExecuted));
        general.addElement("numEventHandlerSteps").addText(String.valueOf(numberOfEventHandlerSteps));
        general.addElement("numFailedSteps").addText(String.valueOf(numberOfFailedTestSteps));
    }

    protected Element buildRootElement(Element parent) {
        return this.buildElement(parent, this.m_testResult.getRootResultNode());
    }

    protected Element buildElement(Element element, TestResultNode resultNode) {
        Element insertInto = element;
        INodePO node = resultNode.getNode();
        if (node instanceof ITestSuitePO) {
            Element suite;
            ITestSuitePO ts = (ITestSuitePO)node;
            insertInto = suite = element.addElement("testsuite");
            this.addGeneralElements(resultNode, insertInto);
            IAUTMainPO aut = ts.getAut();
            Element autEl = suite.addElement("aut");
            autEl.addElement("name").addText(aut.getName());
            autEl.addElement("config").addText(this.m_testResult.getAutConfigName());
            autEl.addElement("server").addText(this.m_testResult.getAutAgentHostName());
            autEl.addElement("cmdline-parameter").setText(this.m_testResult.getAutArguments());
            insertInto = suite.addElement("test-run");
        } else if (node instanceof IEventExecTestCasePO) {
            insertInto = element.addElement("eventhandler");
            this.addGeneralElements(resultNode, insertInto);
            Element typeEl = insertInto.addElement("type");
            typeEl.addText(I18n.getString((String)((IEventExecTestCasePO)node).getEventType()));
            Element reentryEl = insertInto.addElement("reentry-property");
            reentryEl.addText(((IEventExecTestCasePO)node).getReentryProp().toString());
        } else if (node instanceof ITestCasePO) {
            insertInto = element.addElement("testcase");
            this.addGeneralElements(resultNode, insertInto);
        } else if (node instanceof ICapPO) {
            insertInto = element.addElement("step");
            this.addGeneralElements(resultNode, insertInto);
            this.addCapElement(resultNode, insertInto, node);
        }
        return insertInto;
    }

    protected void addCapElement(TestResultNode resultNode, Element insertInto, Object node) {
        ICapPO cap = (ICapPO)node;
        this.getTimestampFromResultNode(resultNode, insertInto);
        Element compEl = insertInto.addElement("component-name");
        compEl.addText(StringUtils.defaultString((String)resultNode.getComponentName()));
        Element compTypeEl = insertInto.addElement("component-type");
        compTypeEl.addText(CompSystemI18n.getString((String)cap.getComponentType(), (boolean)true));
        Element actionEl = insertInto.addElement("action-type");
        actionEl.addText(CompSystemI18n.getString((String)cap.getActionName(), (boolean)true));
        int index = 0;
        for (IParamDescriptionPO param : cap.getParameterList()) {
            Element paramEl = insertInto.addElement("parameter");
            Element paramNameEl = paramEl.addElement("parameter-name");
            paramNameEl.addText(CompSystemI18n.getString((String)param.getUniqueId(), (boolean)true));
            Element paramTypeEl = paramEl.addElement("parameter-type");
            paramTypeEl.addText(CompSystemI18n.getString((String)param.getType(), (boolean)true));
            Element paramValueEl = paramEl.addElement("parameter-value");
            if (resultNode.getParamValues().size() >= index + 1) {
                String value = resultNode.getParamValues().get(index);
                if (value != null) {
                    if (value.length() == 0) {
                        paramValueEl.addText("''");
                    } else {
                        paramValueEl.addText(value);
                    }
                } else {
                    paramValueEl.addText("");
                }
            } else {
                paramValueEl.addText("");
            }
            ++index;
        }
        if (resultNode.getStatus() == 2 || resultNode.getStatus() == 7) {
            Element mapEntry;
            Element error = insertInto.addElement("error");
            Element errorType = error.addElement("type");
            errorType.addText(I18n.getString((String)resultNode.getEvent().getId(), (boolean)true));
            Set keys = resultNode.getEvent().getProps().keySet();
            if (resultNode.getEvent().getId().equals("TestErrorEvent.Action")) {
                String key = (String)resultNode.getEvent().getProps().get("guidancerErrorDescription");
                Object[] args = (Object[])resultNode.getEvent().getProps().get("guidancerErrorParameter");
                args = args != null ? args : new Object[]{};
                mapEntry = error.addElement("description");
                if (mapEntry != null && key != null) {
                    mapEntry.addText(resultNode.hasBackingNode() ? String.valueOf(I18n.getString((String)key, (Object[])args)) : key);
                }
            } else {
                for (String key : keys) {
                    mapEntry = error.addElement(key);
                    mapEntry.addText(String.valueOf(resultNode.getEvent().getProps().get(key)));
                }
            }
        }
    }

    private void getTimestampFromResultNode(TestResultNode resultNode, Element insertInto) {
        Element timestampEL = insertInto.addElement("timestamp");
        Date time = resultNode.getTimeStamp();
        if (time != null) {
            String timestamp = time.toString();
            timestampEL.addText(timestamp);
        } else {
            timestampEL.addText("");
        }
    }

    protected void addGeneralElements(TestResultNode resultNode, Element insertInto) {
        Element name = insertInto.addElement("name");
        INodePO resNode = resultNode.getNode();
        name.addText(resNode.getName());
        if (resNode.getComment() != null) {
            Element comment = insertInto.addElement("comment");
            comment.addText(resNode.getComment());
        }
        Element status = insertInto.addElement("status");
        status.addText(String.valueOf(resultNode.getStatus()));
    }

    protected Document getDocument() {
        return this.m_document;
    }

    protected abstract String getStyleName();
}

