/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.core.businessprocess.CompNameResult;
import org.eclipse.jubula.client.core.businessprocess.CompNamesBP;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IObjectMappingPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.LogicComponentNotManagedException;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.core.utils.TreeTraverser;
import org.eclipse.jubula.tools.objects.IComponentIdentifier;
import org.eclipse.jubula.tools.xml.businessmodell.Component;
import org.eclipse.jubula.tools.xml.businessmodell.ConcreteComponent;

public final class CompletenessGuard {
    private CompletenessGuard() {
    }

    public static void setCompFlagForTD(IParamNodePO node, Locale loc, boolean hasCompleteTD) {
        CompletenessGuard.updateTdMap(loc, hasCompleteTD, node);
    }

    private static void updateTdMap(Locale loc, boolean hasCompleteTD, IParamNodePO node) {
        node.setCompleteTdFlag(loc, hasCompleteTD);
        if (!hasCompleteTD) {
            node.setSumTdFlag(loc, hasCompleteTD);
        }
    }

    private static boolean checkTdFlags(INodePO node, Locale locale) {
        boolean sumTdFlag = true;
        if (node instanceof ICapPO) {
            sumTdFlag = ((IParamNodePO)node).getCompleteTdFlag(locale) && sumTdFlag;
        } else {
            if (node instanceof IExecTestCasePO) {
                IExecTestCasePO execTC = (IExecTestCasePO)node;
                if (execTC.getSpecTestCase() != null) {
                    for (IEventExecTestCasePO obj : execTC.getSpecTestCase().getAllEventEventExecTC()) {
                        IEventExecTestCasePO ev = obj;
                        boolean bl = sumTdFlag = CompletenessGuard.checkTdFlags(ev, locale) && sumTdFlag;
                    }
                    if (StringUtils.isEmpty((String)execTC.getDataFile())) {
                        if (execTC.getHasReferencedTD()) {
                            sumTdFlag = execTC.getSpecTestCase().getCompleteTdFlag(locale) && sumTdFlag;
                        } else {
                            boolean bl = sumTdFlag = execTC.getCompleteTdFlag(locale) && sumTdFlag;
                        }
                    }
                }
                if (execTC.getParentNode() instanceof ITestSuitePO && execTC.getParamReferencesIterator(locale).hasNext()) {
                    execTC.setCompleteTdFlag(locale, false);
                    execTC.setSumTdFlag(locale, false);
                    sumTdFlag = false;
                }
            }
            Iterator<INodePO> it = node.getNodeListIterator();
            while (it.hasNext()) {
                INodePO child = it.next();
                boolean bl = sumTdFlag = CompletenessGuard.checkTdFlags(child, locale) && sumTdFlag;
            }
            if (!node.isActive()) {
                sumTdFlag = true;
            }
            node.setSumTdFlag(locale, sumTdFlag);
        }
        return sumTdFlag;
    }

    public static void checkAll(Locale loc, INodePO root) {
        TreeTraverser traverser = new TreeTraverser(root);
        traverser.addOperation(new OMFlagsOperation());
        traverser.addOperation(new CompleteTdDataOperation(loc));
        traverser.addOperation(new CompleteSpecTcOperation());
        traverser.traverse(true);
        if (root instanceof ITestSuitePO) {
            CompletenessGuard.checkTdFlags(root, loc);
        } else {
            List<ITestSuitePO> tsList = GeneralStorage.getInstance().getProject().getTestSuiteCont().getTestSuiteList();
            for (ITestSuitePO ts : tsList) {
                CompletenessGuard.checkTdFlags(ts, loc);
            }
        }
    }

    public static void checkTD(Locale loc, INodePO root) {
        CompleteTdDataOperation tdOp = new CompleteTdDataOperation(loc);
        TreeTraverser traverser = new TreeTraverser(root, tdOp);
        traverser.traverse(true);
        if (root instanceof ITestSuitePO) {
            CompletenessGuard.checkTdFlags(root, loc);
        } else {
            List<ITestSuitePO> tsList = GeneralStorage.getInstance().getProject().getTestSuiteCont().getTestSuiteList();
            for (ITestSuitePO ts : tsList) {
                CompletenessGuard.checkTdFlags(ts, loc);
            }
        }
    }

    public static void checkOM(INodePO root) {
        OMFlagsOperation omOp = new OMFlagsOperation();
        TreeTraverser traverser = new TreeTraverser(root, omOp);
        traverser.traverse(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompleteSpecTcOperation
    implements ITreeNodeOperation<INodePO> {
        private CompleteSpecTcOperation() {
        }

        @Override
        public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            if (!node.isActive()) {
                node.setSumSpecTcFlag(true);
                if (node instanceof IExecTestCasePO) {
                    ((IExecTestCasePO)node).setCompleteSpecTcFlag(true);
                }
                return false;
            }
            if (node instanceof IExecTestCasePO) {
                IExecTestCasePO execTc = (IExecTestCasePO)node;
                boolean isMissingSpecTc = execTc.getSpecTestCase() == null;
                execTc.setSumSpecTcFlag(!isMissingSpecTc);
                execTc.setCompleteSpecTcFlag(!isMissingSpecTc);
            } else {
                node.setSumSpecTcFlag(true);
            }
            return !alreadyVisited;
        }

        @Override
        public void postOperate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            if (parent != null && parent.getSumSpecTcFlag()) {
                parent.setSumSpecTcFlag(node.getSumSpecTcFlag());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompleteTdDataOperation
    implements ITreeNodeOperation<INodePO> {
        private Locale m_locale;

        public CompleteTdDataOperation(Locale loc) {
            this.m_locale = loc;
        }

        @Override
        public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            if (node instanceof IParamNodePO) {
                IExecTestCasePO execTc;
                IParamNodePO paramNode = (IParamNodePO)node;
                if (node instanceof IExecTestCasePO && (execTc = (IExecTestCasePO)node).getHasReferencedTD()) {
                    paramNode = execTc.getSpecTestCase();
                }
                if (paramNode != null) {
                    boolean isComplete = paramNode.isTestDataComplete(this.m_locale);
                    if (!node.isActive() || !paramNode.isActive()) {
                        isComplete = true;
                    }
                    CompletenessGuard.setCompFlagForTD(paramNode, this.m_locale, isComplete);
                    if (!node.isActive() || !paramNode.isActive()) {
                        return false;
                    }
                }
            }
            return !alreadyVisited;
        }

        @Override
        public void postOperate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OMFlagsOperation
    implements ITreeNodeOperation<INodePO> {
        private final CompNamesBP m_compNamesBP = new CompNamesBP();
        private IAUTMainPO m_aut;
        private boolean m_sumOMFlag = true;

        private OMFlagsOperation() {
        }

        private boolean handleCap(ITreeTraverserContext<INodePO> ctx, ICapPO cap) {
            Component metaComponentType;
            if (!cap.isActive()) {
                cap.setCompleteOMFlag(this.m_aut, true);
                return true;
            }
            IObjectMappingPO objMap = this.m_aut.getObjMap();
            String compName = cap.getComponentName();
            IComponentNamePO compNamePo = ComponentNamesBP.getInstance().getCompNamePo(compName);
            if (compNamePo != null) {
                compName = compNamePo.getGuid();
            }
            if ((metaComponentType = cap.getMetaComponentType()) instanceof ConcreteComponent && ((ConcreteComponent)metaComponentType).hasDefaultMapping()) {
                cap.setCompleteOMFlag(this.m_aut, true);
                return true;
            }
            if (compName != null && objMap != null) {
                IComponentIdentifier id = null;
                CompNameResult result = this.m_compNamesBP.findCompName(ctx.getCurrentTreePath(), cap, cap.getComponentName(), ComponentNamesBP.getInstance());
                try {
                    id = objMap.getTechnicalName(result.getCompName());
                }
                catch (LogicComponentNotManagedException logicComponentNotManagedException) {}
                if (id == null) {
                    result.getResponsibleNode().setSumOMFlag(this.m_aut, false);
                    if (result.getResponsibleNode() == cap) {
                        cap.setCompleteOMFlag(this.m_aut, false);
                    }
                } else {
                    cap.setCompleteOMFlag(this.m_aut, true);
                }
            }
            return cap.getCompleteOMFlag(this.m_aut);
        }

        @Override
        public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            if (node instanceof ITestSuitePO) {
                ITestSuitePO ts = (ITestSuitePO)node;
                this.m_aut = ts.getAut();
            }
            if (this.m_aut != null && !(node instanceof ICapPO)) {
                node.setSumOMFlag(this.m_aut, true);
                if (!node.isActive()) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public void postOperate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            if (this.m_aut != null) {
                if (node instanceof ICapPO) {
                    this.m_sumOMFlag = this.handleCap(ctx, (ICapPO)node);
                    if (parent != null && !this.m_sumOMFlag) {
                        parent.setSumOMFlag(this.m_aut, this.m_sumOMFlag);
                    }
                } else {
                    this.m_sumOMFlag = node.getSumOMFlag(this.m_aut) && this.m_sumOMFlag;
                    node.setSumOMFlag(this.m_aut, this.m_sumOMFlag);
                    if (parent != null && !this.m_sumOMFlag) {
                        parent.setSumOMFlag(this.m_aut, this.m_sumOMFlag);
                    }
                }
            }
        }
    }
}

