/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.Enumeration;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jubula.client.core.Activator;
import org.eclipse.jubula.client.core.businessprocess.IXMLReportWriter;
import org.eclipse.jubula.client.core.businessprocess.TestResultBP;
import org.eclipse.jubula.client.core.i18n.Messages;

public class FileXMLReportWriter
implements IXMLReportWriter {
    public static final String FILE_EXTENSION_XML = ".xml";
    public static final String FILE_EXTENSION_HTML = ".htm";
    private static final String ENCODING = "UTF-8";
    private static final Log LOG = LogFactory.getLog(FileXMLReportWriter.class);
    private String m_file;

    public FileXMLReportWriter(String file) {
        this.m_file = file;
    }

    public void write(Document document) {
        OutputFormat xmlFormat = OutputFormat.createPrettyPrint();
        xmlFormat.setEncoding(ENCODING);
        OutputFormat htmlFormat = OutputFormat.createCompactFormat();
        htmlFormat.setEncoding(ENCODING);
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(String.valueOf(this.m_file) + FILE_EXTENSION_XML), ENCODING);
            XMLWriter fileWriter = new XMLWriter((Writer)writer, xmlFormat);
            fileWriter.write(document);
            fileWriter.close();
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)(String.valueOf(Messages.ErrorFileWriting) + "."), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)(String.valueOf(Messages.ErrorFileWriting) + "."), (Throwable)e);
        }
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            TestResultBP trbp = TestResultBP.getInstance();
            Transformer transformer = factory.newTransformer(new StreamSource(trbp.getXslFileURL().openStream()));
            DocumentSource source = new DocumentSource(document);
            DocumentResult result = new DocumentResult();
            transformer.transform((Source)source, (Result)result);
            Document transformedDoc = result.getDocument();
            File htmlFile = new File(String.valueOf(this.m_file) + FILE_EXTENSION_HTML);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), ENCODING);
            XMLWriter fileWriter = new XMLWriter((Writer)writer, htmlFormat);
            fileWriter.write(transformedDoc);
            fileWriter.close();
            this.copyAdditionalFiles(htmlFile.getParentFile());
        }
        catch (TransformerConfigurationException e1) {
            LOG.error((Object)(String.valueOf(Messages.ErrorFileWriting) + "."), (Throwable)e1);
        }
        catch (TransformerException e) {
            LOG.error((Object)(String.valueOf(Messages.ErrorFileWriting) + "."), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)(String.valueOf(Messages.ErrorFileWriting) + "."), (Throwable)e);
        }
    }

    private void copyAdditionalFiles(File additionalFilesDir) {
        File destDir = new File(additionalFilesDir, "html");
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        Enumeration entries = Activator.getDefault().getBundle().findEntries("resources/html", "*.*", false);
        while (entries.hasMoreElements()) {
            Object o = entries.nextElement();
            try {
                if (!(o instanceof URL)) continue;
                BufferedInputStream bis = null;
                FilterOutputStream bos = null;
                try {
                    int c;
                    URL u = (URL)o;
                    URL fu = FileLocator.toFileURL((URL)u);
                    InputStream is = fu.openStream();
                    bis = new BufferedInputStream(is);
                    String filePath = fu.getFile();
                    String fileName = filePath.substring(filePath.lastIndexOf("/"));
                    FileOutputStream os = new FileOutputStream(new File(destDir, fileName));
                    bos = new BufferedOutputStream(os);
                    while ((c = bis.read()) != -1) {
                        ((BufferedOutputStream)bos).write(c);
                    }
                }
                finally {
                    if (bis != null) {
                        bis.close();
                    }
                    if (bos != null) {
                        bos.close();
                    }
                }
            }
            catch (IOException e) {
                LOG.error((Object)e);
            }
        }
    }
}

