/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestDataPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.TDCell;
import org.eclipse.jubula.client.core.persistence.Hibernator;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.utils.ModelParamValueConverter;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.exception.TestCaseParamCheckException;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCaseParamCheckBP {
    private static final Log LOG = LogFactory.getLog(TestCaseParamCheckBP.class);

    public void check(IParamNodePO toCheck, List<String> refToCheck, Locale locale, IParamCheck check) throws TestCaseParamCheckException {
        CheckErrors errors = new CheckErrors();
        check.execute(toCheck, refToCheck, locale, errors);
        if (errors.hasErrors()) {
            throw new TestCaseParamCheckException(errors.buildErrorMessage(), MessageIDs.E_PARAMETER_ERROR);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AllNodesParamCheck
    extends ParamCheck {
        public AllNodesParamCheck(IParamCheck check) {
            super(check);
        }

        @Override
        public void execute(IParamNodePO node, List<String> ref, Locale locale, CheckErrors errors) {
            Iterator<TDCell> it = node.getParamReferencesIterator(locale);
            while (it.hasNext()) {
                List<String> references = it.next().getReferences(node, locale);
                this.getCheck().execute(node, references, locale, errors);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CapParamRefCheck
    extends ParamCheck {
        private boolean m_insertParamRef;
        private SpecTcParamRefCheck m_specTcParamRefCheck;

        public CapParamRefCheck(boolean insertParamRef) {
            super(new ExecTcHaveReferencedTDCheck());
            this.m_insertParamRef = insertParamRef;
            this.m_specTcParamRefCheck = new SpecTcParamRefCheck();
        }

        @Override
        public void execute(IParamNodePO node, List<String> ref, Locale locale, CheckErrors errors) {
            if (!this.m_insertParamRef) {
                ISpecTestCasePO parent = (ISpecTestCasePO)node.getParentNode();
                IParamDescriptionPO desc = null;
                for (String refName : ref) {
                    if (parent.getParamNames().contains(refName)) {
                        desc = parent.getParameterForName(refName);
                    }
                    if (desc == null) continue;
                    try {
                        ModelParamValueConverter conv;
                        ITestDataPO td = parent.getDataManager().getCell(0, desc);
                        String value = td.getValue(locale);
                        if (value == null || (conv = new ModelParamValueConverter(value, (IParameterInterfacePO)parent, locale, desc)).getNamesForReferences().isEmpty()) continue;
                        this.m_specTcParamRefCheck.execute(parent, ref, locale, errors);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                }
            }
            this.getCheck().execute(node, ref, locale, errors);
        }
    }

    private static class CheckErrors {
        private Map<String, List> m_errorCodes = new HashMap<String, List>();

        private CheckErrors() {
        }

        public void add(String errorCode, Object[] params) {
            if (!this.m_errorCodes.containsKey(errorCode)) {
                this.m_errorCodes.put(errorCode, new ArrayList());
            }
            if (params != null) {
                List paramList = this.m_errorCodes.get(errorCode);
                paramList.addAll(Arrays.asList(params));
            }
        }

        public boolean hasErrors() {
            return !this.m_errorCodes.isEmpty();
        }

        public String buildErrorMessage() {
            StringBuffer msg = new StringBuffer();
            for (String key : this.m_errorCodes.keySet()) {
                List l;
                Object[] object = new Object[]{this.m_errorCodes.get(key)};
                if (this.m_errorCodes.get(key) instanceof ArrayList && (l = this.m_errorCodes.get(key)).isEmpty()) {
                    object = new Object[]{};
                }
                msg.append(I18n.getString((String)key, (Object[])object));
                msg.append('\n');
            }
            return msg.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExecTcHaveReferencedTDCheck
    extends ParamCheck {
        private ExecTcHaveReferencedTDCheck() {
        }

        @Override
        public void execute(IParamNodePO node, List<String> ref, Locale locale, CheckErrors errors) {
            ISpecTestCasePO parent = (ISpecTestCasePO)node.getParentNode();
            List<Object> execTestCases = new ArrayList(0);
            try {
                execTestCases = NodePM.getAllExecTestCases(parent.getGuid(), parent.getParentProjectId());
            }
            catch (JBException e) {
                LOG.error((Object)e);
            }
            List<String> paramNames = parent.getParamNames();
            for (String refName : ref) {
                if (refName == null || paramNames.contains(refName)) continue;
                ArrayList<String> checkList = new ArrayList<String>();
                for (IExecTestCasePO iExecTestCasePO : execTestCases) {
                    String name;
                    if (iExecTestCasePO.getHasReferencedTD()) continue;
                    String string = name = iExecTestCasePO.getParentNode() != null ? iExecTestCasePO.getParentNode().getName() : iExecTestCasePO.getName();
                    if (checkList.contains(name)) continue;
                    errors.add(Messages.TestCaseParamCheckBPTestExecHasOwnTestData, new String[]{name});
                    checkList.add(name);
                }
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExecTcParamRefCheck
    extends ParamCheck {
        private boolean m_insertParamRef;

        public ExecTcParamRefCheck(boolean insertParamRef) {
            this.m_insertParamRef = insertParamRef;
        }

        @Override
        public void execute(IParamNodePO node, List<String> ref, Locale locale, CheckErrors errors) {
            IExecTestCasePO execNode = (IExecTestCasePO)node;
            INodePO parent = execNode.getParentNode();
            Class parentPoClass = Hibernator.getClass(parent);
            if (this.m_insertParamRef) {
                if (Hibernator.isPoClassSubclass(parentPoClass, ITestSuitePO.class)) {
                    errors.add(Messages.TestCaseParamCheckBPTestExecHasTestSuiteParent, new String[]{execNode.getName()});
                }
            } else if (Hibernator.isPoClassSubclass(parentPoClass, IParamNodePO.class)) {
                for (String refName : ref) {
                    this.checkTDHasNoRefAsValue(refName, errors, (IParamNodePO)parent, locale);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IParamCheck {
        public void execute(IParamNodePO var1, List<String> var2, Locale var3, CheckErrors var4);
    }

    public static abstract class ParamCheck
    implements IParamCheck {
        private IParamCheck m_check;

        protected ParamCheck(IParamCheck check) {
            this.m_check = check;
        }

        protected ParamCheck() {
        }

        protected IParamCheck getCheck() {
            return this.m_check;
        }

        protected void checkTDHasNoRefAsValue(String ref, CheckErrors errors, IParamNodePO parent, Locale locale) {
            try {
                IParamDescriptionPO desc = parent.getParameterForName(ref);
                ITestDataPO td = parent.getDataManager().getCell(0, desc);
                ModelParamValueConverter conv = new ModelParamValueConverter(td, (IParameterInterfacePO)parent, locale, desc);
                List<String> refsForTD = conv.getNamesForReferences();
                if (!refsForTD.isEmpty() && !this.hasMoreThanOneChildrenWithRef(parent, ref, locale)) {
                    errors.add(NLS.bind((String)Messages.TestCaseParamCheckBPTestCaseDefinesRefs, (Object[])new String[]{parent.getName(), ref}), null);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        }

        private boolean hasMoreThanOneChildrenWithRef(IParamNodePO node, String ref, Locale locale) {
            Iterator<INodePO> childIter = node.getNodeListIterator();
            int refCount = 0;
            block0: while (refCount < 2 && childIter.hasNext()) {
                INodePO child = childIter.next();
                if (!(child instanceof IParamNodePO)) continue;
                Iterator<TDCell> refIter = ((IParamNodePO)child).getParamReferencesIterator(locale);
                while (refIter.hasNext()) {
                    TDCell cell = refIter.next();
                    List<String> refs = cell.getReferences(node, locale);
                    if (!refs.contains(ref)) continue;
                    ++refCount;
                    continue block0;
                }
            }
            return refCount > 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SpecTcParamRefCheck
    extends ParamCheck {
        private static boolean editorShouldBeDirty = true;

        @Override
        public void execute(IParamNodePO node, List<String> ref, Locale locale, CheckErrors errors) {
            ISpecTestCasePO specNode = (ISpecTestCasePO)node;
            try {
                List<IExecTestCasePO> execTestCases = NodePM.getAllExecTestCases(specNode.getGuid(), specNode.getParentProjectId());
                for (IExecTestCasePO execTc : execTestCases) {
                    if (execTc.getParentNode() instanceof ITestSuitePO) continue;
                    String name = execTc.getParentNode() != null ? execTc.getParentNode().getName() : execTc.getName();
                    errors.add(String.valueOf(Messages.TestCaseParamCheckBPTestCaseIsUsed1) + specNode.getName() + Messages.TestCaseParamCheckBPTestCaseIsUsed2, new String[]{name});
                    editorShouldBeDirty = false;
                }
            }
            catch (JBException jBException) {
                errors.add(Messages.ErrorMessageDATABASE_GENERAL, null);
            }
        }

        public static boolean editorShouldBeDirty() {
            return editorShouldBeDirty;
        }

        public static void setEditorShouldBeDirty(boolean dirty) {
            editorShouldBeDirty = dirty;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestDataParamCheck
    extends ParamCheck {
        @Override
        public void execute(IParamNodePO node, List<String> ref, Locale locale, CheckErrors errors) {
            Iterator<TDCell> it = node.getParamReferencesIterator(0, locale);
            while (it.hasNext()) {
                List<String> refNames = it.next().getReferences(node, locale);
                String notAllowedRef = "";
                if (refNames.containsAll(ref)) continue;
                for (String refInput : ref) {
                    if (refNames.contains(refInput)) continue;
                    notAllowedRef = refInput;
                    break;
                }
                errors.add(Messages.TestCaseParamCheckBPInvalidRefInTestData, new String[]{notAllowedRef});
            }
            if (!node.getParamReferencesIterator(0, locale).hasNext()) {
                for (String refInput : ref) {
                    errors.add(Messages.TestCaseParamCheckBPInvalidRefInTestData, new String[]{refInput});
                }
            }
        }
    }
}

