/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.Date;
import java.util.Set;
import javax.persistence.EntityManager;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.core.ClientTestFactory;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParameterDetailsPO;
import org.eclipse.jubula.client.core.model.ITestCasePO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestResultPO;
import org.eclipse.jubula.client.core.model.ITestResultSummary;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.model.TestResult;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.client.core.persistence.Hibernator;
import org.eclipse.jubula.tools.constants.MonitoringConstants;
import org.eclipse.jubula.tools.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.i18n.I18n;

public class TestresultSummaryBP {
    public static final String AUTRUN = "autrun";
    public static final int TYPE_TEST_STEP = 3;
    public static final int TYPE_TEST_CASE = 2;
    public static final int TYPE_TEST_SUITE = 1;
    private static TestresultSummaryBP instance = null;
    private Long m_parentKeyWordId;

    public void populateTestResultSummary(TestResult result, ITestResultSummary summary) {
        IAUTMainPO aut;
        TestExecution te = TestExecution.getInstance();
        ITestSuitePO ts = te.getStartedTestSuite();
        IAUTMainPO startedAut = te.getConnectedAut();
        if (result.getAutConfigMap() != null && startedAut != null) {
            String autConfigName = result.getAutConfigName();
            for (IAUTConfigPO conf : startedAut.getAutConfigSet()) {
                if (!conf.getValue("CONFIG_NAME", "invalid").equals(autConfigName)) continue;
                summary.setInternalAutConfigGuid(conf.getGuid());
                break;
            }
        } else {
            summary.setInternalAutConfigGuid(AUTRUN);
        }
        summary.setAutConfigName(result.getAutConfigName());
        summary.setAutCmdParameter(result.getAutArguments());
        summary.setAutId(result.getAutId());
        summary.setAutOS(System.getProperty("os.name"));
        IAUTMainPO iAUTMainPO = aut = startedAut != null ? startedAut : ts.getAut();
        if (aut != null) {
            summary.setInternalAutGuid(aut.getGuid());
            summary.setAutName(aut.getName());
            summary.setAutToolkit(aut.getToolkit());
        }
        summary.setTestsuiteDate(new Date());
        summary.setInternalTestsuiteGuid(ts.getGuid());
        summary.setTestsuiteName(ts.getName());
        summary.setInternalProjectGuid(result.getProjectGuid());
        summary.setInternalProjectID(result.getProjectId());
        summary.setProjectName(String.valueOf(result.getProjectName()) + " " + result.getProjectMajorVersion() + "." + result.getProjectMinorVersion());
        summary.setProjectMajorVersion(result.getProjectMajorVersion());
        summary.setProjectMinorVersion(result.getProjectMinorVersion());
        Date startTime = ClientTestFactory.getClientTest().getTestsuiteStartTime();
        summary.setTestsuiteStartTime(startTime);
        Date endTime = new Date();
        summary.setTestsuiteEndTime(endTime);
        summary.setTestsuiteDuration(this.getDurationString(startTime, endTime));
        summary.setTestsuiteExecutedTeststeps(te.getNumberOfTestedSteps());
        summary.setTestsuiteExpectedTeststeps(te.getExpectedNumberOfSteps());
        summary.setTestsuiteEventHandlerTeststeps(te.getNumberOfEventHandlerSteps() + te.getNumberOfRetriedSteps());
        summary.setTestsuiteFailedTeststeps(te.getNumberOfFailedSteps());
        summary.setTestsuiteLanguage(te.getLocale().getDisplayName());
        summary.setTestsuiteRelevant(ClientTestFactory.getClientTest().isRelevant());
        ITestJobPO tj = te.getStartedTestJob();
        if (tj != null) {
            summary.setTestJobName(tj.getName());
            summary.setInternalTestJobGuid(tj.getGuid());
            summary.setTestJobStartTime(ClientTestFactory.getClientTest().getTestjobStartTime());
        }
        summary.setTestsuiteStatus(result.getRootResultNode().getStatus());
        summary.setInternalMonitoringId("none selected");
        summary.setReport(MonitoringConstants.EMPTY_REPORT);
        summary.setReportWritten(false);
        summary.setMonitoringValueType("none");
    }

    public EntityManager createTestResultDetailsSession(TestResult result, Long summaryId) {
        EntityManager sess = Hibernator.instance().openSession();
        Hibernator.instance().getTransaction(sess);
        this.buildTestResultDetailsSession(result.getRootResultNode(), sess, summaryId, 1, 1);
        return sess;
    }

    private int buildTestResultDetailsSession(TestResultNode result, EntityManager sess, Long summaryId, int nodeLevel, int startingNodeSequence) {
        int nodeSequence = startingNodeSequence;
        TestResultNode resultNode = result;
        ITestResultPO keyword = PoMaker.createTestResultPO();
        this.fillNode(keyword, resultNode, sess);
        keyword.setKeywordLevel(nodeLevel);
        keyword.setKeywordSequence(nodeSequence);
        keyword.setInternalTestResultSummaryID(summaryId);
        keyword.setInternalParentKeywordID(this.m_parentKeyWordId);
        sess.persist((Object)keyword);
        for (TestResultNode node : resultNode.getResultNodeList()) {
            this.m_parentKeyWordId = keyword.getId();
            nodeSequence = this.buildTestResultDetailsSession(node, sess, summaryId, nodeLevel + 1, nodeSequence + 1);
        }
        return nodeSequence;
    }

    private void fillNode(ITestResultPO keyword, TestResultNode node, EntityManager sess) {
        INodePO inode = node.getNode();
        keyword.setKeywordName(node.getNode().getName());
        keyword.setInternalKeywordGuid(inode.getGuid());
        keyword.setKeywordComment(inode.getComment());
        keyword.setInternalKeywordStatus(node.getStatus());
        keyword.setKeywordStatus(node.getStatusString());
        if (node.getTimeStamp() != null) {
            keyword.setTimestamp(node.getTimeStamp());
        }
        if (node.getParent() != null) {
            keyword.setInternalParentKeywordID(node.getParent().getNode().getId());
        }
        if (inode instanceof ICapPO) {
            keyword.setInternalKeywordType(3);
            keyword.setKeywordType("Test Step");
            ICapPO cap = (ICapPO)inode;
            String compNameGuid = cap.getComponentName();
            keyword.setInternalComponentNameGuid(compNameGuid);
            keyword.setComponentName(StringUtils.defaultString((String)node.getComponentName()));
            keyword.setInternalComponentType(cap.getComponentType());
            keyword.setComponentType(CompSystemI18n.getString((String)cap.getComponentType()));
            keyword.setInternalActionName(cap.getActionName());
            keyword.setActionName(CompSystemI18n.getString((String)cap.getActionName()));
            this.addParameterListToResult(keyword, node, cap);
            this.addErrorDetails(keyword, node, sess);
        } else if (inode instanceof ITestCasePO) {
            keyword.setInternalKeywordType(2);
            keyword.setKeywordType("Test Case");
        } else if (inode instanceof ITestSuitePO) {
            keyword.setInternalKeywordType(1);
            keyword.setKeywordType("Test Suite");
        }
    }

    private ITestResultPO addParameterListToResult(ITestResultPO keyword, TestResultNode node, ICapPO cap) {
        int index = 0;
        for (IParamDescriptionPO param : cap.getParameterList()) {
            String value;
            IParameterDetailsPO parameter = PoMaker.createParameterDetailsPO();
            parameter.setParameterName(param.getName());
            parameter.setInternalParameterType(param.getType());
            parameter.setParameterType(CompSystemI18n.getString((String)param.getType(), (boolean)true));
            String paramValue = "";
            if (node.getParamValues().size() >= index + 1 && (value = node.getParamValues().get(index)) != null) {
                paramValue = value.length() == 0 ? "''" : value;
            }
            parameter.setParameterValue(paramValue);
            keyword.addParameter(parameter);
            ++index;
        }
        return keyword;
    }

    private void addErrorDetails(ITestResultPO keyword, TestResultNode node, EntityManager sess) {
        if (node.getStatus() == 2 || node.getStatus() == 7) {
            keyword.setStatusType(I18n.getString((String)node.getEvent().getId(), (boolean)true));
            Set keys = node.getEvent().getProps().keySet();
            if (node.getEvent().getId().equals("TestErrorEvent.Action")) {
                String key = (String)node.getEvent().getProps().get("guidancerErrorDescription");
                Object[] args = (Object[])node.getEvent().getProps().get("guidancerErrorParameter");
                if (key != null) {
                    keyword.setStatusDescription(String.valueOf(I18n.getString((String)key, (Object[])args)));
                }
            } else {
                for (Object key : keys) {
                    String value = String.valueOf(node.getEvent().getProps().get(key));
                    if (key.equals("guidancerOperator")) {
                        keyword.setStatusOperator(value);
                    }
                    if (key.equals("guidancerPattern")) {
                        keyword.setExpectedValue(value);
                    }
                    if (!key.equals("guidancerActualValue")) continue;
                    keyword.setActualValue(value);
                }
            }
            if (node.getScreenshot() != null) {
                keyword.setImage(node.getScreenshot());
            }
        }
    }

    public static TestresultSummaryBP getInstance() {
        if (instance == null) {
            instance = new TestresultSummaryBP();
        }
        return instance;
    }

    private String getDurationString(Date startTime, Date endTime) {
        long minutes;
        long seconds;
        long timeInSeconds = endTime.getTime() - startTime.getTime();
        long hours = (timeInSeconds /= 1000L) / 3600L;
        timeInSeconds -= hours * 3600L;
        String secondsString = (seconds = (timeInSeconds -= (minutes = timeInSeconds / 60L) * 60L)) < 10L ? "0" + seconds : String.valueOf(seconds);
        String minutesString = minutes < 10L ? "0" + minutes : String.valueOf(minutes);
        String hoursString = hours < 10L ? "0" + hours : String.valueOf(hours);
        return String.valueOf(hoursString) + ":" + minutesString + ":" + secondsString;
    }
}

