/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess.db;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMDirtyVersionException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMObjectDeletedException;
import org.eclipse.jubula.client.core.persistence.PersistenceManager;
import org.eclipse.jubula.client.core.persistence.locking.LockManager;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.core.utils.TreeTraverser;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeBP {
    private static final Log LOG = LogFactory.getLog(NodeBP.class);

    protected NodeBP() {
    }

    protected static void lockPO(EditSupport editSupport, INodePO node) throws PMObjectDeletedException, PMDirtyVersionException, PMAlreadyLockedException {
        EntityManager lockSession = editSupport.getSession();
        try {
            try {
                lockSession.detach((Object)node);
                lockSession.find(node.getClass(), (Object)node.getId());
            }
            catch (PersistenceException e) {
                PersistenceManager.handleDBExceptionForEditor(node, e, editSupport);
            }
        }
        catch (PMDirtyVersionException pMDirtyVersionException) {
        }
        catch (PMObjectDeletedException e) {
            throw e;
        }
        catch (PMException e) {
            LOG.fatal((Object)(String.valueOf(Messages.StrayHibernateException) + "." + "."), (Throwable)((Object)e));
        }
        if (!LockManager.instance().lockPO(lockSession, node, false)) {
            throw new PMAlreadyLockedException(node, String.valueOf(Messages.OrginalTestcaseLocked) + ".", MessageIDs.E_OBJECT_IN_USE);
        }
    }

    public static List<? extends INodePO> getAllNodesForGivenTypeInCurrentProject(Class type) {
        if (INodePO.class.isAssignableFrom(type)) {
            GeneralStorage gs = GeneralStorage.getInstance();
            return NodePM.computeListOfNodes(type, gs.getProject().getId(), gs.getMasterSession());
        }
        return ListUtils.EMPTY_LIST;
    }

    public static boolean isEditable(INodePO node) {
        Validate.notNull((Object)node);
        IProjectPO activeProject = GeneralStorage.getInstance().getProject();
        if (activeProject == node) {
            return true;
        }
        return activeProject != null && activeProject.getId().equals(node.getParentProjectId());
    }

    public static ITestSuitePO getOwningTestSuite(INodePO node) {
        IProjectPO activeProject = GeneralStorage.getInstance().getProject();
        if (activeProject != null) {
            IsSubNodeOperation op = new IsSubNodeOperation(node);
            for (ITestSuitePO testSuite : activeProject.getTestSuiteCont().getTestSuiteList()) {
                TreeTraverser traverser = new TreeTraverser(testSuite, op);
                traverser.traverse(true);
                if (!op.isSubNode()) continue;
                return testSuite;
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IsSubNodeOperation
    implements ITreeNodeOperation<INodePO> {
        private boolean m_isSubNode;
        private INodePO m_node;

        public IsSubNodeOperation(INodePO node) {
            this.m_node = node;
            this.m_isSubNode = false;
        }

        @Override
        public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            if (node == this.m_node) {
                this.m_isSubNode = true;
            }
            return !this.m_isSubNode;
        }

        @Override
        public void postOperate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
        }

        public boolean isSubNode() {
            return this.m_isSubNode;
        }
    }
}

