/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess.db;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.eclipse.jubula.client.core.businessprocess.db.NodeBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.Hibernator;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMDirtyVersionException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMObjectDeletedException;
import org.eclipse.jubula.client.core.persistence.PMSaveException;
import org.eclipse.jubula.tools.exception.InvalidDataException;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;

public class TestCaseBP
extends NodeBP {
    private TestCaseBP() {
    }

    public static IExecTestCasePO addReferencedTestCase(EditSupport editSupport, INodePO targetTC, ISpecTestCasePO referencedTC, Integer position) throws PMAlreadyLockedException, PMDirtyVersionException, PMObjectDeletedException {
        TestCaseBP.handleFirstReference(editSupport, referencedTC, false);
        IExecTestCasePO newExecTC = NodeMaker.createExecTestCasePO(referencedTC);
        if (position != null) {
            targetTC.addNode(position, newExecTC);
        } else {
            targetTC.addNode(newExecTC);
        }
        DataEventDispatcher.getInstance().fireDataChangedListener(newExecTC, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.onlyInEditor);
        return newExecTC;
    }

    private static void handleFirstReference(EditSupport editSupport, ISpecTestCasePO referencedTC, boolean isReferencedByThisAction) throws PMAlreadyLockedException, PMDirtyVersionException, PMObjectDeletedException {
        int minSize = 0;
        if (isReferencedByThisAction) {
            minSize = 1;
        }
        if (NodePM.getInternalExecTestCases(referencedTC.getGuid(), referencedTC.getParentProjectId()).size() <= minSize) {
            TestCaseBP.lockPO(editSupport, referencedTC);
        }
    }

    public static void addEventHandler(EditSupport editSupport, ISpecTestCasePO targetTC, IEventExecTestCasePO eventHandlerTC) throws InvalidDataException, PMAlreadyLockedException, PMDirtyVersionException, PMObjectDeletedException {
        TestCaseBP.handleFirstReference(editSupport, eventHandlerTC.getSpecTestCase(), true);
        targetTC.addEventTestCase(eventHandlerTC);
    }

    public static ISpecTestCasePO createNewSpecTestCase(String name, INodePO parent, Integer position) throws PMSaveException, PMAlreadyLockedException, PMException, ProjectDeletedException {
        Integer pos = position;
        ISpecTestCasePO specTC = NodeMaker.createSpecTestCasePO(name);
        NodePM.AbstractCmdHandleChild cmdHandleChild = NodePM.getCmdHandleChild(parent, specTC);
        if (pos != null && pos < 0) {
            pos = null;
        }
        NodePM.addAndPersistChildNode(parent, specTC, pos, cmdHandleChild);
        return specTC;
    }

    public static INodePO getSpecTestCaseContainer(INodePO currentNode) {
        INodePO parent = currentNode;
        Class parentClass = Hibernator.getClass(parent);
        while (!Hibernator.isPoClassSubclass(parentClass, IProjectPO.class) && !Hibernator.isPoClassSubclass(parentClass, ICategoryPO.class)) {
            parent = parent.getParentNode();
            parentClass = Hibernator.getClass(parent);
        }
        return parent;
    }

    public static boolean belongsToCurrentProject(ISpecTestCasePO specTc) {
        if (specTc != null) {
            EqualsBuilder eb = new EqualsBuilder();
            eb.append((Object)specTc.getParentProjectId(), (Object)GeneralStorage.getInstance().getProject().getId());
            return eb.isEquals();
        }
        return false;
    }
}

