/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess.db;

import javax.persistence.EntityManager;
import org.eclipse.jubula.client.core.model.ITimestampPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.HibernateUtil;

public class TimestampBP {
    private TimestampBP() {
    }

    private static boolean isMasterSessionUpToDate(ITimestampPO timeStampPO) {
        ITimestampPO masterObject = TimestampBP.getFromMasterSession(timeStampPO);
        return masterObject.getTimestamp() >= timeStampPO.getTimestamp();
    }

    private static ITimestampPO getFromMasterSession(ITimestampPO timeStampPO) {
        EntityManager masterSession = GeneralStorage.getInstance().getMasterSession();
        return (ITimestampPO)masterSession.find(HibernateUtil.getClass(timeStampPO), (Object)timeStampPO.getId());
    }

    public static boolean refreshEditorNodeInMasterSession(ITimestampPO timeStampPO) {
        boolean isUpToDate = TimestampBP.isMasterSessionUpToDate(timeStampPO);
        if (!isUpToDate) {
            EntityManager masterSession = GeneralStorage.getInstance().getMasterSession();
            ITimestampPO masterObject = TimestampBP.getFromMasterSession(timeStampPO);
            masterSession.detach((Object)masterObject);
            masterObject = (ITimestampPO)masterSession.find(masterObject.getClass(), (Object)masterObject.getId());
            masterSession.refresh((Object)masterObject);
            GeneralStorage.getInstance().fireDataModified(masterObject);
        }
        return isUpToDate;
    }

    public static void refreshTimestamp(ITimestampPO timeStampPO) {
        long timestamp = System.currentTimeMillis();
        timeStampPO.setTimestamp(timestamp);
    }
}

