/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess.treeoperations;

import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckIfComponentNameIsReusedOp
implements ITreeNodeOperation<INodePO> {
    private String m_compNameGuid;
    private boolean m_isReused = false;

    public CheckIfComponentNameIsReusedOp(String compNameGuid) {
        this.m_compNameGuid = compNameGuid;
    }

    @Override
    public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
        if (node instanceof ICapPO) {
            ICapPO cap = (ICapPO)node;
            if (cap.getComponentName().equals(this.m_compNameGuid)) {
                this.m_isReused = true;
                ctx.setContinued(false);
                return false;
            }
        } else if (node instanceof IExecTestCasePO) {
            IExecTestCasePO execTc = (IExecTestCasePO)node;
            for (ICompNamesPairPO pair : execTc.getCompNamesPairs()) {
                if (!pair.getFirstName().equals(this.m_compNameGuid) && !pair.getSecondName().equals(this.m_compNameGuid)) continue;
                this.m_isReused = true;
                ctx.setContinued(false);
                return false;
            }
        }
        return !alreadyVisited;
    }

    @Override
    public void postOperate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
    }

    public boolean hasFoundReuse() {
        return this.m_isReused;
    }
}

