/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.commands;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jubula.client.core.AUTEvent;
import org.eclipse.jubula.client.core.ClientTestFactory;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.communication.ICommand;
import org.eclipse.jubula.communication.message.AUTServerStateMessage;
import org.eclipse.jubula.communication.message.AUTStartMessage;
import org.eclipse.jubula.communication.message.Message;

public class AUTServerStateCommand
implements ICommand {
    private static Log log = LogFactory.getLog(AUTServerStateCommand.class);
    private AUTServerStateMessage m_message;

    public Message getMessage() {
        return this.m_message;
    }

    public void setMessage(Message message) {
        this.m_message = (AUTServerStateMessage)message;
    }

    public Message execute() {
        int state = this.m_message.getState();
        switch (state) {
            case 0: {
                log.info((Object)Messages.AUTServerIsReady);
                ClientTestFactory.getClientTest().fireAUTStateChanged(new AUTEvent(8));
                return new AUTStartMessage();
            }
            case 1: {
                log.info((Object)(String.valueOf(Messages.TheAUTCouldNotFound) + "." + " " + this.m_message.getDescription()));
                ClientTestFactory.getClientTest().fireAUTStateChanged(new AUTEvent(4));
                break;
            }
            case 2: {
                log.info((Object)(String.valueOf(Messages.TheMainMethodCouldNotLoaded) + "." + " "));
                ClientTestFactory.getClientTest().fireAUTStateChanged(new AUTEvent(5));
                break;
            }
            case 3: {
                log.info((Object)(String.valueOf(Messages.AUTClassFormatNotSupportedByUsedJRE) + "." + " "));
                ClientTestFactory.getClientTest().fireAUTStateChanged(new AUTEvent(7));
            }
        }
        return null;
    }

    public void timeout() {
        log.fatal((Object)(String.valueOf(this.getClass().getName()) + "timeout() called"));
    }
}

