/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.commands;

import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jubula.client.core.AUTEvent;
import org.eclipse.jubula.client.core.ClientTestFactory;
import org.eclipse.jubula.client.core.IAUTInfoListener;
import org.eclipse.jubula.client.core.businessprocess.ObjectMappingEventDispatcher;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.IObjectMappingPO;
import org.eclipse.jubula.communication.ICommand;
import org.eclipse.jubula.communication.message.AUTStartStateMessage;
import org.eclipse.jubula.communication.message.AUTStateMessage;
import org.eclipse.jubula.communication.message.Message;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.objects.IComponentIdentifier;
import org.eclipse.jubula.tools.xml.businessmodell.Component;
import org.eclipse.jubula.tools.xml.businessmodell.ConcreteComponent;

public class AUTStartedCommand
implements ICommand {
    private static Log log = LogFactory.getLog(AUTStartedCommand.class);
    private IAUTInfoListener m_listener;
    private AUTStartStateMessage m_message;
    private AUTStateMessage m_stateMessage;
    private boolean m_wasExecuted = false;

    public AUTStartedCommand() {
    }

    public AUTStartedCommand(IAUTInfoListener listener) throws IllegalArgumentException {
        Validate.notNull((Object)listener, (String)"listener must not be null");
        this.m_listener = listener;
    }

    public void setStateMessage(AUTStateMessage stateMessage) {
        this.m_stateMessage = stateMessage;
    }

    private void fireAutStateChanged() {
        int state = this.m_stateMessage.getState();
        switch (state) {
            case 1: {
                log.info((Object)Messages.AUTIsRunning);
                ClientTestFactory.getClientTest().fireAUTStateChanged(new AUTEvent(1));
                break;
            }
            case 2: {
                log.error((Object)(String.valueOf(Messages.AUTCouldNotStarted) + ":" + " " + this.m_stateMessage.getDescription()));
                ClientTestFactory.getClientTest().fireAUTStateChanged(new AUTEvent(6));
            }
        }
    }

    public Message getMessage() {
        return this.m_message;
    }

    public void setMessage(Message message) {
        this.m_message = (AUTStartStateMessage)message;
    }

    private String getLogicalName(Component comp) {
        ConcreteComponent cc;
        String logicalName = null;
        if (comp.isConcrete() && (cc = (ConcreteComponent)comp).hasDefaultMapping()) {
            String logicalNameKey = cc.getDefaultMapping().getLogicalName();
            String name = CompSystemI18n.getString((String)logicalNameKey);
            logicalName = name != null ? name : logicalNameKey;
        }
        return logicalName;
    }

    public Message execute() {
        ObjectMappingEventDispatcher.clearObjMapTransient();
        IObjectMappingPO transientObjMap = ObjectMappingEventDispatcher.getObjMapTransient();
        IObjectMappingCategoryPO oldCategory = ObjectMappingEventDispatcher.getCategoryToCreateIn();
        ObjectMappingEventDispatcher.setCategoryToCreateIn(transientObjMap.getMappedCategory());
        for (IComponentIdentifier id : this.m_message.getCompIds()) {
            Component comp = ComponentBuilder.getInstance().getCompSystem().findComponent(id.getComponentClassName());
            String logicalName = this.getLogicalName(comp);
            if (logicalName != null) {
                transientObjMap.addObjectMappingAssoziation(logicalName, id);
                continue;
            }
            if (!log.isErrorEnabled()) continue;
            log.error((Object)(String.valueOf(Messages.NoLogicalNameForDefaultMapping) + " " + Messages.DefinedByComponent + ":" + " " + comp));
        }
        ObjectMappingEventDispatcher.setCategoryToCreateIn(oldCategory);
        this.fireAutStateChanged();
        this.m_wasExecuted = true;
        return null;
    }

    public boolean wasExecuted() {
        return this.m_wasExecuted;
    }

    public void timeout() {
        log.warn((Object)(String.valueOf(this.getClass().getName()) + ".timeout() called"));
        this.m_listener.error(1);
    }
}

