/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.commands;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.communication.ICommand;
import org.eclipse.jubula.communication.message.CAPTestResponseMessage;
import org.eclipse.jubula.communication.message.Message;
import org.eclipse.jubula.communication.message.MessageCap;

public class CAPTestResponseCommand
implements ICommand {
    private static final Log LOG = LogFactory.getLog(CAPTestResponseCommand.class);
    private CAPTestResponseMessage m_capTestResponseMessage;
    private MessageCap m_messageCap;

    public Message getMessage() {
        return this.m_capTestResponseMessage;
    }

    public void setMessage(Message message) {
        this.m_capTestResponseMessage = (CAPTestResponseMessage)message;
    }

    public Message execute() {
        this.logResult();
        TestExecution.getInstance().processServerResponse((CAPTestResponseMessage)this.getMessage());
        return null;
    }

    public void timeout() {
        StringBuilder messageCapData = new StringBuilder(";");
        messageCapData.append(Messages.MessageCap);
        messageCapData.append(":");
        messageCapData.append(" ");
        if (LOG.isErrorEnabled()) {
            if (this.m_capTestResponseMessage != null) {
                MessageCap msgCap = this.m_capTestResponseMessage.getMessageCap();
                messageCapData.append(Messages.Method).append("'").append(msgCap.getMethod()).append("'").append(",").append(" ").append(Messages.ComponentId).append(" ").append("'").append(msgCap.getCi()).append("'");
            } else {
                messageCapData.append(Messages.Null);
            }
        }
        LOG.error((Object)(String.valueOf(this.getClass().getName()) + " " + Messages.TimeoutCalled + messageCapData.toString()));
        TestExecution.getInstance().timeout();
    }

    private void logResult() {
        if (LOG.isInfoEnabled()) {
            String message = String.valueOf(Messages.TestStepResult) + ":";
            int state = this.m_capTestResponseMessage.getState();
            switch (state) {
                case 0: {
                    message = String.valueOf(message) + Messages.Success;
                    if (Void.TYPE.getName().equals(this.m_capTestResponseMessage.getReturnType())) break;
                    message = String.valueOf(message) + "\n" + Messages.ReturnType + " " + this.m_capTestResponseMessage.getReturnType() + "\n" + Messages.ReturnValue + ":" + this.m_capTestResponseMessage.getReturnValue();
                    break;
                }
                case 1: {
                    message = String.valueOf(message) + Messages.GeneralFailure + "\n";
                    break;
                }
                case 2: {
                    message = String.valueOf(message) + Messages.Failure + ":" + " " + Messages.MissingPermission + "\n";
                    break;
                }
                case 3: {
                    message = String.valueOf(message) + Messages.Failure + ":" + " " + Messages.MethodNotAccesible + "\n";
                    break;
                }
                case 10: {
                    message = String.valueOf(message) + Messages.Failure + ":" + " " + Messages.MissingImplementationClass + "\n";
                    break;
                }
                case 11: {
                    break;
                }
                case 12: {
                    message = String.valueOf(message) + Messages.Failure + ":" + " " + Messages.parametersAreNotValid + "\n";
                    break;
                }
                case 13: {
                    message = String.valueOf(message) + Messages.Failure + ":" + " " + Messages.ImplementingMethodHasThrownAnException + "\n";
                    break;
                }
                case 20: {
                    message = String.valueOf(message) + Messages.Failure + ":" + " " + Messages.ComponentIsNotSupported + "\n";
                    break;
                }
                case 21: {
                    message = String.valueOf(message) + Messages.Failure + ":" + " " + Messages.ComponentNotFound + "\n";
                    break;
                }
                default: {
                    message = String.valueOf(Messages.UnknownState) + ":" + " " + state;
                }
            }
            LOG.debug((Object)message);
        }
    }

    public MessageCap getMessageCap() {
        return this.m_messageCap;
    }

    public void setMessageCap(MessageCap messageCap) {
        this.m_messageCap = messageCap;
    }
}

