/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.commands;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jubula.client.core.AUTServerEvent;
import org.eclipse.jubula.client.core.ClientTestFactory;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.communication.ICommand;
import org.eclipse.jubula.communication.message.Message;
import org.eclipse.jubula.communication.message.StartAUTServerStateMessage;

public class StartAUTServerStateCommand
implements ICommand {
    private static Log log = LogFactory.getLog(StartAUTServerStateCommand.class);
    private StartAUTServerStateMessage m_message;

    public Message getMessage() {
        return this.m_message;
    }

    public void setMessage(Message message) {
        this.m_message = (StartAUTServerStateMessage)message;
    }

    public Message execute() {
        int state = this.m_message.getReason();
        switch (state) {
            case 0: {
                log.info((Object)Messages.AUTServerIsStarting);
                break;
            }
            case 3: {
                log.fatal((Object)(String.valueOf(Messages.NoJavaFound) + ":" + " " + this.m_message.getDescription()));
                ClientTestFactory.getClientTest().fireAUTServerStateChanged(new AUTServerEvent(7));
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                log.error((Object)(String.valueOf(Messages.AUTServerCouldNotStart) + ":" + " " + this.m_message.getDescription()));
                ClientTestFactory.getClientTest().fireAUTServerStateChanged(new AUTServerEvent(4));
                break;
            }
            case 6: 
            case 7: {
                log.info((Object)(String.valueOf(Messages.AUTServerCouldNotStart) + ":" + " " + this.m_message.getDescription()));
                ClientTestFactory.getClientTest().fireAUTServerStateChanged(new AUTServerEvent(5));
                break;
            }
            case 8: 
            case 9: {
                log.info((Object)(String.valueOf(Messages.AUTServerCouldNotStart) + ":" + " " + this.m_message.getDescription()));
                ClientTestFactory.getClientTest().fireAUTServerStateChanged(new AUTServerEvent(6));
                break;
            }
            case 12: {
                log.error((Object)(String.valueOf(Messages.AUTServerCouldNotStart) + ":" + " " + this.m_message.getDescription()));
                ClientTestFactory.getClientTest().fireAUTServerStateChanged(new AUTServerEvent(11));
                break;
            }
            case 13: {
                log.error((Object)(String.valueOf(Messages.AUTServerCouldNotStart) + ":" + " " + this.m_message.getDescription()));
                ClientTestFactory.getClientTest().fireAUTServerStateChanged(new AUTServerEvent(12));
                break;
            }
            case 14: {
                log.error((Object)(String.valueOf(Messages.AUTServerCouldNotStart) + ":" + " " + this.m_message.getDescription()));
                ClientTestFactory.getClientTest().fireAUTServerStateChanged(new AUTServerEvent(13));
                break;
            }
            default: {
                log.error((Object)(String.valueOf(Messages.UnknownState) + " " + String.valueOf(state) + ":" + this.m_message.getDescription()));
            }
        }
        return null;
    }

    public void timeout() {
        log.error((Object)(String.valueOf(this.getClass().getName()) + "." + Messages.TimeoutCalled));
    }
}

