/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.communication;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jubula.client.core.AUTEvent;
import org.eclipse.jubula.client.core.AUTServerEvent;
import org.eclipse.jubula.client.core.ClientTestFactory;
import org.eclipse.jubula.client.core.IAUTInfoListener;
import org.eclipse.jubula.client.core.agent.AutAgentRegistration;
import org.eclipse.jubula.client.core.commands.ConnectToAutResponseCommand;
import org.eclipse.jubula.client.core.communication.BaseConnection;
import org.eclipse.jubula.client.core.communication.ConnectionException;
import org.eclipse.jubula.client.core.communication.ServerConnection;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IObjectMappingProfilePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.communication.Communicator;
import org.eclipse.jubula.communication.ICommand;
import org.eclipse.jubula.communication.listener.ICommunicationErrorListener;
import org.eclipse.jubula.communication.message.ConnectToAutMessage;
import org.eclipse.jubula.communication.message.Message;
import org.eclipse.jubula.communication.message.SendCompSystemI18nMessage;
import org.eclipse.jubula.tools.exception.CommunicationException;
import org.eclipse.jubula.tools.exception.JBVersionException;
import org.eclipse.jubula.tools.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.registration.AutIdentifier;
import org.eclipse.jubula.tools.xml.businessmodell.Profile;
import org.eclipse.jubula.tools.xml.businessprocess.ProfileBuilder;

public class AUTConnection
extends BaseConnection {
    private static Log log = LogFactory.getLog(AUTConnection.class);
    private static AUTConnection instance = null;
    private AUTConnectionListener m_autConnectionListener = new AUTConnectionListener();
    private AutIdentifier m_connectedAutId;

    private AUTConnection() throws ConnectionException {
        try {
            Communicator communicator = new Communicator(0, this.getClass().getClassLoader());
            communicator.addCommunicationErrorListener((ICommunicationErrorListener)this.m_autConnectionListener);
            this.setCommunicator(communicator);
        }
        catch (IOException ioe) {
            this.handleInitError(ioe);
        }
        catch (SecurityException se) {
            this.handleInitError(se);
        }
    }

    private void disconnectFromAut() {
        this.m_connectedAutId = null;
    }

    private void handleInitError(Throwable throwable) throws ConnectionException {
        String message = String.valueOf(Messages.InitialisationOfAUTConnectionFailed) + ":" + " ";
        log.fatal((Object)message, throwable);
        throw new ConnectionException(String.valueOf(message) + throwable.getMessage(), MessageIDs.E_AUT_CONNECTION_INIT);
    }

    public static synchronized AUTConnection getInstance() throws ConnectionException {
        if (instance == null) {
            instance = new AUTConnection();
        }
        return instance;
    }

    public AutIdentifier getConnectedAutId() {
        return this.m_connectedAutId;
    }

    public synchronized void reset() {
        if (this.getCommunicator() != null) {
            this.getCommunicator().clearListeners();
        }
        this.getCommunicator().close();
        instance = null;
    }

    /*
     * Loose catch block
     */
    public boolean connectToAut(AutIdentifier autId, IProgressMonitor monitor) {
        block20: {
            if (!this.isConnected()) {
                block18: {
                    block19: {
                        block17: {
                            DataEventDispatcher.getInstance().fireAutServerConnectionChanged(DataEventDispatcher.ServerState.Connecting);
                            monitor.subTask(Messages.ConnectingToAUT);
                            log.info((Object)Messages.EstablishingConnectionToAUT);
                            this.run();
                            this.getCommunicator().addCommunicationErrorListener((ICommunicationErrorListener)this.m_autConnectionListener);
                            ConnectToAutResponseCommand responseCommand = new ConnectToAutResponseCommand();
                            ServerConnection.getInstance().getCommunicator().request((Message)new ConnectToAutMessage(InetAddress.getLocalHost().getCanonicalHostName(), this.getCommunicator().getLocalPort(), autId), (ICommand)responseCommand, 10000);
                            if (responseCommand.getMessage() == null || responseCommand.getMessage().getErrorMessage() == null) break block17;
                            DataEventDispatcher.getInstance().fireAutServerConnectionChanged(DataEventDispatcher.ServerState.Disconnected);
                            monitor.done();
                            return false;
                        }
                        long timeout = 10000L;
                        long startTime = System.currentTimeMillis();
                        while (!monitor.isCanceled() && !this.isConnected() && ServerConnection.getInstance().isConnected() && startTime + timeout > System.currentTimeMillis()) {
                            try {
                                Thread.sleep(200L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        if (!this.isConnected()) break block18;
                        this.m_connectedAutId = autId;
                        log.info((Object)(String.valueOf(Messages.ConnectionToAUTEstablished) + "."));
                        IAUTMainPO aut = AutAgentRegistration.getAutForId(autId, GeneralStorage.getInstance().getProject());
                        if (aut != null) {
                            this.getComponentsFromAut(aut);
                            this.sendResourceBundlesToAut();
                            break block19;
                        }
                        log.warn((Object)Messages.ErrorOccurredActivatingObjectMapping);
                    }
                    monitor.done();
                    return true;
                }
                try {
                    log.error((Object)(String.valueOf(Messages.ConnectionToAUTCouldNotBeEstablished) + "."));
                }
                catch (CommunicationException e) {
                    log.error((Object)(String.valueOf(Messages.ErrorOccurredEstablishingConnectionToAUT) + "."), (Throwable)e);
                    monitor.done();
                    break block20;
                }
                catch (UnknownHostException e) {
                    log.error((Object)(String.valueOf(Messages.ErrorOccurredEstablishingConnectionToAUT) + "."), (Throwable)e);
                    break block20;
                }
                catch (JBVersionException e) {
                    log.error((Object)(String.valueOf(Messages.ErrorOccurredEstablishingConnectionToAUT) + "."), (Throwable)e);
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    monitor.done();
                    break block20;
                }
                {
                    finally {
                        monitor.done();
                    }
                }
                monitor.done();
            } else {
                log.warn((Object)Messages.CannotEstablishNewConnectionToAUT);
            }
        }
        DataEventDispatcher.getInstance().fireAutServerConnectionChanged(DataEventDispatcher.ServerState.Disconnected);
        return false;
    }

    private void sendResourceBundlesToAut() {
        SendCompSystemI18nMessage i18nMessage = new SendCompSystemI18nMessage();
        i18nMessage.setResourceBundles(CompSystemI18n.bundlesToString());
        try {
            this.send((Message)i18nMessage);
        }
        catch (CommunicationException ce) {
            log.fatal((Object)Messages.CommunicationErrorWhileSettingResourceBundle, (Throwable)ce);
        }
    }

    private void getComponentsFromAut(IAUTMainPO aut) {
        Profile profile = new Profile();
        IObjectMappingProfilePO profilePo = aut.getObjMap().getProfile();
        profile.setNameFactor(profilePo.getNameFactor());
        profile.setPathFactor(profilePo.getPathFactor());
        profile.setContextFactor(profilePo.getContextFactor());
        profile.setThreshold(profilePo.getThreshold());
        ProfileBuilder.setActiveProfile((Profile)profile);
        IAUTInfoListener listener = new IAUTInfoListener(){

            public void error(int reason) {
                log.error((Object)(String.valueOf(Messages.ErrorOccurredWhileGettingComponentsFromAUT) + ":" + " " + reason));
            }
        };
        ClientTestFactory.getClientTest().getAllComponentsFromAUT(listener, 10000);
    }

    private class AUTConnectionListener
    implements ICommunicationErrorListener {
        private AUTConnectionListener() {
        }

        public void connectionGained(InetAddress inetAddress, int port) {
            if (log.isInfoEnabled()) {
                try {
                    String logMessage = String.valueOf(Messages.ConnectedTo) + inetAddress.getHostName() + ":" + String.valueOf(port);
                    log.info((Object)logMessage);
                }
                catch (SecurityException securityException) {
                    log.debug((Object)Messages.SecurityViolationGettingHostNameFromIP);
                }
            }
            ClientTestFactory.getClientTest().fireAUTServerStateChanged(new AUTServerEvent(1));
        }

        public void shutDown() {
            if (log.isInfoEnabled()) {
                log.info((Object)Messages.ConnectionToAUTServerClosed);
                log.info((Object)Messages.ClosingConnectionToTheAutStarter);
            }
            AUTConnection.this.disconnectFromAut();
            DataEventDispatcher.getInstance().fireAutServerConnectionChanged(DataEventDispatcher.ServerState.Disconnected);
            ClientTestFactory.getClientTest().fireAUTServerStateChanged(new AUTServerEvent(8));
            ClientTestFactory.getClientTest().fireAUTStateChanged(new AUTEvent(2));
            ClientTestFactory.getClientTest().fireAUTServerStateChanged(new AUTServerEvent(2));
        }

        public void sendFailed(Message message) {
            log.error((Object)(String.valueOf(Messages.SendingMessageFailed) + ":" + message.toString()));
            log.error((Object)Messages.ClosingConnectionToTheAUTServer);
            AUTConnection.this.close();
        }

        public void acceptingFailed(int port) {
            log.warn((Object)(String.valueOf(Messages.AcceptingFailed) + ":" + String.valueOf(port)));
        }

        public void connectingFailed(InetAddress inetAddress, int port) {
            StringBuilder msg = new StringBuilder();
            msg.append(Messages.ConnectingFailed);
            msg.append("(");
            msg.append(")");
            msg.append(" ");
            msg.append(Messages.CalledAlthoughThisIsServer);
            log.error((Object)msg.toString());
        }
    }
}

