/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.communication;

import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.communication.Communicator;
import org.eclipse.jubula.communication.ICommand;
import org.eclipse.jubula.communication.listener.ICommunicationErrorListener;
import org.eclipse.jubula.communication.message.Message;
import org.eclipse.jubula.tools.exception.CommunicationException;
import org.eclipse.jubula.tools.exception.JBVersionException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;

public abstract class BaseConnection {
    private static Log log = LogFactory.getLog(BaseConnection.class);
    private Communicator m_communicator;
    private boolean m_connected = false;

    protected BaseConnection() {
    }

    public synchronized Communicator getCommunicator() {
        return this.m_communicator;
    }

    protected synchronized void setCommunicator(Communicator communicator) {
        if (communicator == null) {
            throw new IllegalArgumentException(Messages.CommunicatorMustNotBeNull);
        }
        this.m_communicator = communicator;
        this.m_communicator.addCommunicationErrorListener((ICommunicationErrorListener)new CommunicationListener());
    }

    public synchronized void run() throws AlreadyConnectedException, JBVersionException {
        if (this.isConnected()) {
            log.error((Object)Messages.RunCalledToAnAlreadyConnectedConnection);
            throw new AlreadyConnectedException(Messages.ThisConnectionIsAlreadyConnected, MessageIDs.E_CONNECTED_CONNECTION);
        }
        this.m_communicator.run();
        if (log.isDebugEnabled()) {
            log.debug((Object)(String.valueOf(this.getClass().getName()) + ":" + " " + Messages.ConnectionEstablishedOnPort + ":" + " " + this.getCommunicator().getPort() + " " + Messages.AndLocalPort + ":" + " " + this.getCommunicator().getLocalPort()));
        }
    }

    public synchronized void send(Message message) throws IllegalArgumentException, NotConnectedException, CommunicationException {
        if (!this.isConnected()) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"send() called to an unconnected connection");
            }
            throw new NotConnectedException("This connection is not connected", MessageIDs.E_UNCONNECTED_CONNECTION);
        }
        this.m_communicator.send(message);
    }

    public synchronized void request(Message message, ICommand response, int timeout) throws NotConnectedException, CommunicationException {
        if (!this.isConnected()) {
            log.error((Object)"request() called to an unconnected connection");
            throw new NotConnectedException("This connection is not connected", MessageIDs.E_UNCONNECTED_CONNECTION);
        }
        this.m_communicator.request(message, response, timeout);
    }

    public void close() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("close() called on " + this.getClass().getName() + "on port: " + this.getCommunicator().getPort() + "and local port: " + this.getCommunicator().getLocalPort()));
        }
        if (!this.isConnected()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"close() called to an unconnected connection");
            }
        } else {
            this.m_communicator.close();
            this.setConnected(false);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("leaving close() f " + this.getClass().getName()));
        }
    }

    public synchronized boolean isConnected() {
        return this.m_connected;
    }

    private synchronized void setConnected(boolean connected) {
        this.m_connected = connected;
        if (log.isDebugEnabled()) {
            log.debug((Object)("setConnected() set to " + connected));
        }
    }

    public static class AlreadyConnectedException
    extends CommunicationException {
        public AlreadyConnectedException(String message, Integer id) {
            super(message, id);
        }
    }

    private class CommunicationListener
    implements ICommunicationErrorListener {
        private CommunicationListener() {
        }

        public void acceptingFailed(int port) {
            BaseConnection.this.setConnected(false);
        }

        public void connectingFailed(InetAddress inetAddress, int port) {
            BaseConnection.this.setConnected(false);
        }

        public void connectionGained(InetAddress inetAddress, int port) {
            BaseConnection.this.setConnected(true);
        }

        public void sendFailed(Message message) {
        }

        public void shutDown() {
            BaseConnection.this.setConnected(false);
        }
    }

    public static class NotConnectedException
    extends CommunicationException {
        public NotConnectedException(String message, Integer id) {
            super(message, id);
        }
    }
}

