/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.communication;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jubula.client.core.AutStarterEvent;
import org.eclipse.jubula.client.core.ClientTestFactory;
import org.eclipse.jubula.client.core.communication.AUTConnection;
import org.eclipse.jubula.client.core.communication.BaseConnection;
import org.eclipse.jubula.client.core.communication.ConnectionException;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.communication.Communicator;
import org.eclipse.jubula.communication.listener.ICommunicationErrorListener;
import org.eclipse.jubula.communication.message.Message;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;

public class ServerConnection
extends BaseConnection {
    private static Log log = LogFactory.getLog(ServerConnection.class);
    private static ServerConnection instance = null;

    private ServerConnection(InetAddress inetAddress, int port) {
        Communicator communicator = new Communicator(inetAddress, port, this.getClass().getClassLoader());
        this.setCommunicator(communicator);
    }

    protected synchronized void setCommunicator(Communicator communicator) {
        super.setCommunicator(communicator);
        communicator.addCommunicationErrorListener((ICommunicationErrorListener)new ServerConnectionListener());
    }

    public static synchronized void createInstance(String serverName, String port) throws ConnectionException {
        try {
            InetAddress inetAddress = InetAddress.getByName(serverName);
            instance = new ServerConnection(inetAddress, new Integer(port));
        }
        catch (UnknownHostException uhe) {
            log.info((Object)uhe);
            throw new ConnectionException(uhe.getMessage(), MessageIDs.E_UNKNOWN_HOST);
        }
    }

    public static synchronized ServerConnection getInstance() throws ConnectionException {
        if (instance == null) {
            String message = Messages.ServerConnectionIsNotInitialized;
            throw new ConnectionException(message, MessageIDs.E_NO_SERVER_CONNECTION_INIT);
        }
        return instance;
    }

    private class ServerConnectionListener
    implements ICommunicationErrorListener {
        private ServerConnectionListener() {
        }

        public void connectionGained(InetAddress inetAddress, int port) {
            if (log.isInfoEnabled()) {
                try {
                    String logMessage = String.valueOf(Messages.ConnectedTo) + " " + inetAddress.getHostName() + ":" + String.valueOf(port);
                    log.info((Object)logMessage);
                }
                catch (SecurityException securityException) {
                    log.debug((Object)Messages.SecurityViolationGettingHostNameFromIP);
                }
            }
            ClientTestFactory.getClientTest().fireAutStarterStateChanged(new AutStarterEvent(1));
        }

        public void shutDown() {
            log.info((Object)Messages.ConnectionToAUTAgentClosed);
            log.info((Object)Messages.ClosingConnectionToTheAUTServer);
            try {
                AUTConnection.getInstance().close();
                ClientTestFactory.getClientTest().fireAutStarterStateChanged(new AutStarterEvent(2));
            }
            catch (ConnectionException ce) {
                log.debug((Object)ce);
            }
        }

        public void sendFailed(Message message) {
            log.warn((Object)(String.valueOf(Messages.SendingMessageFailed) + ":" + message.toString()));
            log.info((Object)Messages.ClosingConnectionToTheAUTAgent);
            ServerConnection.this.close();
        }

        public void acceptingFailed(int port) {
            log.error((Object)(String.valueOf(Messages.AcceptingFailedCalledAlthoughThisIsClient) + ":" + String.valueOf(port)));
        }

        public void connectingFailed(InetAddress inetAddress, int port) {
            log.warn((Object)Messages.ConnectingTheAUTAgentFailed);
            ClientTestFactory.getClientTest().fireAutStarterStateChanged(new AutStarterEvent(3));
        }
    }
}

