/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.Collection;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.tools.xml.businessmodell.Component;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="COMP_NAME_PAIRS")
class CompNamesPairPO
implements ICompNamesPairPO,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject {
    private static transient Log log = LogFactory.getLog(CompNamesPairPO.class);
    private String m_firstName;
    private String m_secondName;
    private boolean m_propagated = false;
    private String m_type = "";
    private transient Long m_id = null;
    private Long m_parentProjectId = null;
    static final long serialVersionUID = -9083998198000251957L;
    protected transient Object _persistence_primaryKey;

    private CompNamesPairPO() {
    }

    CompNamesPairPO(String name, String type) {
        this(name, name, type);
    }

    CompNamesPairPO(String firstName, String secondName, String type) {
        Validate.notNull((Object)firstName, (String)Messages.TheFirstNameMustNotBeNull);
        Validate.notNull((Object)secondName, (String)Messages.TheSecondNameMustNotBeNull);
        this.setFirstName(firstName);
        this.setSecondName(secondName);
        this.setType(type);
    }

    private void setId(Long id) {
        this.m_id = id;
    }

    @Override
    @Id
    @GeneratedValue
    public Long getId() {
        return this.m_id;
    }

    @Override
    @Transient
    public Long getParentProjectId() {
        return this.getHbmParentProjectId();
    }

    @Override
    public void setParentProjectId(Long projectId) {
        this.setHbmParentProjectId(projectId);
    }

    @Basic
    @Column(name="PARENT_PROJ")
    Long getHbmParentProjectId() {
        return this.m_parentProjectId;
    }

    void setHbmParentProjectId(Long projectId) {
        this.m_parentProjectId = projectId;
    }

    @Override
    @Transient
    public String getName() {
        return this.getFirstName();
    }

    @Override
    @Basic
    @Column(name="PROPAGATED")
    public boolean isPropagated() {
        return this.m_propagated;
    }

    @Override
    public void setPropagated(boolean propagated) {
        this.m_propagated = propagated;
    }

    @Override
    public void setFirstName(String firstName) {
        this.m_firstName = firstName;
    }

    @Override
    @Basic
    @Column(name="FIRST_NAME", length=4000)
    public String getFirstName() {
        return this.m_firstName;
    }

    @Override
    @Basic
    @Column(name="SECOND_NAME", length=4000)
    public String getSecondName() {
        return this.m_secondName;
    }

    @Override
    public void setSecondName(String secondName) {
        this.m_secondName = secondName;
    }

    @Override
    public boolean areNamesEqual() {
        return StringUtils.equals((String)this.getFirstName(), (String)this.getSecondName());
    }

    @Override
    @Transient
    public String getType() {
        if (this.m_type == null) {
            this.m_type = "";
        }
        return this.m_type;
    }

    @Override
    public void setType(String type) {
        this.m_type = type;
    }

    @Override
    public void changeCompName(String oldCompNameGuid, String newCompNameGuid) {
        this.setSecondName(newCompNameGuid);
    }

    @Override
    public String getComponentType(IWritableComponentNameCache compNameCache, Collection<Component> availableComponents) {
        IComponentNamePO compNamePo = compNameCache.getCompNamePo(this.getFirstName());
        if (compNamePo == null) {
            StringBuilder msg = new StringBuilder();
            msg.append(Messages.CouldNotFindComponentNameWithGUID);
            msg.append(" ");
            msg.append("(");
            msg.append(this.getFirstName());
            msg.append(")");
            msg.append(" ");
            msg.append(Messages.WhileTryingToIdentifyItsType);
            msg.append(".");
            log.info((Object)msg.toString());
            return null;
        }
        return compNamePo.getComponentType();
    }

    @Override
    @Transient
    public Integer getVersion() {
        return 0;
    }

    public Object _persistence_post_clone() {
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new CompNamesPairPO();
    }

    public Object _persistence_get(String string) {
        if (string == "id") {
            return this.id;
        }
        if (string == "hbmParentProjectId") {
            return this.hbmParentProjectId;
        }
        if (string == "secondName") {
            return this.secondName;
        }
        if (string == "propagated") {
            return this.propagated;
        }
        if (string == "firstName") {
            return this.firstName;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "id") {
            this.id = (Long)object;
            return;
        }
        if (string == "hbmParentProjectId") {
            this.hbmParentProjectId = (Long)object;
            return;
        }
        if (string == "secondName") {
            this.secondName = (String)object;
            return;
        }
        if (string == "propagated") {
            this.propagated = (Boolean)object;
            return;
        }
        if (string == "firstName") {
            this.firstName = (String)object;
            return;
        }
    }
}

