/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.Iterator;
import org.eclipse.jubula.client.core.model.AUTConfigPO;
import org.eclipse.jubula.client.core.model.AUTMainPO;
import org.eclipse.jubula.client.core.model.CategoryPO;
import org.eclipse.jubula.client.core.model.ExecTestCasePO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.NodePO;
import org.eclipse.jubula.client.core.model.SpecTestCasePO;
import org.eclipse.jubula.client.core.persistence.ISpecPersistable;
import org.eclipse.jubula.client.core.persistence.NodePM;

public class IdGenerator {
    private static long id = 0L;

    private IdGenerator() {
    }

    public static void generate(IProjectPO project) {
        id = 0L;
        for (ISpecPersistable specPers : project.getSpecObjCont().getSpecObjList()) {
            if (specPers instanceof CategoryPO) {
                CategoryPO catPO = (CategoryPO)specPers;
                IdGenerator.setID(catPO);
            }
            if (!(specPers instanceof SpecTestCasePO)) continue;
            SpecTestCasePO specTcPO = (SpecTestCasePO)specPers;
            IdGenerator.setID(specTcPO);
        }
        for (IAUTMainPO aut : project.getAutMainList()) {
            AUTMainPO autMainPO = (AUTMainPO)aut;
            autMainPO.setId(id++);
            for (AUTConfigPO aUTConfigPO : aut.getAutConfigSet()) {
                aUTConfigPO.setId(id++);
            }
        }
    }

    private static void setID(CategoryPO catPO) {
        catPO.setId(id++);
        Iterator<INodePO> nodeIter = catPO.getNodeListIterator();
        while (nodeIter.hasNext()) {
            NodePO nodePO = (NodePO)nodeIter.next();
            if (nodePO instanceof CategoryPO) {
                IdGenerator.setID((CategoryPO)nodePO);
                continue;
            }
            if (!(nodePO instanceof SpecTestCasePO)) continue;
            IdGenerator.setID((SpecTestCasePO)nodePO);
        }
    }

    private static void setID(SpecTestCasePO specTcPO) {
        specTcPO.setId(id++);
        for (ExecTestCasePO execTestCasePO : NodePM.getInternalExecTestCases(specTcPO.getGuid(), specTcPO.getParentProjectId())) {
            execTestCasePO.setId(id++);
        }
    }
}

