/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderColumn;
import javax.persistence.Transient;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jubula.client.core.businessprocess.ProjectNameBP;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.AUTContPO;
import org.eclipse.jubula.client.core.model.DocAttributeDescriptionPO;
import org.eclipse.jubula.client.core.model.IAUTContPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IDocAttributeDescriptionPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IProjectPropertiesPO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ISpecObjContPO;
import org.eclipse.jubula.client.core.model.ITestDataCubeContPO;
import org.eclipse.jubula.client.core.model.ITestJobContPO;
import org.eclipse.jubula.client.core.model.ITestSuiteContPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.LanguageHelper;
import org.eclipse.jubula.client.core.model.ParamNodePO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.model.ProjectPropertiesPO;
import org.eclipse.jubula.client.core.model.SpecObjContPO;
import org.eclipse.jubula.client.core.model.TestDataCubeContPO;
import org.eclipse.jubula.client.core.model.TestJobContPO;
import org.eclipse.jubula.client.core.model.TestSuiteContPO;
import org.eclipse.jubula.client.core.persistence.HibernateUtil;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@DiscriminatorValue(value="P")
class ProjectPO
extends ParamNodePO
implements IProjectPO,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedLazy {
    private static Log log = LogFactory.getLog(ProjectPO.class);
    private ProjectPropertiesPO m_projectProperties = null;
    private AUTContPO m_autCont = null;
    private TestSuiteContPO m_testSuiteCont;
    private TestJobContPO m_testJobCont;
    private SpecObjContPO m_specObjCont = null;
    private Integer m_clientMetaDataVersion = null;
    private List<IDocAttributeDescriptionPO> m_projectAttributeDescriptions = new ArrayList<IDocAttributeDescriptionPO>();
    private List<IDocAttributeDescriptionPO> m_testCaseAttributeDescriptions = new ArrayList<IDocAttributeDescriptionPO>();
    private List<IDocAttributeDescriptionPO> m_testSuiteAttributeDescriptions = new ArrayList<IDocAttributeDescriptionPO>();
    private TestDataCubeContPO m_testdatacubecont;
    static final long serialVersionUID = 6497531734906717650L;
    protected WeavedAttributeValueHolderInterface _persistence_hbmTestJobContPO_vh;
    protected WeavedAttributeValueHolderInterface _persistence_hbmTestSuiteCont_vh;
    protected WeavedAttributeValueHolderInterface _persistence_hbmAutCont_vh;
    protected WeavedAttributeValueHolderInterface _persistence_hbmSpecObjCont_vh;

    ProjectPO() {
    }

    ProjectPO(String name, Integer metadataVersion, boolean isGenerated) {
        this(metadataVersion, 1, 0, HibernateUtil.generateGuid(), isGenerated);
        ProjectNameBP.getInstance().setName(this.getGuid(), name, false);
    }

    ProjectPO(Integer metadataVersion, Integer majorNumber, Integer minorNumber, String guid, boolean isGenerated) {
        super("dummy", guid, isGenerated);
        this.init(metadataVersion, majorNumber, minorNumber);
    }

    private void init(Integer metadataVersion, Integer majorNumber, Integer minorNumber) {
        this.setProjectProperties(PoMaker.createProjectPropertiesPO(majorNumber, minorNumber));
        this.setAutCont(PoMaker.createAUTContPO());
        this.setTestSuiteCont(PoMaker.createTestSuiteContPO());
        this.setTestJobContPO(PoMaker.createTestJobContPO());
        this.setTestDataCubeContPO(PoMaker.createTestDataCubeContPO());
        this.setSpecObjCont(PoMaker.createSpecObjContPO());
        this.setClientMetaDataVersion(metadataVersion);
    }

    @Override
    @Transient
    public Set<IAUTMainPO> getAutMainList() {
        return Collections.unmodifiableSet(this.getHbmAutCont().getAutMainList());
    }

    @Override
    public void addAUTMain(IAUTMainPO aut) {
        this.getHbmAutCont().addAUTMain(aut);
    }

    @Override
    public void removeAUTMain(IAUTMainPO aut) {
        this.getHbmAutCont().removeAUTMain(aut);
        List<ITestSuitePO> tsList = this.getTestSuiteCont().getTestSuiteList();
        for (ITestSuitePO ts : tsList) {
            if (aut != ts.getAut()) continue;
            ts.setAut(null);
        }
    }

    @Override
    @Transient
    public Locale getDefaultLanguage() {
        return this.m_projectProperties.getDefaultLanguage();
    }

    @Override
    public void setDefaultLanguage(Locale defaultLanguage) {
        this.m_projectProperties.setDefaultLanguage(defaultLanguage);
    }

    @Override
    @Transient
    public ISpecObjContPO getSpecObjCont() {
        return this.getHbmSpecObjCont();
    }

    private void setSpecObjCont(ISpecObjContPO specObjCont) {
        this.setHbmSpecObjCont((SpecObjContPO)specObjCont);
        this.getHbmSpecObjCont().setParentProjectId(this.getId());
    }

    private void setAutCont(IAUTContPO autCont) {
        this.setHbmAutCont((AUTContPO)autCont);
    }

    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="SPECOBJ_CONT", unique=true)
    private SpecObjContPO getHbmSpecObjCont() {
        this._persistence_initialize_hbmSpecObjCont_vh();
        if (!this._persistence_hbmSpecObjCont_vh.isInstantiated()) {
            this.setHbmSpecObjCont((SpecObjContPO)this._persistence_hbmSpecObjCont_vh.getValue());
        }
        return this.m_specObjCont;
    }

    private void setHbmSpecObjCont(SpecObjContPO specObjCont) {
        this.m_specObjCont = specObjCont;
        this._persistence_initialize_hbmSpecObjCont_vh();
        this._persistence_hbmSpecObjCont_vh.setValue((Object)specObjCont);
        this._persistence_hbmSpecObjCont_vh.setIsCoordinatedWithProperty(true);
    }

    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="AUT_CONT", unique=true)
    private AUTContPO getHbmAutCont() {
        this._persistence_initialize_hbmAutCont_vh();
        if (!this._persistence_hbmAutCont_vh.isInstantiated()) {
            this.setHbmAutCont((AUTContPO)this._persistence_hbmAutCont_vh.getValue());
        }
        return this.m_autCont;
    }

    private void setHbmAutCont(AUTContPO autCont) {
        this.m_autCont = autCont;
        this._persistence_initialize_hbmAutCont_vh();
        this._persistence_hbmAutCont_vh.setValue((Object)autCont);
        this._persistence_hbmAutCont_vh.setIsCoordinatedWithProperty(true);
    }

    @Override
    @Transient
    public IAUTContPO getAutCont() {
        return this.getHbmAutCont();
    }

    @Override
    @Transient
    public ITestSuiteContPO getTestSuiteCont() {
        return this.getHbmTestSuiteCont();
    }

    private void setTestSuiteCont(ITestSuiteContPO testSuiteCont) {
        this.setHbmTestSuiteCont((TestSuiteContPO)testSuiteCont);
        this.getHbmTestSuiteCont().setParentProjectId(this.getId());
    }

    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="TS_CONT", unique=true)
    private TestSuiteContPO getHbmTestSuiteCont() {
        this._persistence_initialize_hbmTestSuiteCont_vh();
        if (!this._persistence_hbmTestSuiteCont_vh.isInstantiated()) {
            this.setHbmTestSuiteCont((TestSuiteContPO)this._persistence_hbmTestSuiteCont_vh.getValue());
        }
        return this.m_testSuiteCont;
    }

    private void setHbmTestSuiteCont(TestSuiteContPO testSuiteCont) {
        this.m_testSuiteCont = testSuiteCont;
        this._persistence_initialize_hbmTestSuiteCont_vh();
        this._persistence_hbmTestSuiteCont_vh.setValue((Object)testSuiteCont);
        this._persistence_hbmTestSuiteCont_vh.setIsCoordinatedWithProperty(true);
    }

    @Override
    @Transient
    public ITestJobContPO getTestJobCont() {
        return this.getHbmTestJobContPO();
    }

    public void setTestJobContPO(ITestJobContPO tjc) {
        this.setHbmTestJobContPO((TestJobContPO)tjc);
        this.getHbmTestJobContPO().setParentProjectId(this.getId());
    }

    public void setTestDataCubeContPO(ITestDataCubeContPO tdcc) {
        this.setHbmTestDataCubeContPO((TestDataCubeContPO)tdcc);
        this.getHbmTestDataCubeContPO().setParentProjectId(this.getId());
    }

    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="TJ_CONT", unique=true)
    private TestJobContPO getHbmTestJobContPO() {
        this._persistence_initialize_hbmTestJobContPO_vh();
        if (!this._persistence_hbmTestJobContPO_vh.isInstantiated()) {
            this.setHbmTestJobContPO((TestJobContPO)this._persistence_hbmTestJobContPO_vh.getValue());
        }
        return this.m_testJobCont;
    }

    private void setHbmTestJobContPO(TestJobContPO testJobCont) {
        this.m_testJobCont = testJobCont;
        this._persistence_initialize_hbmTestJobContPO_vh();
        this._persistence_hbmTestJobContPO_vh.setValue((Object)testJobCont);
        this._persistence_hbmTestJobContPO_vh.setIsCoordinatedWithProperty(true);
    }

    @Override
    @Basic
    @Column(name="CONF_MAJ_VERS")
    public Integer getClientMetaDataVersion() {
        return this.m_clientMetaDataVersion;
    }

    @Override
    public void setClientMetaDataVersion(Integer metaDataVersion) {
        this.m_clientMetaDataVersion = metaDataVersion;
    }

    @Override
    @Transient
    public Set<IReusedProjectPO> getUsedProjects() {
        return Collections.unmodifiableSet(this.getProjectProperties().getUsedProjects());
    }

    @Override
    @Transient
    public Integer getMajorProjectVersion() {
        return this.getProjectProperties().getMajorNumber();
    }

    @Override
    @Transient
    public Integer getMinorProjectVersion() {
        return this.getProjectProperties().getMinorNumber();
    }

    @Override
    @Transient
    public boolean getIsReusable() {
        return this.getProjectProperties().getIsReusable();
    }

    @Override
    public void setIsReusable(boolean isReusable) {
        this.getProjectProperties().setIsReusable(isReusable);
    }

    @Override
    @Transient
    public boolean getIsProtected() {
        return this.getProjectProperties().getIsProtected();
    }

    @Override
    public void setIsProtected(boolean isProtected) {
        this.getProjectProperties().setIsProtected(isProtected);
    }

    @Override
    public void addUsedProject(IReusedProjectPO reusedProject) {
        this.getProjectProperties().addUsedProject(reusedProject);
    }

    @Override
    public void removeUsedProject(IReusedProjectPO project) {
        this.getProjectProperties().removeUsedProject(project);
    }

    @Override
    protected void setParentProjectIdForChildNode(INodePO childNode) {
        childNode.setParentProjectId(this.getId());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IProjectPO) {
            IProjectPO proj = (IProjectPO)obj;
            return new EqualsBuilder().append((Object)this.getGuid(), (Object)proj.getGuid()).append((Object)this.getMajorProjectVersion(), (Object)proj.getMajorProjectVersion()).append((Object)this.getMinorProjectVersion(), (Object)proj.getMinorProjectVersion()).isEquals();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getGuid()).append((Object)this.getMajorProjectVersion()).append((Object)this.getMinorProjectVersion()).toHashCode();
    }

    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="PROJECT_PROPERTIES", unique=true)
    public ProjectPropertiesPO getProperties() {
        return this.m_projectProperties;
    }

    private void setProperties(ProjectPropertiesPO properties) {
        this.m_projectProperties = properties;
    }

    private void setProjectProperties(IProjectPropertiesPO properties) {
        this.setProperties((ProjectPropertiesPO)properties);
        if (this.getProjectProperties() != null) {
            this.getProjectProperties().setParentProjectId(this.getId());
        }
    }

    @Override
    @Transient
    public IProjectPropertiesPO getProjectProperties() {
        return this.getProperties();
    }

    @Override
    @Transient
    public LanguageHelper getLangHelper() {
        return this.getProjectProperties().getLangHelper();
    }

    @Override
    @Transient
    public String getToolkit() {
        return this.getProjectProperties().getToolkit();
    }

    @Override
    public void setToolkit(String toolkit) {
        this.getProjectProperties().setToolkit(toolkit);
    }

    @Override
    public void clearUsedProjects() {
        this.getProjectProperties().clearUsedProjects();
    }

    @Override
    @Transient
    public String getDisplayName() {
        StringBuffer sb = new StringBuffer(this.getName());
        sb.append("_").append(this.getVersionString());
        return sb.toString();
    }

    @Override
    @Transient
    public String getName() {
        return ProjectNameBP.getInstance().getName(this.getGuid());
    }

    @Override
    public void setName(String name) {
        log.debug((Object)Messages.SetNameNotSupportedOnProjectPO);
    }

    @Override
    public void setParentProjectId(Long projectId) {
        if (this.getProjectProperties() != null) {
            this.getProjectProperties().setParentProjectId(projectId);
        }
        if (this.getHbmAutCont() != null) {
            this.getHbmAutCont().setParentProjectId(projectId);
        }
        if (this.getHbmSpecObjCont() != null) {
            this.getHbmSpecObjCont().setParentProjectId(projectId);
        }
        if (this.getHbmTestSuiteCont() != null) {
            this.getHbmTestSuiteCont().setParentProjectId(projectId);
        }
        if (this.getHbmTestJobContPO() != null) {
            this.getHbmTestJobContPO().setParentProjectId(projectId);
        }
        if (this.getHbmTestDataCubeContPO() != null) {
            this.getHbmTestDataCubeContPO().setParentProjectId(projectId);
        }
    }

    @Override
    @Transient
    public String getVersionString() {
        StringBuffer sb = new StringBuffer(String.valueOf(this.getMajorProjectVersion()));
        sb.append(".").append(this.getMinorProjectVersion());
        return sb.toString();
    }

    @Override
    @Transient
    public Boolean isReused() {
        return true;
    }

    @ManyToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, targetEntity=DocAttributeDescriptionPO.class)
    @JoinTable(name="P_DOC_ATTR_DESC_LIST", joinColumns={@JoinColumn(name="DOC_ATTR_DESC")}, inverseJoinColumns={@JoinColumn(name="PROJECT")})
    @OrderColumn(name="IDX")
    List<IDocAttributeDescriptionPO> getHbmProjectAttributeDescriptions() {
        return this.m_projectAttributeDescriptions;
    }

    void setHbmProjectAttributeDescriptions(List<IDocAttributeDescriptionPO> projectAttributeDescriptions) {
        this.m_projectAttributeDescriptions = projectAttributeDescriptions;
    }

    @ManyToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, targetEntity=DocAttributeDescriptionPO.class)
    @JoinTable(name="TC_DOC_ATTR_DESC_LIST", joinColumns={@JoinColumn(name="DOC_ATTR_DESC")}, inverseJoinColumns={@JoinColumn(name="PROJECT")})
    @OrderColumn(name="IDX")
    List<IDocAttributeDescriptionPO> getHbmTestCaseAttributeDescriptions() {
        return this.m_testCaseAttributeDescriptions;
    }

    void setHbmTestCaseAttributeDescriptions(List<IDocAttributeDescriptionPO> testCaseAttributeDescriptions) {
        this.m_testCaseAttributeDescriptions = testCaseAttributeDescriptions;
    }

    @ManyToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, targetEntity=DocAttributeDescriptionPO.class)
    @JoinTable(name="TS_DOC_ATTR_DESC_LIST", joinColumns={@JoinColumn(name="DOC_ATTR_DESC")}, inverseJoinColumns={@JoinColumn(name="PROJECT")})
    @OrderColumn(name="IDX")
    List<IDocAttributeDescriptionPO> getHbmTestSuiteAttributeDescriptions() {
        return this.m_testSuiteAttributeDescriptions;
    }

    void setHbmTestSuiteAttributeDescriptions(List<IDocAttributeDescriptionPO> testSuiteAttributeDescriptions) {
        this.m_testSuiteAttributeDescriptions = testSuiteAttributeDescriptions;
    }

    @Override
    public void addProjectAttributeDescription(IDocAttributeDescriptionPO attrDesc) {
        this.getHbmProjectAttributeDescriptions().remove(attrDesc);
        this.getHbmProjectAttributeDescriptions().add(attrDesc);
    }

    @Override
    public void addTestCaseAttributeDescription(IDocAttributeDescriptionPO attrDesc) {
        this.getHbmTestCaseAttributeDescriptions().remove(attrDesc);
        this.getHbmTestCaseAttributeDescriptions().add(attrDesc);
    }

    @Override
    public void addTestSuiteAttributeDescription(IDocAttributeDescriptionPO attrDesc) {
        this.getTestSuiteAttributeDescriptions().remove(attrDesc);
        this.getTestSuiteAttributeDescriptions().add(attrDesc);
    }

    @Override
    public void removeProjectAttributeDescription(IDocAttributeDescriptionPO attrDesc) {
        this.getHbmProjectAttributeDescriptions().remove(attrDesc);
    }

    @Override
    public void removeTestCaseAttributeDescription(IDocAttributeDescriptionPO attrDesc) {
        this.getTestCaseAttributeDescriptions().remove(attrDesc);
    }

    @Override
    public void removeTestSuiteAttributeDescription(IDocAttributeDescriptionPO attrDesc) {
        this.getTestSuiteAttributeDescriptions().remove(attrDesc);
    }

    @Override
    @Transient
    public List<IDocAttributeDescriptionPO> getProjectAttributeDescriptions() {
        return Collections.unmodifiableList(this.getHbmProjectAttributeDescriptions());
    }

    @Override
    @Transient
    public List<IDocAttributeDescriptionPO> getTestCaseAttributeDescriptions() {
        return Collections.unmodifiableList(this.getHbmTestCaseAttributeDescriptions());
    }

    @Override
    @Transient
    public List<IDocAttributeDescriptionPO> getTestSuiteAttributeDescriptions() {
        return Collections.unmodifiableList(this.getHbmTestSuiteAttributeDescriptions());
    }

    @Override
    @Transient
    public ITestDataCubeContPO getTestDataCubeCont() {
        return this.getHbmTestDataCubeContPO();
    }

    private void setHbmTestDataCubeContPO(TestDataCubeContPO tdcc) {
        this.m_testdatacubecont = tdcc;
    }

    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="TDC_CONT", unique=true)
    private TestDataCubeContPO getHbmTestDataCubeContPO() {
        return this.m_testdatacubecont;
    }

    @Override
    public void setTestResultCleanupInterval(int noOfDays) {
        this.getProjectProperties().setTestResultCleanupInterval(noOfDays);
    }

    @Override
    @Transient
    public Integer getTestResultCleanupInterval() {
        return this.getProjectProperties().getTestResultCleanupInterval();
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_hbmTestJobContPO_vh != null) {
            this._persistence_hbmTestJobContPO_vh = (WeavedAttributeValueHolderInterface)this._persistence_hbmTestJobContPO_vh.clone();
        }
        if (this._persistence_hbmTestSuiteCont_vh != null) {
            this._persistence_hbmTestSuiteCont_vh = (WeavedAttributeValueHolderInterface)this._persistence_hbmTestSuiteCont_vh.clone();
        }
        if (this._persistence_hbmAutCont_vh != null) {
            this._persistence_hbmAutCont_vh = (WeavedAttributeValueHolderInterface)this._persistence_hbmAutCont_vh.clone();
        }
        if (this._persistence_hbmSpecObjCont_vh != null) {
            this._persistence_hbmSpecObjCont_vh = (WeavedAttributeValueHolderInterface)this._persistence_hbmSpecObjCont_vh.clone();
        }
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ProjectPO();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "hbmTestSuiteAttributeDescriptions") {
            return this.hbmTestSuiteAttributeDescriptions;
        }
        if (string == "hbmTestJobContPO") {
            return this.hbmTestJobContPO;
        }
        if (string == "hbmTestSuiteCont") {
            return this.hbmTestSuiteCont;
        }
        if (string == "hbmProjectAttributeDescriptions") {
            return this.hbmProjectAttributeDescriptions;
        }
        if (string == "hbmAutCont") {
            return this.hbmAutCont;
        }
        if (string == "hbmTestDataCubeContPO") {
            return this.hbmTestDataCubeContPO;
        }
        if (string == "properties") {
            return this.properties;
        }
        if (string == "clientMetaDataVersion") {
            return this.clientMetaDataVersion;
        }
        if (string == "hbmSpecObjCont") {
            return this.hbmSpecObjCont;
        }
        if (string == "hbmTestCaseAttributeDescriptions") {
            return this.hbmTestCaseAttributeDescriptions;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "hbmTestSuiteAttributeDescriptions") {
            this.hbmTestSuiteAttributeDescriptions = (List)object;
            return;
        }
        if (string == "hbmTestJobContPO") {
            this.hbmTestJobContPO = (TestJobContPO)object;
            return;
        }
        if (string == "hbmTestSuiteCont") {
            this.hbmTestSuiteCont = (TestSuiteContPO)object;
            return;
        }
        if (string == "hbmProjectAttributeDescriptions") {
            this.hbmProjectAttributeDescriptions = (List)object;
            return;
        }
        if (string == "hbmAutCont") {
            this.hbmAutCont = (AUTContPO)object;
            return;
        }
        if (string == "hbmTestDataCubeContPO") {
            this.hbmTestDataCubeContPO = (TestDataCubeContPO)object;
            return;
        }
        if (string == "properties") {
            this.properties = (ProjectPropertiesPO)object;
            return;
        }
        if (string == "clientMetaDataVersion") {
            this.clientMetaDataVersion = (Integer)object;
            return;
        }
        if (string == "hbmSpecObjCont") {
            this.hbmSpecObjCont = (SpecObjContPO)object;
            return;
        }
        if (string == "hbmTestCaseAttributeDescriptions") {
            this.hbmTestCaseAttributeDescriptions = (List)object;
            return;
        }
        super._persistence_set(string, object);
    }

    protected void _persistence_initialize_hbmTestJobContPO_vh() {
        if (this._persistence_hbmTestJobContPO_vh == null) {
            this._persistence_hbmTestJobContPO_vh = new ValueHolder();
            this._persistence_hbmTestJobContPO_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_hbmTestJobContPO_vh() {
        TestJobContPO testJobContPO;
        this._persistence_initialize_hbmTestJobContPO_vh();
        if ((this._persistence_hbmTestJobContPO_vh.isCoordinatedWithProperty() || this._persistence_hbmTestJobContPO_vh.isNewlyWeavedValueHolder()) && (testJobContPO = this.getHbmTestJobContPO()) != this._persistence_hbmTestJobContPO_vh.getValue()) {
            this.setHbmTestJobContPO(testJobContPO);
        }
        return this._persistence_hbmTestJobContPO_vh;
    }

    public void _persistence_set_hbmTestJobContPO_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        Object object;
        TestJobContPO testJobContPO;
        this._persistence_hbmTestJobContPO_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated() && (testJobContPO = this.getHbmTestJobContPO()) != (object = weavedAttributeValueHolderInterface.getValue())) {
            this.setHbmTestJobContPO((TestJobContPO)object);
        }
    }

    protected void _persistence_initialize_hbmTestSuiteCont_vh() {
        if (this._persistence_hbmTestSuiteCont_vh == null) {
            this._persistence_hbmTestSuiteCont_vh = new ValueHolder();
            this._persistence_hbmTestSuiteCont_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_hbmTestSuiteCont_vh() {
        TestSuiteContPO testSuiteContPO;
        this._persistence_initialize_hbmTestSuiteCont_vh();
        if ((this._persistence_hbmTestSuiteCont_vh.isCoordinatedWithProperty() || this._persistence_hbmTestSuiteCont_vh.isNewlyWeavedValueHolder()) && (testSuiteContPO = this.getHbmTestSuiteCont()) != this._persistence_hbmTestSuiteCont_vh.getValue()) {
            this.setHbmTestSuiteCont(testSuiteContPO);
        }
        return this._persistence_hbmTestSuiteCont_vh;
    }

    public void _persistence_set_hbmTestSuiteCont_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        Object object;
        TestSuiteContPO testSuiteContPO;
        this._persistence_hbmTestSuiteCont_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated() && (testSuiteContPO = this.getHbmTestSuiteCont()) != (object = weavedAttributeValueHolderInterface.getValue())) {
            this.setHbmTestSuiteCont((TestSuiteContPO)object);
        }
    }

    protected void _persistence_initialize_hbmAutCont_vh() {
        if (this._persistence_hbmAutCont_vh == null) {
            this._persistence_hbmAutCont_vh = new ValueHolder();
            this._persistence_hbmAutCont_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_hbmAutCont_vh() {
        AUTContPO aUTContPO;
        this._persistence_initialize_hbmAutCont_vh();
        if ((this._persistence_hbmAutCont_vh.isCoordinatedWithProperty() || this._persistence_hbmAutCont_vh.isNewlyWeavedValueHolder()) && (aUTContPO = this.getHbmAutCont()) != this._persistence_hbmAutCont_vh.getValue()) {
            this.setHbmAutCont(aUTContPO);
        }
        return this._persistence_hbmAutCont_vh;
    }

    public void _persistence_set_hbmAutCont_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        Object object;
        AUTContPO aUTContPO;
        this._persistence_hbmAutCont_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated() && (aUTContPO = this.getHbmAutCont()) != (object = weavedAttributeValueHolderInterface.getValue())) {
            this.setHbmAutCont((AUTContPO)object);
        }
    }

    protected void _persistence_initialize_hbmSpecObjCont_vh() {
        if (this._persistence_hbmSpecObjCont_vh == null) {
            this._persistence_hbmSpecObjCont_vh = new ValueHolder();
            this._persistence_hbmSpecObjCont_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_hbmSpecObjCont_vh() {
        SpecObjContPO specObjContPO;
        this._persistence_initialize_hbmSpecObjCont_vh();
        if ((this._persistence_hbmSpecObjCont_vh.isCoordinatedWithProperty() || this._persistence_hbmSpecObjCont_vh.isNewlyWeavedValueHolder()) && (specObjContPO = this.getHbmSpecObjCont()) != this._persistence_hbmSpecObjCont_vh.getValue()) {
            this.setHbmSpecObjCont(specObjContPO);
        }
        return this._persistence_hbmSpecObjCont_vh;
    }

    public void _persistence_set_hbmSpecObjCont_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        Object object;
        SpecObjContPO specObjContPO;
        this._persistence_hbmSpecObjCont_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated() && (specObjContPO = this.getHbmSpecObjCont()) != (object = weavedAttributeValueHolderInterface.getValue())) {
            this.setHbmSpecObjCont((SpecObjContPO)object);
        }
    }
}

