/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.eclipse.jubula.client.core.model.ITestSuiteContPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.TestSuitePO;
import org.eclipse.jubula.client.core.model.WrapperPO;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="SUITE_CONT")
public class TestSuiteContPO
extends WrapperPO
implements ITestSuiteContPO,
PersistenceWeaved,
PersistenceObject {
    private List<ITestSuitePO> m_testSuiteList;
    static final long serialVersionUID = 4668167312135180013L;

    TestSuiteContPO() {
        this.m_testSuiteList = new ArrayList<ITestSuitePO>();
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, targetEntity=TestSuitePO.class)
    @OrderColumn(name="IDX")
    List<ITestSuitePO> getHbmTestSuiteList() {
        return this.m_testSuiteList;
    }

    @Override
    @Transient
    public List<ITestSuitePO> getTestSuiteList() {
        return Collections.unmodifiableList(this.m_testSuiteList);
    }

    void setHbmTestSuiteList(List<ITestSuitePO> testSuiteList) {
        this.m_testSuiteList = testSuiteList;
    }

    @Override
    @Transient
    public String getName() {
        return "TestSuiteContPO";
    }

    @Override
    public void addTestSuite(ITestSuitePO ts) {
        this.addTestSuite(-1, ts);
    }

    @Override
    public void addTestSuite(int position, ITestSuitePO ts) {
        if (position < 0 || position > this.getHbmTestSuiteList().size()) {
            this.getHbmTestSuiteList().add(ts);
        } else {
            this.getHbmTestSuiteList().add(position, ts);
        }
        ts.setParentProjectId(this.getParentProjectId());
    }

    @Override
    public void removeTestSuite(ITestSuitePO ts) {
        this.getHbmTestSuiteList().remove(ts);
        ts.setParentNode(null);
    }

    @Override
    public void setParentProjectId(Long projectId) {
        super.setParentProjectId(projectId);
        for (ITestSuitePO ts : this.getHbmTestSuiteList()) {
            ts.setParentProjectId(projectId);
        }
    }

    @Override
    @Transient
    public Long getParentProjectId() {
        return super.getParentProjectId();
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new TestSuiteContPO(persistenceObject);
    }

    public TestSuiteContPO(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "hbmTestSuiteList") {
            return this.hbmTestSuiteList;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "hbmTestSuiteList") {
            this.hbmTestSuiteList = (List)object;
            return;
        }
        super._persistence_set(string, object);
    }
}

