/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.persistence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ITestCasePO;

public class HibernateUtil {
    private HibernateUtil() {
    }

    public static Predicate getExpressionDisjunction(Collection expressionList, Path property, CriteriaBuilder criteriaBuilder) {
        ArrayList<CriteriaBuilder.In> expressionCollections = new ArrayList<CriteriaBuilder.In>();
        CriteriaBuilder.In currentSet = criteriaBuilder.in((Expression)property);
        int count = 1000;
        for (Object expression : expressionList) {
            if (count >= 1000) {
                currentSet = criteriaBuilder.in((Expression)property);
                expressionCollections.add(currentSet);
                count = 0;
            }
            currentSet.value(expression);
            ++count;
        }
        return criteriaBuilder.or(expressionCollections.toArray(new Predicate[expressionCollections.size()]));
    }

    public static Class getClass(Object persistenceProxy) {
        return persistenceProxy.getClass();
    }

    public static String generateGuid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static void removeChildNodes(INodePO node, EntityManager sess) {
        for (INodePO child : node.getUnmodifiableNodeList()) {
            HibernateUtil.removeChildNodes(child, sess);
            sess.remove((Object)child);
        }
        node.removeAllNodes();
        if (node instanceof ITestCasePO) {
            ITestCasePO testCase = (ITestCasePO)node;
            for (IEventExecTestCasePO eventHandler : testCase.getAllEventEventExecTC()) {
                sess.remove((Object)eventHandler);
            }
            testCase.getEventExecTcMap().clear();
        }
    }
}

