/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.persistence;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jubula.client.core.businessprocess.progress.OperationCanceledUtil;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IParamNamePO;
import org.eclipse.jubula.client.core.persistence.AbstractNamePM;
import org.eclipse.jubula.client.core.persistence.Hibernator;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PersistenceManager;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParamNamePM
extends AbstractNamePM {
    private static Log log = LogFactory.getLog(ParamNamePM.class);

    private ParamNamePM() {
    }

    public static final synchronized IParamNamePO readParamNamePO(String guid, Long rootProjId) throws PMException {
        IParamNamePO paramName = null;
        EntityManager s = null;
        try {
            try {
                s = Hibernator.instance().openSession();
                Query q = s.createQuery("select p from ParamNamePO as p where p.hbmGuid = :guid AND p.parentProjectId = :projId");
                q.setParameter("guid", (Object)guid);
                q.setParameter("projId", (Object)rootProjId);
                paramName = (IParamNamePO)q.getSingleResult();
            }
            catch (NoResultException noResultException) {
                Hibernator.instance().dropSessionWithoutLockRelease(s);
            }
            catch (PersistenceException e) {
                PersistenceManager.handleDBExceptionForAnySession(paramName, e, s);
                Hibernator.instance().dropSessionWithoutLockRelease(s);
            }
        }
        finally {
            Hibernator.instance().dropSessionWithoutLockRelease(s);
        }
        return paramName;
    }

    public static final synchronized List<IParamNamePO> readAllParamNames(Long parentProjectId) throws PMException {
        List paramNames;
        block5: {
            EntityManager s = null;
            paramNames = null;
            try {
                try {
                    s = Hibernator.instance().openSession();
                    Query q = s.createQuery("select paramName from ParamNamePO as paramName where paramName.parentProjectId = :parentProjId");
                    q.setParameter("parentProjId", (Object)parentProjectId);
                    paramNames = q.getResultList();
                }
                catch (PersistenceException e) {
                    OperationCanceledUtil.checkForOperationCanceled((RuntimeException)((Object)e));
                    log.fatal((Object)Messages.CouldNotReadParameterNamesFromDB, (Throwable)e);
                    PersistenceManager.handleDBExceptionForAnySession(null, e, s);
                    Hibernator.instance().dropSessionWithoutLockRelease(s);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Hibernator.instance().dropSessionWithoutLockRelease(s);
                throw throwable;
            }
            Hibernator.instance().dropSessionWithoutLockRelease(s);
        }
        return paramNames != null ? paramNames : new ArrayList(0);
    }

    public static final void deleteParamNames(EntityManager s, Long parentProjectId, boolean commit) throws PMException, ProjectDeletedException {
        try {
            if (commit) {
                EntityTransaction tx = Hibernator.instance().getTransaction(s);
                ParamNamePM.executeDeleteStatement(s, parentProjectId);
                Hibernator.instance().commitTransaction(s, tx);
            } else {
                ParamNamePM.executeDeleteStatement(s, parentProjectId);
            }
        }
        catch (PersistenceException e) {
            String msg = Messages.DeletionOfParamNamePOsFailed;
            log.error((Object)msg, (Throwable)e);
            throw new PMException(msg, MessageIDs.E_DB_SAVE);
        }
    }

    private static synchronized void executeDeleteStatement(EntityManager s, Long parentProjectId) {
        Query q = s.createQuery("delete from ParamNamePO p where p.parentProjectId = :parentProjId");
        q.setParameter("parentProjId", (Object)parentProjectId);
        q.executeUpdate();
    }
}

