/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.DocAttributeDescriptionBP;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.INameMapper;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBP;
import org.eclipse.jubula.client.core.businessprocess.ProjectNameBP;
import org.eclipse.jubula.client.core.businessprocess.UsedToolkitBP;
import org.eclipse.jubula.client.core.businessprocess.progress.OperationCanceledUtil;
import org.eclipse.jubula.client.core.businessprocess.progress.ProgressMonitorTracker;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IDocAttributeDescriptionPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectNamePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.CompNamePM;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.HibernateUtil;
import org.eclipse.jubula.client.core.persistence.Hibernator;
import org.eclipse.jubula.client.core.persistence.ISpecPersistable;
import org.eclipse.jubula.client.core.persistence.IncompatibleTypeException;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMDirtyVersionException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMExtProjDeletedException;
import org.eclipse.jubula.client.core.persistence.PMReadException;
import org.eclipse.jubula.client.core.persistence.PMSaveException;
import org.eclipse.jubula.client.core.persistence.ParamNamePM;
import org.eclipse.jubula.client.core.persistence.PersistenceManager;
import org.eclipse.jubula.toolkit.common.businessprocess.ToolkitSupportBP;
import org.eclipse.jubula.toolkit.common.exception.ToolkitPluginException;
import org.eclipse.jubula.toolkit.common.utils.ToolkitUtils;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.jarutils.IVersion;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectPM
extends PersistenceManager {
    private static final int NUM_HBM_ADD_PROGRESS_EVENT_TYPES = 4;
    private static Log log = LogFactory.getLog(ProjectPM.class);

    private ProjectPM() {
    }

    public static synchronized List<IProjectPO> findAllProjects() throws JBException {
        ProjectNameBP.getInstance().clearCache();
        EntityManager session = null;
        try {
            session = Hibernator.instance().openSession();
            List<IProjectPO> list = ProjectPM.findAllProjects(session);
            return list;
        }
        catch (PersistenceException e) {
            log.error((Object)Messages.HibernateLoadFailed, (Throwable)e);
            throw new JBException(e.getMessage(), MessageIDs.E_HIBERNATE_LOAD_FAILED);
        }
        finally {
            Hibernator.instance().dropSessionWithoutLockRelease(session);
        }
    }

    public static synchronized List<IProjectPO> findAllProjects(EntityManager sess) throws PersistenceException {
        Query query = sess.createQuery("select project from ProjectPO as project where project.clientMetaDataVersion = :majorversion");
        query.setParameter("majorversion", (Object)IVersion.JB_CLIENT_METADATA_VERSION);
        return query.getResultList();
    }

    public static synchronized IProjectPO loadProjectByGuidAndVersion(String guid, int majorVersion, int minorVersion) throws JBException {
        EntityManager session = null;
        try {
            session = Hibernator.instance().openSession();
            Query query = session.createQuery("select project from ProjectPO as project inner join fetch project.properties where project.guid = :guid and project.properties.majorNumber = :majorNumber and project.properties.minorNumber = :minorNumber");
            query.setParameter("guid", (Object)guid);
            query.setParameter("majorNumber", (Object)majorVersion);
            query.setParameter("minorNumber", (Object)minorVersion);
            try {
                IProjectPO project = (IProjectPO)query.getSingleResult();
                UsedToolkitBP.getInstance().readUsedToolkitsFromDB(project);
                IProjectPO iProjectPO = project;
                return iProjectPO;
            }
            catch (NoResultException noResultException) {
                try {
                    Hibernator.instance().dropSessionWithoutLockRelease(session);
                    return null;
                }
                catch (PersistenceException e) {
                    OperationCanceledException oce = ProjectPM.checkForCancel(e);
                    if (oce != null) {
                        throw oce;
                    }
                    log.error((Object)Messages.HibernateLoadFailed, (Throwable)e);
                    throw new JBException(e.getMessage(), MessageIDs.E_HIBERNATE_LOAD_FAILED);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Hibernator.instance().dropSessionWithoutLockRelease(session);
        }
    }

    public static synchronized IProjectPO loadProjectByNameAndVersion(String name, int majorVersion, int minorVersion) throws JBException {
        EntityManager session = null;
        String guid = "";
        try {
            session = Hibernator.instance().openSession();
            Query query = session.createQuery("select name.hbmGuid from ProjectNamePO as name where name.hbmName = :name");
            query.setParameter("name", (Object)name);
            try {
                guid = (String)query.getSingleResult();
            }
            catch (NoResultException noResultException) {
                Hibernator.instance().dropSessionWithoutLockRelease(session);
                return null;
            }
        }
        catch (PersistenceException e) {
            log.error((Object)Messages.HibernateLoadFailed, (Throwable)e);
            throw new JBException(e.getMessage(), MessageIDs.E_HIBERNATE_LOAD_FAILED);
        }
        finally {
            Hibernator.instance().dropSessionWithoutLockRelease(session);
        }
        return ProjectPM.loadProjectByGuidAndVersion(guid, majorVersion, minorVersion);
    }

    public static synchronized IProjectPO loadLatestVersionOfProjectByName(String name) throws JBException {
        EntityManager session = null;
        String guid = "";
        int majorVersion = 0;
        int minorVersion = 0;
        try {
            session = Hibernator.instance().openSession();
            Query query = session.createQuery("select project.hbmGuid from ProjectNamePO as project where project.hbmName = :name");
            query.setParameter("name", (Object)name);
            try {
                guid = (String)query.getSingleResult();
            }
            catch (NoResultException noResultException) {
                Hibernator.instance().dropSessionWithoutLockRelease(session);
                return null;
            }
            try {
                String versionNumber = ProjectPM.findHighestVersionNumber(guid);
                int index = versionNumber.indexOf(46);
                majorVersion = Integer.parseInt(versionNumber.substring(0, index));
                minorVersion = Integer.parseInt(versionNumber.substring(index + 1));
            }
            catch (NumberFormatException nfe) {
                log.error((Object)Messages.InvalidProjectVersionNumber, (Throwable)nfe);
                throw new JBException(nfe.getMessage(), MessageIDs.E_INVALID_PROJECT_VERSION);
            }
            catch (PersistenceException e) {
                log.error((Object)Messages.HibernateLoadFailed, (Throwable)e);
                throw new JBException(e.getMessage(), MessageIDs.E_HIBERNATE_LOAD_FAILED);
            }
        }
        finally {
            Hibernator.instance().dropSessionWithoutLockRelease(session);
        }
        return ProjectPM.loadProjectByGuidAndVersion(guid, majorVersion, minorVersion);
    }

    public static synchronized IProjectPO loadProject(IReusedProjectPO reused) throws JBException {
        EntityManager session = null;
        try {
            session = Hibernator.instance().openSession();
            Query query = session.createQuery("select project from ProjectPO as project inner join fetch project.properties where project.guid = :guid and project.properties.majorNumber = :majorNumber and project.properties.minorNumber = :minorNumber");
            query.setParameter("guid", (Object)reused.getProjectGuid());
            query.setParameter("majorNumber", (Object)reused.getMajorNumber());
            query.setParameter("minorNumber", (Object)reused.getMinorNumber());
            try {
                IProjectPO iProjectPO = (IProjectPO)query.getSingleResult();
                return iProjectPO;
            }
            catch (NoResultException noResultException) {
                try {
                    Hibernator.instance().dropSessionWithoutLockRelease(session);
                    return null;
                }
                catch (PersistenceException e) {
                    OperationCanceledUtil.checkForOperationCanceled((RuntimeException)((Object)e));
                    log.error((Object)Messages.HibernateLoadFailed, (Throwable)e);
                    throw new JBException(e.getMessage(), MessageIDs.E_HIBERNATE_LOAD_FAILED);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Hibernator.instance().dropSessionWithoutLockRelease(session);
        }
    }

    public static synchronized IProjectPO loadReusedProjectInMasterSession(IReusedProjectPO reused) throws JBException {
        EntityManager masterSession = GeneralStorage.getInstance().getMasterSession();
        try {
            Query query = masterSession.createQuery("select project from ProjectPO project inner join fetch project.properties where project.guid = :guid and project.properties.majorNumber = :majorNumber and project.properties.minorNumber = :minorNumber");
            query.setParameter("guid", (Object)reused.getProjectGuid());
            query.setParameter("majorNumber", (Object)reused.getMajorNumber());
            query.setParameter("minorNumber", (Object)reused.getMinorNumber());
            IProjectPO project = null;
            try {
                project = (IProjectPO)query.getSingleResult();
            }
            catch (NoResultException noResultException) {}
            ParamNameBP.getInstance().initParamNamesOfReusedProject(reused);
            UsedToolkitBP.getInstance().readUsedToolkitsFromDB(project);
            return project;
        }
        catch (PersistenceException e) {
            log.error((Object)Messages.HibernateLoadFailed, (Throwable)e);
            throw new JBException(e.getMessage(), MessageIDs.E_HIBERNATE_LOAD_FAILED);
        }
    }

    public static synchronized IProjectPO loadReusedProject(IReusedProjectPO reusedProjectInfo) throws JBException {
        EntityManager session = null;
        try {
            session = Hibernator.instance().openSession();
            IProjectPO iProjectPO = ProjectPM.loadReusedProject(reusedProjectInfo, session);
            return iProjectPO;
        }
        catch (PersistenceException e) {
            log.error((Object)Messages.HibernateLoadFailed, (Throwable)e);
            throw new JBException(e.getMessage(), MessageIDs.E_HIBERNATE_LOAD_FAILED);
        }
        finally {
            Hibernator.instance().dropSessionWithoutLockRelease(session);
        }
    }

    public static synchronized IProjectPO loadReusedProject(IReusedProjectPO reusedProjectInfo, EntityManager session) throws JBException {
        try {
            Query query = session.createQuery("select project from ProjectPO project inner join fetch project.properties where project.guid = :guid and project.properties.majorNumber = :major and project.properties.minorNumber = :minor");
            query.setParameter("guid", (Object)reusedProjectInfo.getProjectGuid());
            query.setParameter("major", (Object)reusedProjectInfo.getMajorNumber());
            query.setParameter("minor", (Object)reusedProjectInfo.getMinorNumber());
            try {
                return (IProjectPO)query.getSingleResult();
            }
            catch (NoResultException noResultException) {
                return null;
            }
        }
        catch (PersistenceException e) {
            log.error((Object)Messages.HibernateLoadFailed, (Throwable)e);
            throw new JBException(e.getMessage(), MessageIDs.E_HIBERNATE_LOAD_FAILED);
        }
    }

    public static final synchronized Long findProjectId(String projGuid, Integer projMajVers, Integer projMinVers) throws JBException {
        EntityManager session = null;
        try {
            session = Hibernator.instance().openSession();
            Query query = session.createQuery("select project.id from ProjectPO project inner join fetch project.properties where project.guid = :guid and project.properties.majorNumber = :major and project.properties.minorNumber = :minor");
            query.setParameter("guid", (Object)projGuid);
            query.setParameter("major", (Object)projMajVers);
            query.setParameter("minor", (Object)projMinVers);
            try {
                Long l = (Long)query.getSingleResult();
                return l;
            }
            catch (NoResultException noResultException) {
                try {
                    Hibernator.instance().dropSessionWithoutLockRelease(session);
                    return null;
                }
                catch (PersistenceException e) {
                    log.error((Object)Messages.HibernateLoadFailed, (Throwable)e);
                    throw new JBException(e.getMessage(), MessageIDs.E_HIBERNATE_LOAD_FAILED);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Hibernator.instance().dropSessionWithoutLockRelease(session);
        }
    }

    public static final synchronized List<IReusedProjectPO> loadReusedProjects(String projGuid, Integer projMajVers, Integer projMinVers) throws JBException {
        return ProjectPM.loadReusedProjects(ProjectPM.findProjectId(projGuid, projMajVers, projMinVers));
    }

    public static final List<IReusedProjectPO> loadReusedProjects(Long projectId) throws JBException {
        EntityManager session = null;
        ArrayList<IReusedProjectPO> list = new ArrayList<IReusedProjectPO>();
        try {
            try {
                if (projectId != null) {
                    session = Hibernator.instance().openSession();
                    Query query = session.createQuery("select reusedProj from ReusedProjectPO reusedProj where reusedProj.hbmParentProjectId = :parentProjId");
                    query.setParameter("parentProjId", (Object)projectId);
                    list.addAll(query.getResultList());
                }
            }
            catch (PersistenceException e) {
                log.error((Object)Messages.HibernateLoadFailed, (Throwable)e);
                throw new JBException(e.getMessage(), MessageIDs.E_HIBERNATE_LOAD_FAILED);
            }
        }
        catch (Throwable throwable) {
            Hibernator.instance().dropSessionWithoutLockRelease(session);
            throw throwable;
        }
        Hibernator.instance().dropSessionWithoutLockRelease(session);
        return list;
    }

    public static void loadProjectInROSession(IProjectPO project) throws PMReadException {
        GeneralStorage.getInstance().reset();
        EntityManager s = GeneralStorage.getInstance().getMasterSession();
        try {
            ProjectPM.preloadData(s, project);
            IProjectPO p = (IProjectPO)s.find(NodeMaker.getProjectPOClass(), (Object)project.getId());
            GeneralStorage.getInstance().setProject(p);
            ParamNameBP.getInstance().initMap();
            ComponentNamesBP.getInstance().init();
        }
        catch (PersistenceException e) {
            GeneralStorage.getInstance().setProject(null);
            OperationCanceledException cancel = ProjectPM.checkForCancel(e);
            if (cancel != null) {
                throw cancel;
            }
            String msg = String.valueOf(Messages.CantReadProjectFromDatabase) + ".";
            log.error((Object)(String.valueOf(Messages.UnexpectedPersistenceErrorIgnored) + "."), (Throwable)e);
            throw new PMReadException(String.valueOf(msg) + e.getMessage(), MessageIDs.E_CANT_READ_PROJECT);
        }
        catch (PMException e) {
            String msg = String.valueOf(Messages.CouldNotReadParamNamesFromDB) + ".";
            log.error((Object)msg, (Throwable)((Object)e));
            throw new PMReadException(String.valueOf(msg) + e.getMessage(), MessageIDs.E_CANT_READ_PROJECT);
        }
        catch (JBException e) {
            GeneralStorage.getInstance().setProject(null);
            String msg = String.valueOf(Messages.CantReadProjectFromDatabase) + ".";
            log.error((Object)Messages.UnexpectedPersistenceErrorIgnored, (Throwable)e);
            throw new PMReadException(String.valueOf(msg) + e.getMessage(), MessageIDs.E_CANT_READ_PROJECT);
        }
    }

    private static OperationCanceledException checkForCancel(PersistenceException e) {
        Throwable cause = e.getCause();
        while (cause != null) {
            if (cause instanceof OperationCanceledException) {
                return (OperationCanceledException)cause;
            }
            cause = cause.getCause();
        }
        return null;
    }

    private static void findReusedProjects(Set<Long> reused, Set<IReusedProjectPO> check) throws JBException {
        for (IReusedProjectPO ru : check) {
            IProjectPO ruP = ProjectPM.loadProject(ru);
            if (ruP == null || !reused.add(ruP.getId())) continue;
            ProjectPM.findReusedProjects(reused, ruP.getProjectProperties().getUsedProjects());
        }
    }

    private static void preloadData(EntityManager s, IProjectPO key) throws JBException {
        HashSet<Long> projectIds = new HashSet<Long>(17);
        projectIds.add(key.getId());
        ProjectPM.findReusedProjects(projectIds, key.getProjectProperties().getUsedProjects());
        ProjectPM.preloadDataPerClass(s, projectIds, "TestDataPO");
        ProjectPM.preloadDataPerClass(s, projectIds, "DataSetPO");
        ProjectPM.preloadDataPerClass(s, projectIds, "TDManagerPO");
        ProjectPM.preloadDataPerClass(s, projectIds, "CompNamesPairPO");
        ProjectPM.preloadDataPerClass(s, projectIds, "ComponentNamePO");
        ProjectPM.preloadDataPerClass(s, projectIds, "CompIdentifierPO");
        ProjectPM.preloadDataPerClass(s, projectIds, "AUTConfigPO");
        ProjectPM.preloadDataPerClass(s, projectIds, "AUTMainPO");
        ProjectPM.preloadDataPerClass(s, projectIds, "ObjectMappingPO");
        ProjectPM.preloadDataPerClass(s, projectIds, "ReusedProjectPO");
        ProjectPM.preloadDataPerClass(s, projectIds, "UsedToolkitPO");
        ProjectPM.preloadDataPerClass(s, projectIds, "AUTContPO");
        List nodes = ProjectPM.preloadDataPerClass(s, projectIds, "NodePO");
        ProjectPM.preloadDataPerClass(s, projectIds, "SpecObjContPO");
        ProjectPM.preloadDataPerClass(s, projectIds, "TestDataCubeContPO");
        ProjectPM.preloadDataPerClass(s, projectIds, "TestJobContPO");
        ProjectPM.preloadDataPerClass(s, projectIds, "TestSuiteContPO");
        ProjectPM.preloadDataPerClass(s, projectIds, "ObjectMappingAssoziationPO");
        ProjectPM.preloadDataPerClass(s, projectIds, "ParamDescriptionPO");
        HashSet<INodePO> exTC = new HashSet<INodePO>();
        HashMap<String, INodePO> sTc = new HashMap<String, INodePO>();
        for (INodePO iNodePO : nodes) {
            if (iNodePO instanceof ISpecTestCasePO) {
                sTc.put(iNodePO.getGuid(), iNodePO);
                continue;
            }
            if (!(iNodePO instanceof IExecTestCasePO)) continue;
            exTC.add(iNodePO);
        }
        for (IExecTestCasePO iExecTestCasePO : exTC) {
            ISpecTestCasePO spec = (ISpecTestCasePO)sTc.get(iExecTestCasePO.getSpecTestCaseGuid());
            if (spec == null) continue;
            iExecTestCasePO.setCachedSpecTestCase(spec);
        }
    }

    private static List preloadDataPerClass(EntityManager s, Set projectIds, String simpleClassName) {
        StringBuilder qString = new StringBuilder(100);
        qString.append("select node from ");
        qString.append(simpleClassName);
        qString.append(" as node where node.hbmParentProjectId in :ids");
        Query q = s.createQuery(qString.toString());
        q.setParameter("ids", (Object)projectIds);
        return q.getResultList();
    }

    /*
     * Exception decompiling
     */
    public static void attachProjectToROSession(IProjectPO proj, String newProjectName, List<INameMapper> mapperList, List<IWritableComponentNameMapper> compNameBindingList, IProgressMonitor monitor) throws PMException, ProjectDeletedException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void handleAlreadyLockedException(List<INameMapper> mapperList, EntityManager s, EntityTransaction tx) throws PMException {
        if (tx != null) {
            Hibernator.instance().rollbackTransaction(s, tx);
        }
        GeneralStorage.getInstance().reset();
        for (INameMapper mapper : mapperList) {
            mapper.clearAllNames();
        }
        String msg = String.valueOf(Messages.CantAttachProject) + ".";
        throw new PMSaveException(msg, MessageIDs.E_OBJECT_IN_USE);
    }

    private static void handleIncompatibleTypeException(List<INameMapper> mapperList, EntityManager s, EntityTransaction tx, IncompatibleTypeException ite) throws PMException, PMSaveException {
        if (tx != null) {
            Hibernator.instance().rollbackTransaction(s, tx);
        }
        GeneralStorage.getInstance().reset();
        for (INameMapper mapper : mapperList) {
            mapper.clearAllNames();
        }
        String msg = "Can't attach project. ";
        throw new PMSaveException(String.valueOf(msg) + ite.getMessage(), MessageIDs.E_ATTACH_PROJECT);
    }

    private static void handlePersistenceException(List<INameMapper> mapperList, EntityManager s, EntityTransaction tx, PersistenceException e) throws PMException, InterruptedException, PMSaveException {
        if (tx != null) {
            Hibernator.instance().rollbackTransaction(s, tx);
        }
        if (e.getCause() instanceof InterruptedException) {
            GeneralStorage.getInstance().reset();
            for (INameMapper mapper : mapperList) {
                mapper.clearAllNames();
            }
            throw new InterruptedException();
        }
        String msg = String.valueOf(Messages.CantAttachProject) + ".";
        throw new PMSaveException(String.valueOf(msg) + e.getMessage(), MessageIDs.E_ATTACH_PROJECT);
    }

    private static void handleOperationCanceled(List<INameMapper> mapperList, EntityManager s, EntityTransaction tx) throws PMException, InterruptedException {
        if (tx != null) {
            Hibernator.instance().rollbackTransaction(s, tx);
        }
        GeneralStorage.getInstance().reset();
        for (INameMapper mapper : mapperList) {
            mapper.clearAllNames();
        }
        throw new InterruptedException();
    }

    private static void initBPs(IProjectPO proj) throws PMException, ProjectDeletedException, PMSaveException {
        try {
            ComponentNamesBP.getInstance().init();
            ParamNameBP.getInstance().initMap();
        }
        catch (PMException e) {
            throw new PMException(String.valueOf(Messages.ReadingOfProjectNameOrParamNamesFailed) + ":" + " " + e.toString(), MessageIDs.E_ATTACH_PROJECT);
        }
        try {
            UsedToolkitBP.getInstance().refreshToolkitInfo(proj);
        }
        catch (PMException e) {
            throw new PMSaveException(String.valueOf(Messages.PMExceptionWhileWritingUsedToolkitsInDB) + ":" + " " + e.toString(), MessageIDs.E_ATTACH_PROJECT);
        }
    }

    public static void initAttributes(IProjectPO proj) {
        for (IDocAttributeDescriptionPO docAttrDesc : proj.getProjectAttributeDescriptions()) {
            if (proj.getDocAttributeTypes().contains(docAttrDesc)) continue;
            proj.setDocAttribute(docAttrDesc, PoMaker.createDocAttribute(docAttrDesc));
        }
    }

    public static void initAttributeDescriptions(EntityManager s, IProjectPO proj) {
        IDocAttributeDescriptionPO[] descArray;
        IDocAttributeDescriptionPO[] iDocAttributeDescriptionPOArray = descArray = DocAttributeDescriptionBP.initProjectAttributeDescriptions(s);
        int n = descArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDocAttributeDescriptionPO desc = iDocAttributeDescriptionPOArray[n2];
            proj.addProjectAttributeDescription(desc);
            ++n2;
        }
    }

    private static void setHbmProgressMonitor(IProgressMonitor monitor) {
        ProgressMonitorTracker.getInstance().setProgressMonitor(monitor);
    }

    public static void saveProject(IProjectPO proj, String newProjectName, List<INameMapper> mapperList, List<IWritableComponentNameMapper> compNameBindingList) throws PMException, ProjectDeletedException, InterruptedException {
        EntityManager saveSession = Hibernator.instance().openSession();
        EntityTransaction tx = null;
        try {
            try {
                tx = Hibernator.instance().getTransaction(saveSession);
                ProjectPM.refreshDocAttributes(proj, saveSession);
                saveSession.persist((Object)proj);
                proj.setParentProjectId(proj.getId());
                saveSession.flush();
                if (newProjectName != null) {
                    ProjectNameBP.getInstance().setName(saveSession, proj.getGuid(), newProjectName);
                }
                ProjectNameBP.getInstance().storeTransientNames(saveSession);
                for (INameMapper iNameMapper : mapperList) {
                    iNameMapper.persist(saveSession, proj.getId());
                }
                for (IWritableComponentNameMapper iWritableComponentNameMapper : compNameBindingList) {
                    CompNamePM.flushCompNames(saveSession, proj.getId(), iWritableComponentNameMapper);
                }
                Hibernator.instance().commitTransaction(saveSession, tx);
                for (INameMapper iNameMapper : mapperList) {
                    iNameMapper.updateStandardMapperAndCleanup(proj.getId());
                }
                for (IComponentNameMapper iComponentNameMapper : compNameBindingList) {
                    iComponentNameMapper.getCompNameCache().updateStandardMapperAndCleanup(proj.getId());
                }
            }
            catch (PersistenceException persistenceException) {
                if (tx != null) {
                    Hibernator.instance().rollbackTransaction(saveSession, tx);
                }
                if (persistenceException.getCause() instanceof InterruptedException) {
                    throw new InterruptedException();
                }
                String msg = String.valueOf(Messages.CantSaveProject) + ".";
                throw new PMSaveException(String.valueOf(msg) + persistenceException.getMessage(), MessageIDs.E_ATTACH_PROJECT);
            }
            catch (IncompatibleTypeException incompatibleTypeException) {
                if (tx != null) {
                    Hibernator.instance().rollbackTransaction(saveSession, tx);
                }
                String msg = String.valueOf(Messages.CantSaveProject) + ".";
                throw new PMSaveException(String.valueOf(msg) + incompatibleTypeException.getMessage(), MessageIDs.E_ATTACH_PROJECT);
            }
        }
        finally {
            Hibernator.instance().dropSession(saveSession);
        }
    }

    private static void refreshDocAttributes(IProjectPO proj, EntityManager saveSession) {
        for (IDocAttributeDescriptionPO desc : proj.getProjectAttributeDescriptions()) {
            saveSession.refresh((Object)desc);
        }
        for (IDocAttributeDescriptionPO desc : proj.getTestCaseAttributeDescriptions()) {
            saveSession.refresh((Object)desc);
        }
        for (IDocAttributeDescriptionPO desc : proj.getTestSuiteAttributeDescriptions()) {
            saveSession.refresh((Object)desc);
        }
    }

    public static synchronized boolean doesProjectNameExist(String name) {
        Long hits;
        block8: {
            EntityManager session = null;
            hits = null;
            try {
                session = Hibernator.instance().openSession();
                Query q = session.createQuery("select name from ProjectNamePO as name where name.hbmName = :name");
                q.setParameter("name", (Object)name);
                IProjectNamePO namePO = (IProjectNamePO)q.getSingleResult();
                if (namePO != null) {
                    q = session.createQuery("select count(project.id) from ProjectPO project where project.guid = :guid");
                    q.setParameter("guid", (Object)namePO.getGuid());
                    hits = (Long)q.getSingleResult();
                }
            }
            catch (NoResultException noResultException) {
                Hibernator.instance().dropSessionWithoutLockRelease(session);
                return false;
            }
            catch (PersistenceException e) {
                try {
                    log.error((Object)Messages.HibernateLoadFailed, (Throwable)e);
                    break block8;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    Hibernator.instance().dropSessionWithoutLockRelease(session);
                }
            }
            Hibernator.instance().dropSessionWithoutLockRelease(session);
        }
        return hits != null && hits.intValue() > 0;
    }

    public static synchronized boolean doesProjectVersionExist(String guid, Integer majorNumber, Integer minorNumber) {
        Long hits;
        block5: {
            EntityManager session = null;
            hits = null;
            try {
                try {
                    session = Hibernator.instance().openSession();
                    Query q = session.createQuery("select count(project) from ProjectPO as project inner join project.properties properties where project.guid = :guid and properties.majorNumber = :majorNumber and properties.minorNumber = :minorNumber");
                    q.setParameter("guid", (Object)guid);
                    q.setParameter("majorNumber", (Object)majorNumber);
                    q.setParameter("minorNumber", (Object)minorNumber);
                    hits = (Long)q.getSingleResult();
                }
                catch (PersistenceException e) {
                    log.error((Object)Messages.HibernateLoadFailed, (Throwable)e);
                    Hibernator.instance().dropSessionWithoutLockRelease(session);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Hibernator.instance().dropSessionWithoutLockRelease(session);
                throw throwable;
            }
            Hibernator.instance().dropSessionWithoutLockRelease(session);
        }
        return hits != null && hits.intValue() > 0;
    }

    public static synchronized boolean doesTestSuiteExists(Long projectId, String name) {
        List hits;
        block5: {
            EntityManager session = null;
            hits = null;
            try {
                try {
                    session = Hibernator.instance().openSession();
                    Query q = session.createQuery("select node from TestSuitePO as node where node.hbmName = ?1 and node.hbmParentProjectId = ?2");
                    q.setParameter(1, (Object)name);
                    q.setParameter(2, (Object)projectId);
                    hits = q.getResultList();
                }
                catch (PersistenceException e) {
                    log.error((Object)Messages.HibernateLoadFailed, (Throwable)e);
                    Hibernator.instance().dropSessionWithoutLockRelease(session);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Hibernator.instance().dropSessionWithoutLockRelease(session);
                throw throwable;
            }
            Hibernator.instance().dropSessionWithoutLockRelease(session);
        }
        return hits != null && hits.size() > 0;
    }

    public static synchronized boolean doesTestJobExists(Long projectId, String name) {
        List hits;
        block5: {
            EntityManager session = null;
            hits = null;
            try {
                try {
                    session = Hibernator.instance().openSession();
                    Query q = session.createQuery("select node from TestJobPO as node where node.hbmName = ?1 and node.hbmParentProjectId = ?2");
                    q.setParameter(1, (Object)name);
                    q.setParameter(2, (Object)projectId);
                    hits = q.getResultList();
                }
                catch (PersistenceException e) {
                    log.error((Object)Messages.HibernateLoadFailed, (Throwable)e);
                    Hibernator.instance().dropSessionWithoutLockRelease(session);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Hibernator.instance().dropSessionWithoutLockRelease(session);
                throw throwable;
            }
            Hibernator.instance().dropSessionWithoutLockRelease(session);
        }
        return hits != null && hits.size() > 0;
    }

    public static void deleteProject(IProjectPO proj, boolean isActProject) throws PMDirtyVersionException, PMAlreadyLockedException, PMExtProjDeletedException, ProjectDeletedException, JBException, InterruptedException {
        block12: {
            Validate.notNull((Object)proj, (String)"Project to delete is null");
            EntityManager deleteSess = null;
            IProjectPO p = null;
            Long projId = proj.getId();
            try {
                EntityManager s;
                IProjectPO currProj;
                if (isActProject && (currProj = (IProjectPO)(s = GeneralStorage.getInstance().getMasterSession()).find(NodeMaker.getProjectPOClass(), (Object)projId, LockModeType.READ)) == null) {
                    throw new ProjectDeletedException(Messages.ProjectWasDeleted, MessageIDs.E_CURRENT_PROJ_DEL);
                }
            }
            catch (PersistenceException e) {
                ProjectPM.handleDBExceptionForMasterSession(proj, e);
            }
            try {
                try {
                    deleteSess = Hibernator.instance().openSession();
                    EntityTransaction tx = Hibernator.instance().getTransaction(deleteSess);
                    p = (IProjectPO)deleteSess.find(NodeMaker.getProjectPOClass(), (Object)projId);
                    if (p == null) {
                        if (isActProject) {
                            throw new ProjectDeletedException("Current Project was deleted", MessageIDs.E_CURRENT_PROJ_DEL);
                        }
                        throw new PMExtProjDeletedException(String.valueOf(Messages.ProjectWasDeleted) + ".", MessageIDs.E_DELETED_OBJECT);
                    }
                    Hibernator.instance().lockPO(deleteSess, p);
                    ProjectPM.deleteProjectIndependentDBObjects(deleteSess, p);
                    ArrayList<ISpecPersistable> specObjList = new ArrayList<ISpecPersistable>(p.getSpecObjCont().getSpecObjList());
                    ArrayList<ITestSuitePO> testSuiteList = new ArrayList<ITestSuitePO>(p.getTestSuiteCont().getTestSuiteList());
                    for (ISpecPersistable iSpecPersistable : specObjList) {
                        HibernateUtil.removeChildNodes(iSpecPersistable, deleteSess);
                        p.getSpecObjCont().removeSpecObject(iSpecPersistable);
                        Hibernator.instance().deletePO(deleteSess, iSpecPersistable);
                    }
                    for (ITestSuitePO iTestSuitePO : testSuiteList) {
                        HibernateUtil.removeChildNodes(iTestSuitePO, deleteSess);
                        p.getTestSuiteCont().removeTestSuite(iTestSuitePO);
                        Hibernator.instance().deletePO(deleteSess, iTestSuitePO);
                    }
                    deleteSess.flush();
                    Hibernator.instance().deletePO(deleteSess, p);
                    CompNamePM.deleteCompNames(deleteSess, projId);
                    Hibernator.instance().commitTransaction(deleteSess, tx);
                    tx = null;
                }
                catch (PersistenceException e) {
                    ProjectPM.handleDBExceptionForAnySession(p, e, deleteSess);
                    Hibernator.instance().dropSession(deleteSess);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                Hibernator.instance().dropSession(deleteSess);
                throw throwable;
            }
            Hibernator.instance().dropSession(deleteSess);
        }
        ProjectNameBP.getInstance().checkAndDeleteName(proj.getGuid());
    }

    private static void deleteProjectIndependentDBObjects(EntityManager s, IProjectPO p) throws PMException, ProjectDeletedException {
        UsedToolkitBP.getInstance().deleteToolkitsFromDB(s, p.getId(), false);
        ParamNamePM.deleteParamNames(s, p.getId(), false);
    }

    private static int getTotalWorkForSave(IProjectPO proj) {
        int totalWork = 1;
        for (ITestSuitePO testSuite : proj.getTestSuiteCont().getTestSuiteList()) {
            totalWork += ProjectPM.getWorkForNode(testSuite);
        }
        for (ISpecPersistable spec : proj.getSpecObjCont().getSpecObjList()) {
            totalWork += ProjectPM.getWorkForNode(spec);
        }
        return totalWork *= 4;
    }

    private static int getWorkForNode(INodePO node) {
        int work = 1;
        if (!(node instanceof IExecTestCasePO)) {
            Iterator<INodePO> childIter = node.getNodeListIterator();
            while (childIter.hasNext()) {
                work += ProjectPM.getWorkForNode(childIter.next());
            }
        }
        if (node instanceof ISpecTestCasePO) {
            work += ((ISpecTestCasePO)node).getAllEventEventExecTC().size();
        }
        return work;
    }

    private static void rollbackTransaction(EntityManager s, String msg, EntityTransaction tx) throws PMException {
        try {
            Hibernator.instance().rollbackTransaction(s, tx);
        }
        catch (PersistenceException e) {
            log.error((Object)msg, (Throwable)e);
            GeneralStorage.getInstance().recoverSession();
        }
    }

    public static synchronized String findHighestVersionNumber(String guid) throws JBException {
        EntityManager session = null;
        try {
            session = Hibernator.instance().openSession();
            Query query = session.createQuery("select project from ProjectPO project inner join fetch project.properties where project.guid = :guid order by project.properties.majorNumber desc, project.properties.minorNumber desc");
            query.setParameter("guid", (Object)guid);
            query.setMaxResults(1);
            List projList = query.getResultList();
            if (projList.isEmpty()) {
                return "";
            }
            IProjectPO project = (IProjectPO)projList.get(0);
            String string = project.getMajorProjectVersion() + "." + project.getMinorProjectVersion();
            return string;
        }
        catch (PersistenceException e) {
            log.error((Object)Messages.HibernateLoadFailed, (Throwable)e);
            throw new JBException(e.getMessage(), MessageIDs.E_HIBERNATE_LOAD_FAILED);
        }
        finally {
            Hibernator.instance().dropSessionWithoutLockRelease(session);
        }
    }

    public static synchronized List<IProjectPO> findReusableProjects(String guid, int majorVersionNumber, int minorVersionNumber, String toolkit, String toolkitLevel) throws JBException {
        EntityManager session = null;
        try {
            session = Hibernator.instance().openSession();
            Query query = session.createQuery("select project from ProjectPO project inner join fetch project.properties where project.properties.isReusable = :isReusable and project.guid != :guid");
            query.setParameter("isReusable", (Object)true);
            query.setParameter("guid", (Object)guid);
            List projects = query.getResultList();
            Iterator iter = projects.iterator();
            while (iter.hasNext()) {
                IProjectPO project = (IProjectPO)iter.next();
                String reusedToolkit = project.getToolkit();
                try {
                    String reusedToolkitLevel = ToolkitSupportBP.getToolkitLevel((String)reusedToolkit);
                    if (reusedToolkit.equals(toolkit) || ToolkitUtils.doesToolkitInclude((String)toolkit, (String)reusedToolkit) || ToolkitUtils.isToolkitMoreConcrete((String)toolkitLevel, (String)reusedToolkitLevel)) continue;
                    iter.remove();
                }
                catch (ToolkitPluginException toolkitPluginException) {
                    StringBuilder msg = new StringBuilder();
                    msg.append(Messages.Project);
                    msg.append(" ");
                    msg.append(project.getName());
                    msg.append(" ");
                    msg.append(Messages.CouldNotBeLoadedAnUnavailableToolkitPlugin);
                    msg.append(".");
                    log.error((Object)msg.toString());
                    iter.remove();
                }
            }
            HashSet<IProjectPO> checkedProjects = new HashSet<IProjectPO>();
            HashSet<IProjectPO> illegalProjects = new HashSet<IProjectPO>();
            IProjectPO givenProject = ProjectPM.loadProjectByGuidAndVersion(guid, majorVersionNumber, minorVersionNumber);
            if (givenProject == null) {
                log.debug((Object)Messages.TriedFindProjectsForNonExistantProject);
                ArrayList<IProjectPO> arrayList = new ArrayList<IProjectPO>();
                return arrayList;
            }
            illegalProjects.add(givenProject);
            checkedProjects.add(givenProject);
            for (IProjectPO proj : projects) {
                ProjectPM.findIllegalProjects(proj, checkedProjects, illegalProjects, null);
            }
            projects.removeAll(illegalProjects);
            List list = projects;
            return list;
        }
        catch (PersistenceException e) {
            log.error((Object)Messages.HibernateLoadFailed, (Throwable)e);
            throw new JBException(e.getMessage(), MessageIDs.E_HIBERNATE_LOAD_FAILED);
        }
        finally {
            Hibernator.instance().dropSessionWithoutLockRelease(session);
        }
    }

    public static void findIllegalProjects(IProjectPO projectToCheck, Set<IProjectPO> checkedProjects, Set<IProjectPO> illegalProjects, Set<IProjectPO> projectsToImport) {
        if (!checkedProjects.contains(projectToCheck)) {
            checkedProjects.add(projectToCheck);
            block2: for (IReusedProjectPO reused : projectToCheck.getUsedProjects()) {
                try {
                    String reusedGuid = reused.getProjectGuid();
                    Integer reusedMajorVersion = reused.getMajorNumber();
                    Integer reusedMinorVersion = reused.getMinorNumber();
                    IProjectPO reusedProject = null;
                    if (projectsToImport != null) {
                        for (IProjectPO importedProject : projectsToImport) {
                            if (!reusedGuid.equals(importedProject.getGuid()) || !reusedMajorVersion.equals(importedProject.getMajorProjectVersion()) || !reusedMinorVersion.equals(importedProject.getMinorProjectVersion())) continue;
                            reusedProject = importedProject;
                            break;
                        }
                    }
                    if (reusedProject == null) {
                        reusedProject = ProjectPM.loadProjectByGuidAndVersion(reused.getProjectGuid(), reused.getMajorNumber(), reused.getMinorNumber());
                    }
                    if (reusedProject != null) {
                        ProjectPM.findIllegalProjects(reusedProject, checkedProjects, illegalProjects, projectsToImport);
                    }
                }
                catch (JBException jBException) {
                    illegalProjects.add(projectToCheck);
                }
                for (IProjectPO project : illegalProjects) {
                    if (!project.getGuid().equals(reused.getProjectGuid()) || !project.getMajorProjectVersion().equals(reused.getMajorNumber()) || !project.getMinorProjectVersion().equals(reused.getMinorNumber())) continue;
                    illegalProjects.add(projectToCheck);
                    continue block2;
                }
            }
        }
    }

    public static synchronized IProjectPO loadProjectById(Long projectId, EntityManager session) throws JBException {
        if (projectId == null) {
            return null;
        }
        try {
            Query query = session.createQuery("select project from ProjectPO project where project.id = :id");
            query.setParameter("id", (Object)projectId);
            try {
                return (IProjectPO)query.getSingleResult();
            }
            catch (NoResultException noResultException) {
                return null;
            }
        }
        catch (PersistenceException e) {
            OperationCanceledException oce = ProjectPM.checkForCancel(e);
            if (oce != null) {
                throw oce;
            }
            log.error((Object)Messages.HibernateLoadFailed, (Throwable)e);
            throw new JBException(e.getMessage(), MessageIDs.E_HIBERNATE_LOAD_FAILED);
        }
    }

    public static IProjectPO loadProjectById(Long projectId) throws JBException {
        EntityManager session = null;
        try {
            session = Hibernator.instance().openSession();
            IProjectPO iProjectPO = ProjectPM.loadProjectById(projectId, session);
            return iProjectPO;
        }
        finally {
            Hibernator.instance().dropSessionWithoutLockRelease(session);
        }
    }

    public static synchronized List<Long> findIdsThatReuse(String guid, int majorVersion, int minorVersion) throws JBException {
        List hits;
        EntityManager session = null;
        try {
            try {
                session = Hibernator.instance().openSession();
                Query query = session.createQuery("select reusedProject.hbmParentProjectId from ReusedProjectPO as reusedProject where reusedProject.projectGuid = :projectGuid and reusedProject.majorNumber = :majorNumber and reusedProject.minorNumber = :minorNumber");
                query.setParameter("projectGuid", (Object)guid);
                query.setParameter("majorNumber", (Object)majorVersion);
                query.setParameter("minorNumber", (Object)minorVersion);
                hits = query.getResultList();
            }
            catch (PersistenceException e) {
                log.error((Object)Messages.HibernateLoadFailed, (Throwable)e);
                throw new JBException(e.getMessage(), MessageIDs.E_HIBERNATE_LOAD_FAILED);
            }
        }
        finally {
            Hibernator.instance().dropSessionWithoutLockRelease(session);
        }
        return hits;
    }

    public static final synchronized String getGuidOfProjectId(Long projId) throws JBException {
        EntityManager session = null;
        String projGuid = null;
        try {
            try {
                session = Hibernator.instance().openSession();
                Query query = session.createQuery("select project.guid from ProjectPO project where project.id = :projectID");
                query.setParameter("projectID", (Object)projId);
                projGuid = (String)query.getSingleResult();
            }
            catch (NoResultException noResultException) {
                Hibernator.instance().dropSessionWithoutLockRelease(session);
            }
            catch (PersistenceException e) {
                throw new JBException(e.getMessage(), MessageIDs.E_HIBERNATE_LOAD_FAILED);
            }
        }
        finally {
            Hibernator.instance().dropSessionWithoutLockRelease(session);
        }
        return projGuid;
    }

    public static boolean doesProjectExist(Long projectId) {
        List hits;
        block5: {
            EntityManager session = null;
            hits = null;
            try {
                try {
                    session = Hibernator.instance().openSession();
                    Query q = session.createQuery("select node from ProjectPO as node where node.id = ?1");
                    q.setParameter(1, (Object)projectId);
                    hits = q.getResultList();
                }
                catch (PersistenceException e) {
                    log.error((Object)Messages.HibernateLoadFailed, (Throwable)e);
                    Hibernator.instance().dropSessionWithoutLockRelease(session);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Hibernator.instance().dropSessionWithoutLockRelease(session);
                throw throwable;
            }
            Hibernator.instance().dropSessionWithoutLockRelease(session);
        }
        return hits != null && hits.size() > 0;
    }
}

