/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.persistence;

import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang.time.DateUtils;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.ITestResultPO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.Hibernator;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.TestResultSummaryPM;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.exception.JBFatalException;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestResultPM {
    private TestResultPM() {
    }

    public static final void storeTestResult(EntityManager session) {
        try {
            try {
                EntityTransaction tx = Hibernator.instance().getTransaction(session);
                Hibernator.instance().commitTransaction(session, tx);
            }
            catch (PMException e) {
                throw new JBFatalException(Messages.StoringOfTestResultsFailed, (Throwable)((Object)e), MessageIDs.E_DATABASE_GENERAL);
            }
            catch (ProjectDeletedException e) {
                throw new JBFatalException(Messages.StoringOfTestResultsFailed, (Throwable)e, MessageIDs.E_PROJECT_NOT_FOUND);
            }
        }
        finally {
            Hibernator.instance().dropSession(session);
        }
    }

    private static final void deleteTestresultOfSummary(Long resultId) {
        Hibernator hibernator = Hibernator.instance();
        if (hibernator == null) {
            return;
        }
        EntityManager session = hibernator.openSession();
        try {
            try {
                EntityTransaction tx = hibernator.getTransaction(session);
                hibernator.lockDB();
                TestResultPM.executeDeleteTestresultOfSummary(session, resultId);
                TestResultPM.deleteMonitoringReports(session, resultId);
                hibernator.commitTransaction(session, tx);
            }
            catch (PMException e) {
                throw new JBFatalException(Messages.DeleteTestresultElementFailed, (Throwable)((Object)e), MessageIDs.E_DATABASE_GENERAL);
            }
            catch (ProjectDeletedException e) {
                throw new JBFatalException(Messages.DeleteTestresultElementFailed, (Throwable)e, MessageIDs.E_PROJECT_NOT_FOUND);
            }
        }
        finally {
            hibernator.dropSession(session);
            hibernator.unlockDB();
        }
    }

    private static void deleteMonitoringReports(EntityManager session, Long summaryId) {
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("update ").append(PoMaker.getTestResultSummaryClass().getSimpleName()).append(" summary set summary.report = :report, summary.reportWritten = :isReportWritten");
        if (summaryId != null) {
            queryBuilder.append(" where summary.id = :id");
        }
        Query q = session.createQuery(queryBuilder.toString());
        q.setParameter("report", null);
        q.setParameter("isReportWritten", (Object)false);
        if (summaryId != null) {
            q.setParameter("id", (Object)summaryId);
        }
        q.executeUpdate();
    }

    public static final void executeDeleteTestresultOfSummary(EntityManager session, Long resultId) {
        boolean isDeleteAll = resultId == null;
        String paramQueryBaseString = "delete from PARAMETER_DETAILS";
        if (isDeleteAll) {
            session.createNativeQuery(paramQueryBaseString).executeUpdate();
        } else {
            Query paramQuery = session.createNativeQuery(String.valueOf(paramQueryBaseString) + " where FK_TESTRESULT in (select ID from TESTRESULT where INTERNAL_TESTRUN_ID = #summaryId)");
            paramQuery.setParameter("summaryId", (Object)resultId);
            paramQuery.executeUpdate();
        }
        StringBuilder resultQueryBuilder = new StringBuilder();
        resultQueryBuilder.append("delete from TestResultPO testResult");
        if (!isDeleteAll) {
            resultQueryBuilder.append(" where testResult.internalTestResultSummaryID = :id");
        }
        Query resultQuery = session.createQuery(resultQueryBuilder.toString());
        if (!isDeleteAll) {
            resultQuery.setParameter("id", (Object)resultId);
        }
        resultQuery.executeUpdate();
    }

    public static final void deleteAllTestresultDetails() {
        TestResultPM.deleteTestresultOfSummary(null);
    }

    public static final void cleanTestresultDetails(int days, String projGUID, int majorVersion, int minorVersion) {
        Date cleanDate = DateUtils.addDays((Date)new Date(), (int)(days * -1));
        try {
            Set<Long> summaries = TestResultSummaryPM.findTestResultSummariesByDate(cleanDate, projGUID, majorVersion, minorVersion);
            for (Long summaryId : summaries) {
                TestResultPM.deleteTestresultOfSummary(summaryId);
            }
            DataEventDispatcher.getInstance().fireTestresultChanged(DataEventDispatcher.TestresultState.Refresh);
        }
        catch (JBException e) {
            throw new JBFatalException(Messages.DeletingTestresultsFailed, (Throwable)e, MessageIDs.E_DELETE_TESTRESULT);
        }
    }

    public static List<ITestResultPO> computeTestResultListForSummary(EntityManager session, Long summaryId) {
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery();
        Root from = query.from(PoMaker.getTestResultClass());
        query.orderBy(new Order[]{builder.asc((Expression)from.get("keywordSequence"))}).select((Selection)from).where((Expression)builder.equal((Expression)from.get("internalTestResultSummaryID"), (Object)summaryId));
        return session.createQuery(query).getResultList();
    }

    public static boolean hasTestResultDetails(EntityManager session, Long summaryId) {
        boolean hasDetails = false;
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery();
        Root from = query.from(PoMaker.getTestResultClass());
        query.select((Selection)builder.count((Expression)from)).where((Expression)builder.equal((Expression)from.get("internalTestResultSummaryID"), (Object)summaryId));
        Number result = (Number)session.createQuery(query).getSingleResult();
        if (result.longValue() > 0L) {
            hasDetails = true;
        }
        return hasDetails;
    }

    public static List<Number> computeTestresultIdsWithDetails(EntityManager session) {
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery();
        Path from = query.from(PoMaker.getTestResultClass()).get("internalTestResultSummaryID");
        query.select((Selection)from).distinct(true);
        return session.createQuery(query).getResultList();
    }
}

