/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.jubula.client.core.utils.LocaleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Languages {
    private static Languages instance = null;
    private Set m_projectLanguages = new HashSet();
    private Map<Locale, String> m_localeToDisplayMap;
    private Map<String, Locale> m_displayToLocaleMap;
    private List<Locale> m_suppLangList = new ArrayList<Locale>();

    private Languages() {
        this.initMap();
    }

    public static Languages getInstance() {
        if (instance == null) {
            instance = Languages.createInstance();
        }
        return instance;
    }

    private static synchronized Languages createInstance() {
        if (instance == null) {
            instance = new Languages();
        }
        return instance;
    }

    private void initMap() {
        this.m_localeToDisplayMap = new HashMap<Locale, String>();
        this.m_displayToLocaleMap = new HashMap<String, Locale>();
        Locale[] localeArray = Locale.getAvailableLocales();
        int n = localeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Locale l = localeArray[n2];
            if (!"".equals(l.getCountry())) {
                this.m_suppLangList.add(l);
                String displayName = l.getDisplayName(Locale.getDefault());
                this.m_localeToDisplayMap.put(l, displayName);
                this.m_displayToLocaleMap.put(displayName, l);
            }
            ++n2;
        }
    }

    public void setProjectLanguages(Set union) {
        this.m_projectLanguages = union;
    }

    public Locale getLocale(String displayString) {
        if (!this.m_displayToLocaleMap.containsKey(displayString)) {
            Locale locale = LocaleUtil.convertStrToLocale(displayString);
            this.m_localeToDisplayMap.put(locale, displayString);
            this.m_displayToLocaleMap.put(displayString, locale);
        }
        return this.m_displayToLocaleMap.get(displayString);
    }

    public String getDisplayString(Locale locale) {
        if (!this.m_localeToDisplayMap.containsKey(locale)) {
            String displayString = locale.getDisplayName();
            this.m_localeToDisplayMap.put(locale, displayString);
            this.m_displayToLocaleMap.put(displayString, locale);
        }
        return this.m_localeToDisplayMap.get(locale);
    }

    public Set getProjectLanguages() {
        return this.m_projectLanguages;
    }

    public List<Locale> getSuppLangList() {
        return this.m_suppLangList;
    }
}

