/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.utils.IGenericListener;
import org.eclipse.jubula.tools.exception.UnexpectedGenericTypeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerManager<TYPE extends IGenericListener> {
    private static final Log LOG = LogFactory.getLog(ListenerManager.class);
    private Set<TYPE> m_listeners = new HashSet<TYPE>();

    public void addListener(TYPE l) {
        this.m_listeners.add(l);
    }

    public void removeListener(TYPE l) {
        this.m_listeners.remove(l);
    }

    public void fireNotification(List<? extends Object> params) {
        HashSet<TYPE> stableListeners = new HashSet<TYPE>(this.m_listeners);
        for (IGenericListener l : stableListeners) {
            try {
                l.checkGenericListElementType(params);
                l.eventOccured(params);
            }
            catch (UnexpectedGenericTypeException u) {
                LOG.error((Object)u.getMessage());
            }
            catch (Throwable t) {
                LOG.error((Object)Messages.UnhandledExceptionWhileCallingListeners, t);
            }
        }
    }
}

